/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Annotation;
import gov.noaa.pmel.sgt.dm.Annote;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;

public class AnnotationCartesianRenderer
extends CartesianRenderer {
    private Annotation data_ = null;

    public AnnotationCartesianRenderer(CartesianGraph cartesianGraph, Annotation annotation, Attribute attribute) {
        this.cg_ = cartesianGraph;
        this.data_ = annotation;
    }

    public Attribute getAttribute() {
        return null;
    }

    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    public SGTData getDataAt(Point point) {
        Rectangle rectangle;
        Iterator iterator;
        SGTData sGTData = null;
        Annote annote = null;
        if (this.data_.hasLine()) {
            iterator = this.data_.getLineIterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                rectangle = annote.getBounds(this.cg_);
                if (!annote.getBounds(this.cg_).contains(point)) continue;
                return annote;
            }
        }
        if (this.data_.hasPoint()) {
            iterator = this.data_.getPointIterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                rectangle = annote.getBounds(this.cg_);
                if (!rectangle.contains(point)) continue;
                return annote;
            }
        }
        if (this.data_.hasText()) {
            iterator = this.data_.getTextIterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                rectangle = annote.getBounds(this.cg_);
                if (!rectangle.contains(point)) continue;
                return annote;
            }
        }
        if (this.data_.hasOval()) {
            iterator = this.data_.getOvalIterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                rectangle = annote.getBounds(this.cg_);
                if (!rectangle.contains(point)) continue;
                return annote;
            }
        }
        if (this.data_.hasRect()) {
            iterator = this.data_.getRectIterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                rectangle = annote.getBounds(this.cg_);
                if (!rectangle.contains(point)) continue;
                return annote;
            }
        }
        return sGTData;
    }

    public void draw(Graphics graphics) {
        if (this.cg_.clipping_) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.cg_.xTransform_.isSpace()) {
                n8 = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                n8 = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                n6 = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                n6 = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (n8 < n7) {
                n4 = n8;
                n3 = n7 - n8;
            } else {
                n4 = n7;
                n3 = n8 - n7;
            }
            if (n6 < n5) {
                n2 = n6;
                n = n5 - n6;
            } else {
                n2 = n5;
                n = n6 - n5;
            }
            graphics.setClip(n4, n2, n3, n);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.data_.hasLine()) {
            Iterator iterator = this.data_.getLineIterator();
            while (iterator.hasNext()) {
                Annote.Line line = (Annote.Line)iterator.next();
                SGTLine sGTLine = line.getLine();
                LineAttribute lineAttribute = line.getAttribute();
                this.renderLine(graphics2D, sGTLine, lineAttribute);
            }
        }
        if (this.data_.hasPoint()) {
            Iterator iterator = this.data_.getPointIterator();
            while (iterator.hasNext()) {
                Annote.Point point = (Annote.Point)iterator.next();
                SGTPoint sGTPoint = point.getPoint();
                PointAttribute pointAttribute = point.getAttribute();
                this.renderPoint(graphics2D, sGTPoint, pointAttribute);
            }
        }
        if (this.data_.hasText()) {
            Iterator iterator = this.data_.getTextIterator();
            while (iterator.hasNext()) {
                Annote.Text text = (Annote.Text)iterator.next();
                SGLabel sGLabel = text.getText();
                SoTPoint soTPoint = text.getLocation();
                this.renderText(graphics2D, soTPoint, sGLabel);
            }
        }
        if (this.data_.hasOval()) {
            Iterator iterator = this.data_.getOvalIterator();
            while (iterator.hasNext()) {
                Annote.Oval oval = (Annote.Oval)iterator.next();
                SoTPoint soTPoint = oval.getUpperLeft();
                SoTPoint soTPoint2 = oval.getLowerRight();
                LineAttribute lineAttribute = oval.getLineAttribute();
                Color color = oval.getFillColor();
                this.renderOval(graphics2D, soTPoint, soTPoint2, lineAttribute, color);
            }
        }
        if (this.data_.hasRect()) {
            Iterator iterator = this.data_.getRectIterator();
            while (iterator.hasNext()) {
                Annote.Rect rect = (Annote.Rect)iterator.next();
                SoTPoint soTPoint = rect.getUpperLeft();
                SoTPoint soTPoint3 = rect.getLowerRight();
                LineAttribute lineAttribute = rect.getLineAttribute();
                Color color = rect.getFillColor();
                this.renderRect(graphics2D, soTPoint, soTPoint3, lineAttribute, color);
            }
        }
        Rectangle rectangle = this.cg_.getLayer().getPane().getBounds();
        graphics.setClip(rectangle);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("AnnotationCartesianRenderer: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    private void renderOval(Graphics2D graphics2D, SoTPoint soTPoint, SoTPoint soTPoint2, LineAttribute lineAttribute, Color color) {
        Stroke stroke = this.getStrokeFromLineAttribute(lineAttribute);
        float f = (float)this.cg_.getXUtoD2(soTPoint.getX());
        float f2 = (float)this.cg_.getYUtoD2(soTPoint.getY());
        float f3 = (float)this.cg_.getXUtoD2(soTPoint2.getX());
        float f4 = (float)this.cg_.getYUtoD2(soTPoint2.getY());
        float f5 = f3 - f;
        float f6 = f4 - f2;
        Ellipse2D.Float float_ = new Ellipse2D.Float(f, f2, f5, f6);
        Paint paint = graphics2D.getPaint();
        Stroke stroke2 = graphics2D.getStroke();
        Color color2 = graphics2D.getColor();
        if (color != null) {
            graphics2D.setPaint(color);
            graphics2D.fill(float_);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(lineAttribute.getColor());
            graphics2D.draw(float_);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke2);
        graphics2D.setColor(color2);
    }

    private void renderRect(Graphics2D graphics2D, SoTPoint soTPoint, SoTPoint soTPoint2, LineAttribute lineAttribute, Color color) {
        Stroke stroke = this.getStrokeFromLineAttribute(lineAttribute);
        float f = (float)this.cg_.getXUtoD2(soTPoint.getX());
        float f2 = (float)this.cg_.getYUtoD2(soTPoint.getY());
        float f3 = (float)this.cg_.getXUtoD2(soTPoint2.getX());
        float f4 = (float)this.cg_.getYUtoD2(soTPoint2.getY());
        float f5 = f3 - f;
        float f6 = f4 - f2;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f5, f6);
        Paint paint = graphics2D.getPaint();
        Stroke stroke2 = graphics2D.getStroke();
        Color color2 = graphics2D.getColor();
        if (color != null) {
            graphics2D.setPaint(color);
            graphics2D.fill(float_);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(lineAttribute.getColor());
            graphics2D.draw(float_);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke2);
        graphics2D.setColor(color2);
    }

    private void renderLine(Graphics2D graphics2D, SGTLine sGTLine, LineAttribute lineAttribute) {
        LineCartesianRenderer lineCartesianRenderer = new LineCartesianRenderer(this.cg_, sGTLine, lineAttribute);
        lineCartesianRenderer.draw(graphics2D);
    }

    private void renderPoint(Graphics2D graphics2D, SGTPoint sGTPoint, PointAttribute pointAttribute) {
        PointCartesianRenderer pointCartesianRenderer = new PointCartesianRenderer(this.cg_, sGTPoint, pointAttribute);
        pointCartesianRenderer.draw(graphics2D);
    }

    private void renderText(Graphics2D graphics2D, SoTPoint soTPoint, SGLabel sGLabel) {
        double d = soTPoint.getX().isTime() ? this.cg_.getXUtoP(soTPoint.getX().getLongTime()) : this.cg_.getXUtoP(((Number)soTPoint.getX().getObjectValue()).doubleValue());
        double d2 = soTPoint.getY().isTime() ? this.cg_.getYUtoP(soTPoint.getY().getLongTime()) : this.cg_.getYUtoP(((Number)soTPoint.getY().getObjectValue()).doubleValue());
        sGLabel.setLocationP(new Point2D.Double(d, d2));
        sGLabel.setLayer(this.cg_.getLayer());
        try {
            sGLabel.draw(graphics2D);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            layerNotFoundException.printStackTrace();
        }
    }

    private Stroke getStrokeFromLineAttribute(LineAttribute lineAttribute) {
        BasicStroke basicStroke = null;
        if (lineAttribute == null) {
            return basicStroke;
        }
        switch (lineAttribute.getStyle()) {
            case 2: {
                basicStroke = new BasicStroke(lineAttribute.getWidth());
                break;
            }
            case 1: {
                float[] fArray = new float[]{4.0f, 4.0f};
                basicStroke = new BasicStroke(1.0f, 2, 0, 10.0f, fArray, 0.0f);
                break;
            }
            case 6: {
                float[] fArray = lineAttribute.getDashArray();
                if (fArray == null || fArray.length <= 1) {
                    basicStroke = new BasicStroke(lineAttribute.getWidth(), lineAttribute.getCapStyle(), lineAttribute.getMiterStyle(), lineAttribute.getMiterLimit());
                    break;
                }
                basicStroke = new BasicStroke(lineAttribute.getWidth(), lineAttribute.getCapStyle(), lineAttribute.getMiterStyle(), lineAttribute.getMiterLimit(), lineAttribute.getDashArray(), lineAttribute.getDashPhase());
                break;
            }
        }
        return basicStroke;
    }
}

