/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ArrayEditDialog
extends JDialog
implements ListSelectionListener {
    private DefaultListModel model_;
    private int result_;
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();
    JScrollPane JScrollPane1 = new JScrollPane();
    JList arrayList = new JList();
    JPanel JPanel2 = new JPanel();
    JTextField editTextField = new JTextField();
    JButton editButton = new JButton();
    JPanel JPanel3 = new JPanel();
    JButton deleteButton = new JButton();
    JPanel JPanel1 = new JPanel();
    JTextField insertTextField = new JTextField();
    JButton beforeButton = new JButton();
    JButton afterButton = new JButton();
    TitledBorder titledBorder1 = new TitledBorder("Insert Element");
    TitledBorder titledBorder2 = new TitledBorder("Edit Element");
    TitledBorder titledBorder3 = new TitledBorder("Delete Element");

    public ArrayEditDialog(Frame frame) {
        super(frame);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(322, 349);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.JScrollPane1, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 155, 0));
        this.arrayList.setSelectionMode(0);
        this.JScrollPane1.getViewport().add(this.arrayList);
        this.arrayList.setBounds(0, 0, 173, 295);
        this.JPanel2.setBorder(this.titledBorder2);
        this.JPanel2.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.JPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.JPanel2.add((Component)this.editTextField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.editButton.setToolTipText("Change value of selected element.");
        this.editButton.setText("Change Value");
        this.JPanel2.add((Component)this.editButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.JPanel3.setBorder(this.titledBorder3);
        this.JPanel3.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.JPanel3, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.deleteButton.setToolTipText("Delete selected element.");
        this.deleteButton.setText("Delete");
        this.JPanel3.add((Component)this.deleteButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.JPanel1.setBorder(this.titledBorder1);
        this.JPanel1.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.JPanel1, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.JPanel1.add((Component)this.insertTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.beforeButton.setToolTipText("Insert new item before selected element.");
        this.beforeButton.setText("Before");
        this.JPanel1.add((Component)this.beforeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.afterButton.setToolTipText("Insert new item after selected element.");
        this.afterButton.setText("After");
        this.JPanel1.add((Component)this.afterButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.setTitle("Edit Array");
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.cancelButton.addActionListener(symAction);
        this.okButton.addActionListener(symAction);
        this.editButton.addActionListener(symAction);
        this.beforeButton.addActionListener(symAction);
        this.afterButton.addActionListener(symAction);
        this.deleteButton.addActionListener(symAction);
        this.arrayList.addListSelectionListener(this);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public ArrayEditDialog(String string) {
        this();
        this.setTitle(string);
    }

    public ArrayEditDialog() {
        this((Frame)null);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    void ArrayEditDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.result_ = OK_RESPONSE;
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        float[] fArray = new float[]{0.0f, 2.0f, 2.5f, 3.0f, 4.5f};
        ArrayEditDialog arrayEditDialog = new ArrayEditDialog();
        arrayEditDialog.setTitle("Test ArrayEdit Dialog");
        arrayEditDialog.setArray(fArray);
        if (arrayEditDialog.showDialog() == CANCEL_RESPONSE) {
            System.out.println("Dialog Cancelled");
        } else {
            float[] fArray2 = arrayEditDialog.getFloatArray();
            for (int i = 0; i < fArray2.length; ++i) {
                System.out.println("x[" + i + "] = " + fArray2[i]);
            }
        }
        arrayEditDialog.setVisible(false);
        arrayEditDialog.dispose();
        System.exit(0);
    }

    public int showDialog() {
        this.result_ = CANCEL_RESPONSE;
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    public void setArray(float[] fArray) {
        this.model_ = new DefaultListModel();
        for (int i = 0; i < fArray.length; ++i) {
            this.model_.addElement(Float.toString(fArray[i]));
        }
        this.arrayList.setModel(this.model_);
    }

    public float[] getFloatArray() {
        float[] fArray = new float[this.model_.size()];
        Enumeration enumeration = this.model_.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            fArray[n] = new Float((String)enumeration.nextElement()).floatValue();
            ++n;
        }
        return fArray;
    }

    void editButton_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.model_.size(); ++i) {
            if (!this.arrayList.isSelectedIndex(i)) continue;
            this.model_.set(i, this.editTextField.getText());
            return;
        }
    }

    void beforeButton_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.model_.size(); ++i) {
            if (!this.arrayList.isSelectedIndex(i)) continue;
            this.model_.insertElementAt(this.insertTextField.getText(), i);
            return;
        }
    }

    void afterButton_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.model_.size(); ++i) {
            if (!this.arrayList.isSelectedIndex(i)) continue;
            this.model_.insertElementAt(this.insertTextField.getText(), i + 1);
            return;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        for (int i = n; i <= n2; ++i) {
            if (!this.arrayList.isSelectedIndex(i)) continue;
            this.editTextField.setText((String)this.model_.get(i));
        }
    }

    void deleteButton_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.model_.size(); ++i) {
            if (!this.arrayList.isSelectedIndex(i)) continue;
            this.model_.removeElementAt(i);
            return;
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ArrayEditDialog.this.cancelButton) {
                ArrayEditDialog.this.cancelButton_actionPerformed(actionEvent);
            } else if (object == ArrayEditDialog.this.okButton) {
                ArrayEditDialog.this.okButton_actionPerformed(actionEvent);
            } else if (object == ArrayEditDialog.this.editButton) {
                ArrayEditDialog.this.editButton_actionPerformed(actionEvent);
            } else if (object == ArrayEditDialog.this.beforeButton) {
                ArrayEditDialog.this.beforeButton_actionPerformed(actionEvent);
            } else if (object == ArrayEditDialog.this.afterButton) {
                ArrayEditDialog.this.afterButton_actionPerformed(actionEvent);
            }
            if (object == ArrayEditDialog.this.deleteButton) {
                ArrayEditDialog.this.deleteButton_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == ArrayEditDialog.this) {
                ArrayEditDialog.this.ArrayEditDialog_WindowClosing(windowEvent);
            }
        }
    }
}

