/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.swing.Draggable;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.net.URL;
import javax.swing.ImageIcon;

public class UserIcon
extends ImageIcon
implements LayerChild,
Draggable {
    private boolean selected_ = false;
    private boolean selectable_ = true;
    protected boolean moved_ = false;
    protected Layer layer_ = null;
    private String id_ = null;
    private boolean visible_ = true;
    protected Rectangle bounds_ = new Rectangle();
    protected Point2D.Double loc_ = new Point2D.Double();
    protected SoTPoint uLoc_ = new SoTPoint(0.0, 0.0);
    private Font font_ = new Font("Dialog", 0, 10);
    private Color textColor_ = Color.black;
    protected PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);

    public UserIcon(String string, String string2) {
        super(string, string2);
    }

    public UserIcon(URL uRL, String string) {
        super(uRL, string);
    }

    public UserIcon(Image image, String string) {
        super(image, string);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.computeBounds(graphics);
        this.bounds_.x = n;
        this.bounds_.y = n2;
        if (this.visible_) {
            graphics.drawImage(this.getImage(), this.bounds_.x, this.bounds_.y, this.layer_.getPane().getComponent());
            int n3 = this.bounds_.x + super.getIconWidth();
            int n4 = this.bounds_.y + super.getIconHeight();
            graphics.setFont(this.font_);
            graphics.setColor(this.textColor_);
            graphics.drawString(this.getDescription(), n3, n4);
        }
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public Font getFont() {
        return this.font_;
    }

    public int getIconWidth() {
        return this.bounds_.width;
    }

    public int getIconHeight() {
        return this.bounds_.height;
    }

    private void computeBounds(Graphics graphics) {
        int n = super.getIconWidth();
        int n2 = super.getIconHeight();
        graphics.setFont(this.font_);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.bounds_.width = n + fontMetrics.stringWidth(this.getDescription());
        this.bounds_.height = n2;
    }

    public LayerChild copy() {
        return null;
    }

    public void setVisible(boolean bl) {
        if (this.visible_ != bl) {
            this.visible_ = bl;
        }
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void draw(Graphics graphics) {
        int n = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLoc_.getX());
        int n2 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLoc_.getY());
        this.paintIcon(this.layer_.getPane().getComponent(), graphics, n, n2);
    }

    public String getId() {
        return this.id_;
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    public void modified(String string) {
        if (this.layer_ != null) {
            this.layer_.modified(string);
        }
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
    }

    public String toString() {
        return "UserIcon: " + this.id_;
    }

    public Rectangle getBounds() {
        return this.bounds_;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean isSelectable() {
        return this.selectable_;
    }

    public void setSelectable(boolean bl) {
        this.selectable_ = bl;
    }

    public Point2D.Double getLocationP() {
        return this.loc_;
    }

    public void setLocationP(Point2D.Double double_) {
        this.loc_ = double_;
        this.bounds_.x = this.layer_.getXPtoD(this.loc_.x);
        this.bounds_.y = this.layer_.getYPtoD(this.loc_.y);
        SoTPoint soTPoint = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        if (!soTPoint.equals(this.uLoc_) || this.moved_) {
            this.changes_.firePropertyChange("location", this.uLoc_, soTPoint);
            this.uLoc_ = soTPoint;
            this.moved_ = false;
        }
    }

    public SoTPoint getLocationU() {
        return this.uLoc_;
    }

    public void setLocationUNoVeto(SoTPoint soTPoint) {
        this.moved_ = this.moved_ || !soTPoint.equals(this.uLoc_);
        this.uLoc_ = soTPoint;
        this.loc_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLoc_.getX());
        this.loc_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLoc_.getY());
        this.bounds_.x = this.layer_.getXPtoD(this.loc_.x);
        this.bounds_.y = this.layer_.getYPtoD(this.loc_.y);
    }

    public void setLocationU(SoTPoint soTPoint) throws PropertyVetoException {
        if (!soTPoint.equals(this.uLoc_) || this.moved_) {
            this.vetos_.fireVetoableChange("location", this.uLoc_, soTPoint);
            this.changes_.firePropertyChange("location", this.uLoc_, soTPoint);
            this.uLoc_ = soTPoint;
            this.moved_ = false;
            this.loc_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLoc_.getX());
            this.loc_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLoc_.getY());
            this.bounds_.x = this.layer_.getXPtoD(this.loc_.x);
            this.bounds_.y = this.layer_.getYPtoD(this.loc_.y);
        }
    }

    public void setLocationNoVeto(int n, int n2) {
        this.bounds_.x = n;
        this.bounds_.y = n2;
        this.loc_.x = this.layer_.getXDtoP(n);
        this.loc_.y = this.layer_.getYDtoP(n2);
        SoTPoint soTPoint = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        this.moved_ = this.moved_ || !soTPoint.equals(this.uLoc_);
        this.uLoc_ = soTPoint;
    }

    public void setLocation(Point point) {
        this.setLocation(point, true);
    }

    public void setLocation(Point point, boolean bl) {
        this.setBounds(point.x, point.y, 0, 0, bl);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, true);
    }

    protected void setBounds(int n, int n2, int n3, int n4, boolean bl) {
        this.bounds_.x = n;
        this.bounds_.y = n2;
        this.loc_.x = this.layer_.getXDtoP(n);
        this.loc_.y = this.layer_.getYDtoP(n2);
        SoTPoint soTPoint = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        boolean bl2 = this.moved_ = this.moved_ || !soTPoint.equals(this.uLoc_);
        if (this.moved_) {
            SoTPoint soTPoint2 = new SoTPoint(soTPoint);
            if (bl) {
                this.changes_.firePropertyChange("location", this.uLoc_, soTPoint2);
                this.moved_ = false;
            }
            this.uLoc_ = soTPoint2;
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }
}

