/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.SoTRange;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Timer;

public class PseudoRealTimeData
implements SGTLine,
ActionListener {
    private SGTMetaData xMeta_;
    private SGTMetaData yMeta_;
    private SoTRange.GeoDate xRange_;
    private SoTRange.Double yRange_;
    private GeoDate[] xData_;
    private double[] yData_;
    private GeoDate tend_;
    private int count_;
    private String title_;
    private SGLabel keyTitle_ = null;
    private String id_;
    private Timer timer_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private GeoDate ref_ = null;
    private int bufsize_ = 241;
    private int offset_;
    private int offsetIncrement_ = 24;
    private double minorIncrement_ = 1.0;
    private double majorIncrement_ = 24.0;
    private int units_ = 5;
    private double A0_ = 1.0;
    private double A1_ = 0.375;
    private double A2_ = 0.2;
    private double omega0_ = 0.251327412;
    private double omega1_ = 0.3;

    public PseudoRealTimeData(String string, String string2) {
        this.xMeta_ = new SGTMetaData("Time", "");
        this.yMeta_ = new SGTMetaData("PseudoData", "Ps/day");
        this.title_ = string2;
        this.id_ = string;
        this.timer_ = new Timer(250, this);
        this.resetData();
    }

    public double[] getXArray() {
        return null;
    }

    public double[] getYArray() {
        if (this.count_ > 0) {
            double[] dArray = new double[this.count_ + this.offset_];
            for (int i = 0; i < this.count_ + this.offset_; ++i) {
                dArray[i] = this.yData_[i];
            }
            return dArray;
        }
        return null;
    }

    public GeoDate[] getTimeArray() {
        if (this.count_ > 0) {
            GeoDate[] geoDateArray = new GeoDate[this.count_ + this.offset_];
            for (int i = 0; i < this.count_ + this.offset_; ++i) {
                geoDateArray[i] = this.xData_[i];
            }
            return geoDateArray;
        }
        return null;
    }

    public GeoDateArray getGeoDateArray() {
        return new GeoDateArray(this.getTimeArray());
    }

    public SGTLine getAssociatedData() {
        return null;
    }

    public boolean hasAssociatedData() {
        return false;
    }

    public String getTitle() {
        return this.title_;
    }

    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public String getId() {
        return this.id_;
    }

    public SGTData copy() {
        return null;
    }

    public boolean isXTime() {
        return true;
    }

    public boolean isYTime() {
        return false;
    }

    public SGTMetaData getXMetaData() {
        return this.xMeta_;
    }

    public SGTMetaData getYMetaData() {
        return this.yMeta_;
    }

    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void startData() {
        this.timer_.start();
    }

    public void stopData() {
        this.timer_.stop();
    }

    public void resetData() {
        this.xData_ = new GeoDate[this.bufsize_];
        this.yData_ = new double[this.bufsize_];
        try {
            this.ref_ = new GeoDate("1999-01-01 00:00", "yyyy-MM-dd HH:mm");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            illegalTimeValue.printStackTrace();
        }
        this.tend_ = new GeoDate(this.ref_);
        this.tend_.increment(10.0, 7);
        this.yRange_ = new SoTRange.Double(-1.5, 1.5);
        this.xRange_ = new SoTRange.GeoDate(new GeoDate(this.ref_), this.tend_.increment(this.majorIncrement_, this.units_));
        this.xData_[0] = new GeoDate(this.ref_);
        this.yData_[0] = 0.0;
        this.count_ = 1;
        this.offset_ = 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.count_ + this.offset_ >= this.bufsize_) {
            this.offset_ -= this.offsetIncrement_;
            for (int i = 0; i < this.bufsize_ - this.offsetIncrement_; ++i) {
                this.xData_[i] = this.xData_[i + this.offsetIncrement_];
                this.yData_[i] = this.yData_[i + this.offsetIncrement_];
            }
            this.xRange_.start = this.xData_[0];
        }
        this.xData_[this.count_ + this.offset_] = new GeoDate(this.ref_.increment(this.minorIncrement_, this.units_));
        this.yData_[this.count_ + this.offset_] = this.tSeries(this.count_);
        if (this.xData_[this.count_ + this.offset_].after(this.tend_)) {
            SoTRange.GeoDate geoDate = (SoTRange.GeoDate)this.xRange_.copy();
            this.tend_.increment(this.majorIncrement_, this.units_);
            this.xRange_.end = this.tend_;
            this.changes_.firePropertyChange("rangeModified", geoDate, this.xRange_);
        } else {
            this.changes_.firePropertyChange("dataModified", new Integer(this.count_), new Integer(this.count_ + 1));
        }
        ++this.count_;
    }

    private double tSeries(int n) {
        return this.A0_ * Math.sin(this.omega0_ * (double)n) + this.A1_ * Math.sin(this.omega1_ * (double)n) + this.A2_ * Math.random();
    }
}

