/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.BorderDialog;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.sgt.swing.prop.ColorDialog;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PanelHolderPropertyPanel
extends PropertyPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private boolean expert_ = false;
    private PanelHolder pHolder_ = null;
    private String[] pNames_ = new String[]{"Background", "Border", "Bounds", "Data Groups", "Id", "Labels", "Legends", "Page Background", "Visible"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];

    public PanelHolderPropertyPanel(PanelHolder panelHolder, boolean bl) {
        this.pHolder_ = panelHolder;
        this.pHolder_.addChangeListener(this);
        this.expert_ = bl;
        this.create();
    }

    public void setPanelHolder(PanelHolder panelHolder, boolean bl) {
        if (this.pHolder_ != null) {
            this.pHolder_.removeChangeListener(this);
        }
        this.pHolder_ = panelHolder;
        this.pHolder_.addChangeListener(this);
        this.expert_ = bl;
        this.reset();
    }

    void create() {
        int n = -1;
        this.comps_[++n] = this.createColor(this.pHolder_.getBackground(), this.pNames_[n], this);
        this.comps_[++n] = this.createBorder(this.pHolder_.getBorder(), this.pNames_[n], this);
        Rectangle rectangle = this.pHolder_.getBounds();
        this.comps_[++n] = this.createLabel(rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height);
        this.comps_[++n] = this.createLabel(this.pHolder_.getDataGroupSize());
        String string = this.pNames_[++n];
        this.comps_[n] = this.createTextField(this.pHolder_.getId(), string, this, !this.pHolder_.isInstantiated());
        this.comps_[++n] = this.createLabel(this.pHolder_.getLabelSize());
        this.comps_[++n] = this.createLabel(this.pHolder_.getLegendSize());
        this.comps_[++n] = this.createCheckBox(this.pHolder_.isUsePageBackground(), this.pNames_[n], this);
        this.comps_[++n] = this.createCheckBox(this.pHolder_.isVisible(), this.pNames_[n], this);
        for (n = 0; n < this.comps_.length; ++n) {
            this.addProperty(n + 1, this.pNames_[n], this.comps_[n], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    void update() {
        int n = -1;
        this.updateColor((JButton)this.comps_[++n], this.pHolder_.getBackground());
        this.updateBorder((JButton)this.comps_[++n], this.pHolder_.getBorder());
        Rectangle rectangle = this.pHolder_.getBounds();
        ((JLabel)this.comps_[++n]).setText(rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height);
        ((JLabel)this.comps_[++n]).setText(Integer.toString(this.pHolder_.getDataGroupSize()));
        ((JTextField)this.comps_[++n]).setText(this.pHolder_.getId());
        ((JLabel)this.comps_[++n]).setText(Integer.toString(this.pHolder_.getLabelSize()));
        ((JLabel)this.comps_[++n]).setText(Integer.toString(this.pHolder_.getLegendSize()));
        ((JCheckBox)this.comps_[++n]).setSelected(this.pHolder_.isUsePageBackground());
        ((JCheckBox)this.comps_[++n]).setSelected(this.pHolder_.isVisible());
    }

    private void processEvent(Object object, String string) {
        if (string.equals("Border")) {
            BorderDialog borderDialog = new BorderDialog(null, "Select Border", true);
            borderDialog.setBorder(this.pHolder_.getBorder());
            borderDialog.setVisible(true);
            this.pHolder_.setBorder(borderDialog.getBorder());
        } else if (string.equals("Id")) {
            String string2 = this.pHolder_.getId();
            this.pHolder_.getPanelModel().getPanelList().remove(string2);
            this.pHolder_.setId(((JTextField)object).getText());
            this.pHolder_.getPanelModel().getPanelList().put(this.pHolder_.getId(), this.pHolder_);
        } else if (string.equals("Visible")) {
            this.pHolder_.setVisible(((JCheckBox)object).isSelected());
        } else if (string.equals("Background")) {
            ColorDialog colorDialog = new ColorDialog(this.getFrame(), "Select Axis Color", true);
            colorDialog.setColor(this.pHolder_.getBackground());
            colorDialog.setVisible(true);
            Color color = colorDialog.getColor();
            if (color != null) {
                this.pHolder_.setBackground(color);
                this.updateColor((JButton)object, color);
            }
        } else if (string.equals("Page Background")) {
            this.pHolder_.setUsePageBackground(((JCheckBox)object).isSelected());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        this.processEvent(object, string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.update();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            JTextField jTextField = (JTextField)object;
            String string = jTextField.getName();
            this.processEvent(object, string);
        }
    }

    private JButton createBorder(Border border, String string, ActionListener actionListener) {
        JButton jButton = new JButton(this.getBorderDescription(border));
        jButton.setActionCommand(string);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    private void updateBorder(JButton jButton, Border border) {
        jButton.setText(this.getBorderDescription(border));
    }

    private String getBorderDescription(Border border) {
        String string = "None";
        if (border != null) {
            if (border instanceof BevelBorder) {
                string = "Beveled";
            } else if (border instanceof EtchedBorder) {
                string = "Etched";
            } else if (border instanceof LineBorder) {
                string = "Line";
            } else if (border instanceof TitledBorder) {
                string = "Titled";
            }
        }
        return string;
    }

    public void setExpert(boolean bl) {
        this.expert_ = bl;
    }

    public boolean isExpert() {
        return this.expert_;
    }
}

