/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.util.SoTRange;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DataGroupPropertyPanel
extends PropertyPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private boolean expert_ = false;
    private String[] pNames_ = new String[]{"Id", "Margin", "Zoomable", "Z AutoScale", "Z Auto Levels", "Z User Range"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private DataGroup dataGroup_ = null;
    private boolean suppressEvent_ = false;
    private int zAutoScale;
    private int zUserRange;
    private int zAutoLevels;

    public DataGroupPropertyPanel(DataGroup dataGroup, boolean bl) {
        this.dataGroup_ = dataGroup;
        this.dataGroup_.addChangeListener(this);
        this.expert_ = bl;
        this.create();
    }

    public void setDataGroup(DataGroup dataGroup, boolean bl) {
        if (this.dataGroup_ != null) {
            this.dataGroup_.removeChangeListener(this);
        }
        this.dataGroup_ = dataGroup;
        this.dataGroup_.addChangeListener(this);
        this.expert_ = bl;
        this.reset();
    }

    void update() {
        int n = -1;
        this.suppressEvent_ = true;
        int n2 = -1;
        ((JTextField)this.comps_[++n]).setText(this.dataGroup_.getId());
        ((JLabel)this.comps_[++n]).setText(this.dataGroup_.getMargin().toString());
        ((JCheckBox)this.comps_[++n]).setSelected(this.dataGroup_.isZoomable());
        ((JCheckBox)this.comps_[++n]).setSelected(this.dataGroup_.isZAutoScale());
        ((JTextField)this.comps_[++n]).setText(this.format(this.dataGroup_.getNumberAutoContourLevels()));
        ((JTextField)this.comps_[++n]).setText(this.format(this.dataGroup_.getZRangeU(), false));
        this.setFieldsEnabled();
        this.suppressEvent_ = false;
    }

    void create() {
        int n = -1;
        int n2 = -1;
        String string = this.pNames_[++n];
        this.comps_[n] = this.createTextField(this.dataGroup_.getId(), string, this, !this.dataGroup_.isInstantiated());
        this.comps_[++n] = this.createLabel(this.dataGroup_.getMargin().toString());
        this.comps_[++n] = this.createCheckBox(this.dataGroup_.isZoomable(), this.pNames_[n], this);
        this.comps_[++n] = this.createCheckBox(this.dataGroup_.isZAutoScale(), this.pNames_[n], this);
        this.zAutoScale = n++;
        this.comps_[n] = this.createTextField(this.format(this.dataGroup_.getNumberAutoContourLevels()), this.pNames_[n], this, true);
        this.zAutoLevels = n++;
        this.comps_[n] = this.createTextField(this.format(this.dataGroup_.getZRangeU(), false), this.pNames_[n], this, true);
        this.zUserRange = n;
        this.setFieldsEnabled();
        for (n = 0; n < this.comps_.length; ++n) {
            this.addProperty(n + 1, this.pNames_[n], this.comps_[n], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    private void setFieldsEnabled() {
        ((JTextField)this.comps_[this.zUserRange]).setEnabled(!((JCheckBox)this.comps_[this.zAutoScale]).isSelected());
        ((JTextField)this.comps_[this.zAutoLevels]).setEnabled(((JCheckBox)this.comps_[this.zAutoScale]).isSelected());
    }

    private void processEvent(Object object, String string) {
        Object var3_3 = null;
        SoTRange soTRange = null;
        if (string.equals("Id")) {
            String string2 = this.dataGroup_.getId();
            this.dataGroup_.getPanelHolder().getDataGroups().remove(string2);
            this.dataGroup_.setId(((JTextField)object).getText());
            this.dataGroup_.getPanelHolder().getDataGroups().put(this.dataGroup_.getId(), this.dataGroup_);
        } else if (string.equals("Zoomable")) {
            this.dataGroup_.setZoomable(((JCheckBox)object).isSelected());
        } else if (string.equals("Z AutoScale")) {
            this.dataGroup_.setZAutoScale(((JCheckBox)object).isSelected());
        } else if (string.equals("Z Auto Levels")) {
            this.dataGroup_.setNumberAutoContourLevels(Integer.parseInt(((JTextField)object).getText()));
        } else if (string.equals("Z User Range") && (soTRange = this.parseRange(((JTextField)object).getText(), false)) != null) {
            this.dataGroup_.setZRangeU(soTRange);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.suppressEvent_) {
            return;
        }
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        this.processEvent(object, string);
        this.setFieldsEnabled();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.update();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            JTextField jTextField = (JTextField)object;
            String string = jTextField.getName();
            this.processEvent(object, string);
        }
    }

    public void setExpert(boolean bl) {
        boolean bl2 = this.expert_;
        this.expert_ = bl;
        if (this.expert_ != bl2) {
            this.reset();
        }
    }

    public boolean isExpert() {
        return this.expert_;
    }
}

