/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.DayMonthAxis;
import gov.noaa.pmel.sgt.HourDayAxis;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.MinuteHourAxis;
import gov.noaa.pmel.sgt.MonthYearAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.TimeAxisStyle;
import gov.noaa.pmel.sgt.YearDecadeAxis;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimePoint;
import gov.noaa.pmel.util.TimeRange;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TimeAxis
extends Axis
implements Cloneable {
    protected TimeRange tRange_;
    protected TimePoint tLocation_;
    protected String minorLabelFormat_;
    protected int minorLabelInterval_ = 2;
    protected String majorLabelFormat_;
    protected int majorLabelInterval_ = 1;
    protected double yminor_;
    protected double ymajor_;
    protected double xminor_;
    protected double xmajor_;
    protected int vertalign_;
    protected TimeAxisStyle txt_;
    protected int axisStyle_;
    static final double TIC_RATIO__ = 1.3;
    static final double TIC_GAP__ = 0.05;
    static final double LABEL_RATIO__ = 1.0;
    static final double MAJOR_LABEL_RATIO__ = 1.25;
    static final double defaultLargeTicHeight__ = 0.1;
    static final double defaultSmallTicHeight__ = 0.05;
    static final int defaultTicPosition__ = 1;
    static final int defaultLabelPosition__ = 1;
    static final double defaultLabelHeight__ = 0.15;
    public static final int AUTO = 0;
    public static final int YEAR_DECADE = 1;
    public static final int MONTH_YEAR = 2;
    public static final int DAY_MONTH = 3;
    public static final int HOUR_DAY = 4;
    public static final int MINUTE_HOUR = 5;

    private void setAuto() {
        TimeAxisStyle timeAxisStyle = null;
        GeoDate geoDate = this.tRange_.end.subtract(this.tRange_.start);
        double d = (double)Math.abs(geoDate.getTime()) / 8.64E7;
        if (d > 1000.0) {
            if (!(this.txt_ instanceof YearDecadeAxis)) {
                timeAxisStyle = new YearDecadeAxis();
            }
        } else if (d > 91.0) {
            if (!(this.txt_ instanceof MonthYearAxis)) {
                timeAxisStyle = new MonthYearAxis();
            }
        } else if (d > 5.0) {
            if (!(this.txt_ instanceof DayMonthAxis)) {
                timeAxisStyle = new DayMonthAxis();
            }
        } else if (d > 0.1666667) {
            if (!(this.txt_ instanceof HourDayAxis)) {
                timeAxisStyle = new HourDayAxis();
            }
        } else if (!(this.txt_ instanceof MinuteHourAxis)) {
            timeAxisStyle = new MinuteHourAxis();
        }
        if (timeAxisStyle != null) {
            this.txt_ = timeAxisStyle;
        }
        this.txt_.computeDefaults(geoDate);
        this.minorLabelFormat_ = this.txt_.getDefaultMinorLabelFormat();
        this.majorLabelFormat_ = this.txt_.getDefaultMajorLabelFormat();
        this.minorLabelInterval_ = this.txt_.getDefaultMinorLabelInterval();
        this.majorLabelInterval_ = this.txt_.getDefaultMajorLabelInterval();
        this.numSmallTics_ = this.txt_.getDefaultNumSmallTics();
    }

    protected void updateRegisteredTransforms() {
        if (!this.registeredTransforms_.isEmpty()) {
            Enumeration enumeration = this.registeredTransforms_.elements();
            while (enumeration.hasMoreElements()) {
                AxisTransform axisTransform = (AxisTransform)enumeration.nextElement();
                axisTransform.setRangeP(this.pRange_);
                axisTransform.setRangeU(this.tRange_);
            }
        }
    }

    protected void updateRegisteredAxes() {
        if (!this.registeredAxes_.isEmpty()) {
            Enumeration enumeration = this.registeredAxes_.elements();
            while (enumeration.hasMoreElements()) {
                TimeAxis timeAxis = (TimeAxis)enumeration.nextElement();
                timeAxis.setRangeU(this.tRange_);
                timeAxis.setRangeP(this.pRange_);
            }
        }
    }

    protected void setupDraw(double d) {
        if (this.orientation_ == 0) {
            if (this.labelPosition_ == 0) {
                this.vertalign_ = 2;
                this.yminor_ = this.minorLabelInterval_ == 0 ? d : (this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d + 1.3 * this.largeTicHeight_ : d + 0.05);
                this.ymajor_ = this.yminor_ + 1.0 * this.labelHeight_;
            } else {
                this.vertalign_ = 0;
                this.yminor_ = this.minorLabelInterval_ == 0 ? d : (this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d - 1.3 * this.largeTicHeight_ : d - 0.05);
                this.ymajor_ = this.yminor_ - 1.0 * this.labelHeight_;
            }
        } else if (this.labelPosition_ == 1) {
            this.vertalign_ = 2;
            this.xminor_ = this.minorLabelInterval_ == 0 ? d : (this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d - 1.3 * this.largeTicHeight_ : d - 0.05);
            this.xmajor_ = this.xminor_ - 1.0 * this.labelHeight_;
        } else {
            this.vertalign_ = 0;
            this.xminor_ = this.minorLabelInterval_ == 0 ? d : (this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d + 1.3 * this.largeTicHeight_ : d + 0.05);
            this.xmajor_ = this.xminor_ + 1.0 * this.labelHeight_;
        }
    }

    protected void drawMinorLabel(Graphics graphics, double d, GeoDate geoDate) {
        SGLabel sGLabel;
        Color color = graphics.getColor();
        if (this.orientation_ == 0) {
            sGLabel = new SGLabel("minor", geoDate.toString(this.minorLabelFormat_), new Point2D.Double(d, this.yminor_));
            sGLabel.setOrientation(0);
        } else {
            sGLabel = new SGLabel("minor", geoDate.toString(this.minorLabelFormat_), new Point2D.Double(this.xminor_, d));
            sGLabel.setOrientation(1);
        }
        sGLabel.setAlign(this.vertalign_, 1);
        sGLabel.setFont(this.labelFont_);
        sGLabel.setColor(this.labelColor_);
        sGLabel.setHeightP(this.labelHeight_);
        sGLabel.setLayer(this.graph_.getLayer());
        try {
            sGLabel.draw(graphics);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        graphics.setColor(color);
    }

    protected void drawMajorLabel(Graphics graphics, double d, GeoDate geoDate) {
        SGLabel sGLabel;
        Color color = graphics.getColor();
        if (this.orientation_ == 0) {
            sGLabel = new SGLabel("major", geoDate.toString(this.majorLabelFormat_), new Point2D.Double(d, this.ymajor_));
            sGLabel.setOrientation(0);
        } else {
            sGLabel = new SGLabel("major", geoDate.toString(this.majorLabelFormat_), new Point2D.Double(this.xmajor_, d));
            sGLabel.setOrientation(1);
        }
        sGLabel.setAlign(this.vertalign_, 1);
        sGLabel.setFont(this.labelFont_);
        sGLabel.setColor(this.labelColor_);
        sGLabel.setHeightP(1.25 * this.labelHeight_);
        sGLabel.setLayer(this.graph_.getLayer());
        try {
            sGLabel.draw(graphics);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        graphics.setColor(color);
    }

    public TimeAxis(int n) {
        this("", n);
    }

    public TimeAxis(String string, int n) {
        super(string);
        this.numSmallTics_ = 0;
        this.space_ = false;
        this.axisStyle_ = n;
        this.txt_ = this.axisStyle_ == 0 || this.axisStyle_ == 2 ? new MonthYearAxis() : (this.axisStyle_ == 1 ? new YearDecadeAxis() : (this.axisStyle_ == 3 ? new DayMonthAxis() : (this.axisStyle_ == 4 ? new HourDayAxis() : new MinuteHourAxis())));
        this.minorLabelFormat_ = this.txt_.getDefaultMinorLabelFormat();
        this.majorLabelFormat_ = this.txt_.getDefaultMajorLabelFormat();
        this.minorLabelInterval_ = this.txt_.getDefaultMinorLabelInterval();
        this.majorLabelInterval_ = this.txt_.getDefaultMajorLabelInterval();
        this.numSmallTics_ = this.txt_.getDefaultNumSmallTics();
        this.largeTicHeight_ = 0.1;
        this.smallTicHeight_ = 0.05;
        this.ticPosition_ = 1;
        this.labelPosition_ = 1;
        this.labelHeight_ = 0.15;
        this.tRange_ = null;
        this.tLocation_ = null;
    }

    public Axis copy() {
        TimeAxis timeAxis;
        try {
            timeAxis = (TimeAxis)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            timeAxis = new TimeAxis(this.getStyle());
        }
        timeAxis.registeredAxes_ = new Vector(2, 2);
        timeAxis.registeredTransforms_ = new Vector(2, 2);
        return timeAxis;
    }

    public void setLabelFormat(String string, String string2) {
        if (this.minorLabelFormat_ == null || this.majorLabelFormat_ == null || !this.minorLabelFormat_.equals(string) || !this.majorLabelFormat_.equals(string2)) {
            this.minorLabelFormat_ = string;
            this.majorLabelFormat_ = string2;
            this.modified("TimeAxis: setLabelFormat()");
        }
    }

    public void setMinorLabelFormat(String string) {
        if (this.minorLabelFormat_ == null || !this.minorLabelFormat_.equals(string)) {
            this.minorLabelFormat_ = string;
            this.modified("TimeAxis: setMinorLabelFormat()");
        }
    }

    public void setMajorLabelFormat(String string) {
        if (this.majorLabelFormat_ == null || !this.majorLabelFormat_.equals(string)) {
            this.majorLabelFormat_ = string;
            this.modified("TimeAxis: setMajorLabelFormat()");
        }
    }

    public String getMinorLabelFormat() {
        return this.minorLabelFormat_;
    }

    public String getMajorLabelFormat() {
        return this.majorLabelFormat_;
    }

    public void setLabelInterval(int n, int n2) {
        if (this.minorLabelInterval_ != n || this.majorLabelInterval_ != n2) {
            this.minorLabelInterval_ = n;
            this.majorLabelInterval_ = n2;
            this.modified("TimeAxis: setLabelInterval()");
        }
    }

    public void setMinorLabelInterval(int n) {
        if (this.minorLabelInterval_ != n) {
            this.minorLabelInterval_ = n;
            this.modified("TimeAxis: setMinorLabelInterval()");
        }
    }

    public void setMajorLabelInterval(int n) {
        if (this.majorLabelInterval_ != n) {
            this.majorLabelInterval_ = n;
            this.modified("TimeAxis: setMajorLabelInterval()");
        }
    }

    public int getMinorLabelInterval() {
        return this.minorLabelInterval_;
    }

    public int getMajorLabelInterval() {
        return this.majorLabelInterval_;
    }

    public void setStyle(int n) {
        if (this.axisStyle_ != n) {
            this.axisStyle_ = n;
            if (this.axisStyle_ == 0 && this.tRange_ != null) {
                this.setAuto();
            }
            this.modified("TimeAxis: setStyle()");
        }
    }

    public int getStyle() {
        return this.axisStyle_;
    }

    public void setRangeU(TimeRange timeRange) {
        if (this.tRange_ == null || !this.tRange_.equals(timeRange)) {
            this.tRange_ = timeRange;
            if (this.axisStyle_ == 0) {
                this.setAuto();
            }
            this.updateRegisteredAxes();
            this.updateRegisteredTransforms();
            this.modified("TimeAxis: setRangeU()");
        }
    }

    public TimeRange getTimeRangeU() {
        return this.tRange_;
    }

    public void setRangeU(SoTRange soTRange) {
        this.setRangeU(new TimeRange(soTRange.getStart().getLongTime(), soTRange.getEnd().getLongTime(), soTRange.getDelta().getLongTime()));
    }

    public SoTRange getSoTRangeU() {
        return new SoTRange.Time(this.tRange_);
    }

    public void setLocationU(TimePoint timePoint) {
        if (this.tLocation_ == null || !this.tLocation_.equals(timePoint)) {
            this.tLocation_ = timePoint;
            this.modified("TimeAxis: setLocationU()");
        }
    }

    public void setLocationU(SoTPoint soTPoint) {
        double d;
        long l;
        if (soTPoint.isXTime()) {
            l = soTPoint.getX().getLongTime();
            d = ((SoTValue.Double)soTPoint.getY()).getValue();
        } else {
            l = soTPoint.getY().getLongTime();
            d = ((SoTValue.Double)soTPoint.getX()).getValue();
        }
        this.setLocationU(new TimePoint(d, new GeoDate(l)));
    }

    public SoTPoint getSoTLocationU() {
        if (this.orientation_ == 0) {
            return new SoTPoint(this.tLocation_.t, this.tLocation_.x);
        }
        return new SoTPoint(this.tLocation_.x, this.tLocation_.t);
    }

    public TimePoint getLocationU() {
        return this.tLocation_;
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.orientation_ == 0) {
            double d = this.graph_.getYUtoP(this.tLocation_.x);
            this.setupDraw(d);
            int n5 = this.graph_.getXUtoD(this.tRange_.start);
            n4 = this.graph_.getXUtoD(this.tRange_.end) - n5;
            n3 = n5;
            double d2 = d;
            double d3 = d;
            if (this.labelPosition_ == 0) {
                d2 = this.ymajor_ + 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                    d3 -= 1.3 * this.largeTicHeight_;
                }
            } else {
                d3 = this.ymajor_ - 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                    d2 += 1.3 * this.largeTicHeight_;
                }
            }
            n2 = this.graph_.getLayer().getYPtoD(d2);
            n = this.graph_.getLayer().getYPtoD(d3) - n2;
        } else {
            double d = this.graph_.getXUtoP(this.tLocation_.x);
            this.setupDraw(d);
            int n6 = this.graph_.getYUtoD(this.tRange_.start);
            n2 = this.graph_.getYUtoD(this.tRange_.end);
            n = n6 - n2;
            double d4 = d;
            double d5 = d;
            if (this.labelPosition_ == 0) {
                d5 = this.xmajor_ + 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                    d4 -= 1.3 * this.largeTicHeight_;
                }
            } else {
                d4 = this.xmajor_ - 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                    d5 += 1.3 * this.largeTicHeight_;
                }
            }
            n3 = this.graph_.getLayer().getXPtoD(d4);
            n4 = this.graph_.getLayer().getXPtoD(d) - n3;
        }
        return new Rectangle(n3, n2, n4, n);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
    }

    public void modified(String string) {
        if (this.graph_ != null) {
            this.graph_.modified(string);
        }
    }

    void draw(Graphics graphics) {
        GeoDate geoDate = new GeoDate();
        GeoDate geoDate2 = new GeoDate();
        if (!this.visible_) {
            return;
        }
        if (this.lineColor_ == null) {
            graphics.setColor(this.graph_.getLayer().getPane().getComponent().getForeground());
        } else {
            graphics.setColor(this.lineColor_);
        }
        boolean bl = this.minorLabelInterval_ != 0 && this.labelPosition_ != 2;
        boolean bl2 = this.majorLabelInterval_ != 0 && this.labelPosition_ != 2;
        boolean bl3 = this.tRange_.end.after(this.tRange_.start);
        geoDate = this.txt_.getStartTime(this.tRange_);
        geoDate2 = bl3 ? new GeoDate(this.tRange_.end) : new GeoDate(this.tRange_.start);
        if (this.orientation_ == 0) {
            GeoDate geoDate3;
            double d;
            int n;
            int n2 = this.graph_.getYUtoD(this.tLocation_.x);
            int n3 = this.graph_.getXUtoD(this.tRange_.start);
            int n4 = this.graph_.getXUtoD(this.tRange_.end);
            graphics.drawLine(n3, n2, n4, n2);
            double d2 = this.graph_.getYUtoP(this.tLocation_.x);
            double d3 = this.graph_.getXUtoP(geoDate);
            this.setupDraw(d2);
            if (this.txt_.isStartOfMinor(geoDate)) {
                this.drawThickXTic(graphics, d3, d2, (double)1.3f * this.largeTicHeight_);
            } else {
                this.drawXTic(graphics, d3, d2, this.largeTicHeight_);
            }
            int n5 = n = this.txt_.getMajorValue(geoDate);
            int n6 = this.txt_.getMinorValue(geoDate);
            double d4 = d3;
            double d5 = d3;
            GeoDate geoDate4 = new GeoDate(geoDate);
            GeoDate geoDate5 = new GeoDate(geoDate);
            geoDate.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            while (geoDate.before(geoDate2)) {
                d3 = this.graph_.getXUtoP(geoDate);
                int n7 = this.txt_.getMinorValue(geoDate);
                if (this.txt_.isStartOfMinor(geoDate)) {
                    this.drawThickXTic(graphics, d3, d2, (double)1.3f * this.largeTicHeight_);
                } else {
                    this.drawXTic(graphics, d3, d2, this.largeTicHeight_);
                }
                if (bl && n6 % this.minorLabelInterval_ == 0) {
                    d = this.txt_.computeLocation(d5, d3);
                    this.drawMinorLabel(graphics, d, geoDate4);
                }
                if ((n = this.txt_.getMajorValue(geoDate)) != n5) {
                    if (bl2 && n5 % this.majorLabelInterval_ == 0) {
                        d = (d4 + d3) * 0.5;
                        this.drawMajorLabel(graphics, d, geoDate5);
                    }
                    d4 = d3;
                    n5 = n;
                    geoDate5 = new GeoDate(geoDate);
                }
                d5 = d3;
                n6 = n7;
                geoDate4 = new GeoDate(geoDate);
                geoDate.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            }
            if (bl2 && n5 % this.majorLabelInterval_ == 0 && this.txt_.isRoomForMajorLabel(geoDate3 = geoDate2.subtract(geoDate5))) {
                d3 = this.graph_.getXUtoP(geoDate2);
                d = (d4 + d3) * 0.5;
                this.drawMajorLabel(graphics, d, geoDate5);
            }
        } else {
            GeoDate geoDate6;
            double d;
            int n;
            int n8 = this.graph_.getXUtoD(this.tLocation_.x);
            int n9 = this.graph_.getYUtoD(this.tRange_.start);
            int n10 = this.graph_.getYUtoD(this.tRange_.end);
            graphics.drawLine(n8, n9, n8, n10);
            double d6 = this.graph_.getXUtoP(this.tLocation_.x);
            double d7 = this.graph_.getYUtoP(geoDate);
            this.setupDraw(d6);
            if (this.txt_.isStartOfMinor(geoDate)) {
                this.drawThickYTic(graphics, d6, d7, (double)1.3f * this.largeTicHeight_);
            } else {
                this.drawYTic(graphics, d6, d7, this.largeTicHeight_);
            }
            int n11 = n = this.txt_.getMajorValue(geoDate);
            int n12 = this.txt_.getMinorValue(geoDate);
            double d8 = d7;
            double d9 = d7;
            GeoDate geoDate7 = new GeoDate(geoDate);
            GeoDate geoDate8 = new GeoDate(geoDate);
            geoDate.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            while (geoDate.before(geoDate2)) {
                d7 = this.graph_.getYUtoP(geoDate);
                int n13 = this.txt_.getMinorValue(geoDate);
                if (this.txt_.isStartOfMinor(geoDate)) {
                    this.drawThickYTic(graphics, d6, d7, (double)1.3f * this.largeTicHeight_);
                } else {
                    this.drawYTic(graphics, d6, d7, this.largeTicHeight_);
                }
                if (bl && n12 % this.minorLabelInterval_ == 0) {
                    d = this.txt_.computeLocation(d9, d7);
                    this.drawMinorLabel(graphics, d, geoDate7);
                }
                if ((n = this.txt_.getMajorValue(geoDate)) != n11) {
                    if (bl2 && n11 % this.majorLabelInterval_ == 0) {
                        d = (d8 + d7) * 0.5;
                        this.drawMajorLabel(graphics, d, geoDate8);
                    }
                    d8 = d7;
                    n11 = n;
                    geoDate8 = new GeoDate(geoDate);
                }
                d9 = d7;
                n12 = n13;
                geoDate7 = new GeoDate(geoDate);
                geoDate.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            }
            if (bl2 && n11 % this.majorLabelInterval_ == 0 && this.txt_.isRoomForMajorLabel(geoDate6 = geoDate2.subtract(geoDate8))) {
                d7 = this.graph_.getYUtoP(geoDate2);
                d = (d8 + d7) * 0.5;
                this.drawMajorLabel(graphics, d, geoDate8);
            }
        }
    }

    public void setTitle(SGLabel sGLabel) {
        this.title_ = null;
    }
}

