/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.Selectable;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public abstract class Axis
implements Selectable {
    private String ident_;
    protected CartesianGraph graph_;
    protected Vector registeredAxes_;
    protected Vector registeredTransforms_;
    protected Color lineColor_;
    protected int numSmallTics_;
    protected double largeTicHeight_;
    protected double smallTicHeight_;
    protected double thickTicWidth_;
    protected int ticPosition_;
    protected int labelPosition_;
    protected int labelInterval_;
    protected Font labelFont_;
    protected Color labelColor_;
    protected double labelHeight_;
    protected int sigDigits_;
    protected String labelFormat_;
    protected SGLabel title_;
    protected Range2D pRange_;
    protected boolean space_;
    protected int orientation_;
    protected boolean selected_;
    protected boolean selectable_;
    protected boolean visible_;
    public static final int POSITIVE_SIDE = 0;
    public static final int NEGATIVE_SIDE = 1;
    public static final int NO_LABEL = 2;
    public static final int BOTH_SIDES = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int AUTO = 3;

    protected abstract void updateRegisteredTransforms();

    protected abstract void updateRegisteredAxes();

    protected void drawXTic(Graphics graphics, double d, double d2, double d3) {
        double d4 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d2 + d3 : d2;
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d2 - d3 : d2;
        int n = this.graph_.getLayer().getXPtoD(d);
        int n2 = this.graph_.getLayer().getYPtoD(d4);
        int n3 = this.graph_.getLayer().getYPtoD(d5);
        graphics.drawLine(n, n2, n, n3);
    }

    protected void drawThickXTic(Graphics graphics, double d, double d2, double d3) {
        double d4 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d2 + d3 : d2;
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d2 - d3 : d2;
        int n = this.graph_.getLayer().getXPtoD(d);
        int n2 = this.graph_.getLayer().getXPtoD(d - this.thickTicWidth_ / 2.0);
        int n3 = this.graph_.getLayer().getXPtoD(d + this.thickTicWidth_ / 2.0);
        int n4 = this.graph_.getLayer().getYPtoD(d4);
        int n5 = this.graph_.getLayer().getYPtoD(d5);
        if (n3 - n2 < 3) {
            n2 = n - 1;
            n3 = n + 1;
        }
        int n6 = n3 - n2;
        int n7 = n5 - n4;
        graphics.fillRect(n2, n4, n6, n7);
    }

    protected void drawYTic(Graphics graphics, double d, double d2, double d3) {
        double d4 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d + d3 : d;
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d - d3 : d;
        int n = this.graph_.getLayer().getYPtoD(d2);
        int n2 = this.graph_.getLayer().getXPtoD(d4);
        int n3 = this.graph_.getLayer().getXPtoD(d5);
        graphics.drawLine(n2, n, n3, n);
    }

    protected void drawThickYTic(Graphics graphics, double d, double d2, double d3) {
        double d4 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d + d3 : d;
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d - d3 : d;
        int n = this.graph_.getLayer().getYPtoD(d2);
        int n2 = this.graph_.getLayer().getXPtoD(d4);
        int n3 = this.graph_.getLayer().getXPtoD(d5);
        graphics.drawLine(n2, n - 1, n3, n - 1);
        graphics.drawLine(n2, n, n3, n);
        graphics.drawLine(n2, n + 1, n3, n + 1);
    }

    public Axis() {
        this("");
    }

    public Axis(String string) {
        this.ident_ = string;
        this.registeredAxes_ = new Vector();
        this.registeredTransforms_ = new Vector();
        this.lineColor_ = Color.black;
        this.numSmallTics_ = 0;
        this.largeTicHeight_ = 0.1;
        this.smallTicHeight_ = 0.05;
        this.thickTicWidth_ = 0.025;
        this.ticPosition_ = 1;
        this.labelPosition_ = 1;
        this.labelInterval_ = 2;
        this.labelHeight_ = 0.15;
        this.sigDigits_ = 2;
        this.labelFormat_ = "";
        this.title_ = null;
        this.orientation_ = 0;
        this.labelFont_ = new Font("Helvetica", 2, 10);
        this.labelColor_ = Color.black;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
    }

    public abstract Axis copy();

    abstract void draw(Graphics var1);

    void setGraph(CartesianGraph cartesianGraph) {
        this.graph_ = cartesianGraph;
    }

    public CartesianGraph getGraph() {
        return this.graph_;
    }

    public AbstractPane getPane() {
        return this.graph_.getPane();
    }

    public void modified(String string) {
        if (this.graph_ != null) {
            this.graph_.modified(string);
        }
    }

    public void register(Axis axis) {
        this.registeredAxes_.addElement(axis);
    }

    public void register(AxisTransform axisTransform) {
        this.registeredTransforms_.addElement(axisTransform);
    }

    public void clear(Axis axis) {
        if (!this.registeredAxes_.isEmpty()) {
            this.registeredAxes_.removeElement(axis);
        }
    }

    public void clear(AxisTransform axisTransform) {
        if (!this.registeredTransforms_.isEmpty()) {
            this.registeredTransforms_.removeElement(axisTransform);
        }
    }

    public void clearAllRegisteredAxes() {
        this.registeredAxes_.removeAllElements();
    }

    public void clearAllRegisteredTransforms() {
        this.registeredTransforms_.removeAllElements();
    }

    public int getNumberRegisteredTransforms() {
        return this.registeredTransforms_.size();
    }

    public int getNumberRegisteredAxes() {
        return this.registeredAxes_.size();
    }

    public void setLargeTicHeightP(double d) {
        if (this.largeTicHeight_ != d) {
            this.largeTicHeight_ = d;
            this.modified("Axis: setLargeTicHeightP()");
        }
    }

    public double getLargeTicHeightP() {
        return this.largeTicHeight_;
    }

    public void setNumberSmallTics(int n) {
        if (this.numSmallTics_ != n) {
            this.numSmallTics_ = n;
            this.modified("Axis: setNumerSmallTics()");
        }
    }

    public int getNumberSmallTics() {
        return this.numSmallTics_;
    }

    public void setSmallTicHeightP(double d) {
        if (this.smallTicHeight_ != d) {
            this.smallTicHeight_ = d;
            this.modified("Axis: setSmallTicHeightP()");
        }
    }

    public double getSmallTicHeightP() {
        return this.smallTicHeight_;
    }

    public void setThickTicWidthP(double d) {
        if (this.thickTicWidth_ != d) {
            this.thickTicWidth_ = d;
            this.modified("Axis: setThickTicWidthP()");
        }
    }

    public double getThickTicWidthP() {
        return this.thickTicWidth_;
    }

    public void setTicPosition(int n) {
        if (this.ticPosition_ != n) {
            this.ticPosition_ = n;
            this.modified("Axis: setTicPosition()");
        }
    }

    public int getTicPosition() {
        return this.ticPosition_;
    }

    public void setLabelPosition(int n) {
        if (this.labelPosition_ != n) {
            this.labelPosition_ = n;
            this.modified("Axis: setLabelPosition()");
        }
    }

    public int getLabelPosition() {
        return this.labelPosition_;
    }

    public void setLabelFont(Font font) {
        if (this.labelFont_ == null || !this.labelFont_.equals(font)) {
            this.labelFont_ = font;
            this.modified("Axis: setLabelFont()");
        }
    }

    public Font getLabelFont() {
        return this.labelFont_;
    }

    public void setLineColor(Color color) {
        if (this.lineColor_ == null || !this.lineColor_.equals(color)) {
            this.lineColor_ = color;
            this.modified("Axis: setLineColor()");
        }
    }

    public Color getLineColor() {
        return this.lineColor_;
    }

    public void setLabelColor(Color color) {
        if (this.labelColor_ == null || !this.labelColor_.equals(color)) {
            this.labelColor_ = color;
            this.modified("Axis: setLabelColor()");
        }
    }

    public Color getLabelColor() {
        return this.labelColor_;
    }

    public void setLabelHeightP(double d) {
        if (this.labelHeight_ != d) {
            this.labelHeight_ = d;
            this.modified("Axis: setLabelHeightP()");
        }
    }

    public double getLabelHeightP() {
        return this.labelHeight_;
    }

    public void setTitle(SGLabel sGLabel) {
        if (this.title_ == null || !this.title_.equals(sGLabel)) {
            this.title_ = sGLabel;
            this.title_.setMoveable(false);
            this.modified("Axis: setTitle()");
        }
    }

    public SGLabel getTitle() {
        return this.title_;
    }

    public void setRangeP(Range2D range2D) {
        if (this.pRange_ == null || !this.pRange_.equals(range2D)) {
            this.pRange_ = range2D;
            this.updateRegisteredTransforms();
            this.modified("Axis: setRangeP()");
        }
    }

    public Range2D getRangeP() {
        if (this.orientation_ == 0) {
            return this.graph_.xTransform_.getRangeP();
        }
        return this.graph_.yTransform_.getRangeP();
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setOrientation(int n) {
        if (this.orientation_ != n) {
            this.orientation_ = n;
            this.modified("Axis: setOrientation()");
        }
    }

    public int getOrientation() {
        return this.orientation_;
    }

    public boolean isSpace() {
        return this.space_;
    }

    public boolean isTime() {
        return !this.space_;
    }

    public abstract Rectangle getBounds();

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelectable(boolean bl) {
        this.selectable_ = bl;
    }

    public boolean isSelectable() {
        return this.selectable_;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean bl) {
        if (this.visible_ != bl) {
            this.visible_ = bl;
            this.modified("Axis: setVisible()");
        }
    }

    public abstract void setLocationU(SoTPoint var1);

    public abstract SoTPoint getSoTLocationU();

    public abstract void setRangeU(SoTRange var1);

    public abstract SoTRange getSoTRangeU();
}

