/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.commandline;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.commandline.WriteableCommandLineImpl;
import org.apache.commons.cli2.util.HelpFormatter;

public class Parser {
    private HelpFormatter helpFormatter = new HelpFormatter();
    private Option helpOption = null;
    private String helpTrigger = null;
    private Group group = null;

    public CommandLine parse(String[] arguments) throws OptionException {
        LinkedList<String> argumentList = new LinkedList<String>();
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            argumentList.add(new String(argument));
        }
        WriteableCommandLineImpl commandLine = new WriteableCommandLineImpl(this.group, argumentList);
        this.group.defaults(commandLine);
        ListIterator iterator = argumentList.listIterator();
        Object previous = null;
        while (this.group.canProcess((WriteableCommandLine)commandLine, iterator)) {
            Object next = iterator.next();
            iterator.previous();
            if (next == previous) break;
            previous = next;
            this.group.process(commandLine, iterator);
        }
        if (iterator.hasNext()) {
            String arg = (String)iterator.next();
            throw new OptionException(this.group, "Unexpected.token", arg);
        }
        if (!commandLine.hasOption(this.helpOption) && !commandLine.hasOption(this.helpTrigger)) {
            this.group.validate(commandLine);
        }
        return commandLine;
    }

    public CommandLine parseAndHelp(String[] arguments) throws IOException {
        this.helpFormatter.setGroup(this.group);
        try {
            CommandLine commandLine = this.parse(arguments);
            if (!commandLine.hasOption(this.helpOption) && !commandLine.hasOption(this.helpTrigger)) {
                return commandLine;
            }
        }
        catch (OptionException oe) {
            this.helpFormatter.setException(oe);
        }
        this.helpFormatter.print();
        return null;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setHelpFormatter(HelpFormatter helpFormatter) {
        this.helpFormatter = helpFormatter;
    }

    public void setHelpOption(Option helpOption) {
        this.helpOption = helpOption;
    }

    public void setHelpTrigger(String helpTrigger) {
        this.helpTrigger = helpTrigger;
    }
}

