/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.ColorMap;
import java.awt.Color;

public class IndexedColorMap {
    String mParamName;
    double mMinVal;
    double mMaxVal;
    double[] mVals = null;
    Color[] mColors = null;
    int mNumColors;
    ColorMap mColorMap;

    public IndexedColorMap(ColorMap colorMap, int n) {
        int n2;
        this.mNumColors = n;
        this.mColorMap = colorMap;
        this.mVals = new double[this.mNumColors];
        this.mColors = new Color[this.mNumColors];
        this.mMinVal = this.mColorMap.getMinValue();
        this.mMaxVal = this.mColorMap.getMaxValue();
        this.mParamName = new String(this.mColorMap.getParamName());
        double d = (this.mMaxVal - this.mMinVal) / (double)this.mNumColors;
        for (n2 = 0; n2 < this.mNumColors; ++n2) {
            this.mVals[n2] = this.mMinVal + (double)n2 * d;
        }
        this.mVals[this.mNumColors - 1] = this.mMaxVal;
        for (n2 = 0; n2 < this.mNumColors; ++n2) {
            this.mColors[n2] = this.mColorMap.getColor(this.mVals[n2]);
        }
    }

    public IndexedColorMap(IndexedColorMap indexedColorMap) {
    }

    public Color getColor(double d) {
        return new Color(1.0f, 1.0f, 1.0f);
    }

    public Color getColor(int n) {
        if (n < 0) {
            return this.mColors[0];
        }
        if (n >= this.mNumColors) {
            return this.mColors[this.mNumColors - 1];
        }
        return this.mColors[n];
    }

    public Color[] getColors() {
        return this.mColors;
    }

    public String getParamName() {
        return this.mParamName;
    }
}

