/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGException;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Annote;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Annotation
implements SGTData,
PropertyChangeListener {
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private String title_ = null;
    private String id_ = null;
    private SGTMetaData xMeta_ = null;
    private SGTMetaData yMeta_ = null;
    private List text_ = new Vector();
    private List line_ = new Vector();
    private List point_ = new Vector();
    private List oval_ = new Vector();
    private List rect_ = new Vector();
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private boolean xTime_ = false;
    private boolean yTime_ = false;

    public Annotation() {
        this(null, false, false);
    }

    public Annotation(String string) {
        this(string, false, false);
    }

    public Annotation(String string, boolean bl, boolean bl2) {
        this.title_ = string;
        this.xTime_ = bl;
        this.yTime_ = bl2;
    }

    public boolean remove(String string) {
        Annote annote = this.findAnnote(string);
        if (annote == null) {
            return false;
        }
        return this.remove(annote);
    }

    public boolean remove(Annote annote) {
        if (annote instanceof Annote.Line) {
            return this.removeLine(annote);
        }
        if (annote instanceof Annote.Oval) {
            return this.removeOval(annote);
        }
        if (annote instanceof Annote.Point) {
            return this.removePoint(annote);
        }
        if (annote instanceof Annote.Rect) {
            return this.removeRect(annote);
        }
        if (annote instanceof Annote.Text) {
            return this.removeText(annote);
        }
        return false;
    }

    public void add(Annote annote) throws SGException {
        if (annote instanceof Annote.Line) {
            SGTLine sGTLine = ((Annote.Line)annote).getLine();
            if (this.xTime_ != sGTLine.isXTime() || this.yTime_ != sGTLine.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            annote.addPropertyChangeListener(this);
            this.line_.add(annote);
            this.changes_.firePropertyChange("lineAdded", true, false);
        } else if (annote instanceof Annote.Oval) {
            SoTPoint soTPoint = ((Annote.Oval)annote).getUpperLeft();
            if (this.xTime_ != soTPoint.isXTime() || this.yTime_ != soTPoint.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            annote.addPropertyChangeListener(this);
            this.oval_.add(annote);
            this.changes_.firePropertyChange("ovalAdded", true, false);
        } else if (annote instanceof Annote.Point) {
            SGTPoint sGTPoint = ((Annote.Point)annote).getPoint();
            if (this.xTime_ != sGTPoint.isXTime() || this.yTime_ != sGTPoint.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            annote.addPropertyChangeListener(this);
            this.point_.add(annote);
            this.changes_.firePropertyChange("pointAdded", true, false);
        } else if (annote instanceof Annote.Rect) {
            SoTPoint soTPoint = ((Annote.Rect)annote).getUpperLeft();
            if (this.xTime_ != soTPoint.isXTime() || this.yTime_ != soTPoint.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            annote.addPropertyChangeListener(this);
            this.rect_.add(annote);
            this.changes_.firePropertyChange("rectAdded", true, false);
        } else if (annote instanceof Annote.Text) {
            SoTPoint soTPoint = ((Annote.Text)annote).getLocation();
            if (this.xTime_ != soTPoint.isXTime() || this.yTime_ != soTPoint.isYTime()) {
                throw new SGException("Time axes do not match");
            }
            annote.addPropertyChangeListener(this);
            this.text_.add(annote);
            this.changes_.firePropertyChange("textAdded", true, false);
        }
    }

    public Annote addLine(String string, SGTLine sGTLine, LineAttribute lineAttribute) throws SGException {
        if (this.xTime_ != sGTLine.isXTime() || this.yTime_ != sGTLine.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Line line = new Annote.Line(string, sGTLine, lineAttribute);
        line.addPropertyChangeListener(this);
        this.line_.add(line);
        this.changes_.firePropertyChange("lineAdded", true, false);
        return line;
    }

    private boolean removeLine(Annote annote) {
        boolean bl = false;
        if (annote instanceof Annote.Line) {
            annote.removePropertyChangeListener(this);
            bl = this.line_.remove(annote);
            if (bl) {
                this.changes_.firePropertyChange("lineRemoved", true, false);
            }
        }
        return bl;
    }

    public Iterator getLineIterator() {
        return this.line_.iterator();
    }

    public boolean hasLine() {
        return !this.line_.isEmpty();
    }

    public Annote addPoint(String string, SGTPoint sGTPoint, PointAttribute pointAttribute) throws SGException {
        if (this.xTime_ != sGTPoint.isXTime() || this.yTime_ != sGTPoint.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Point point = new Annote.Point(string, sGTPoint, pointAttribute);
        point.addPropertyChangeListener(this);
        this.point_.add(point);
        this.changes_.firePropertyChange("pointAdded", true, false);
        return point;
    }

    private boolean removePoint(Annote annote) {
        boolean bl = false;
        if (annote instanceof Annote.Point) {
            annote.removePropertyChangeListener(this);
            bl = this.point_.remove(annote);
            if (bl) {
                this.changes_.firePropertyChange("pointRemoved", true, false);
            }
        }
        return bl;
    }

    public Iterator getPointIterator() {
        return this.point_.iterator();
    }

    public boolean hasPoint() {
        return !this.point_.isEmpty();
    }

    public Annote addText(String string, SoTPoint soTPoint, SGLabel sGLabel) throws SGException {
        if (this.xTime_ != soTPoint.isXTime() || this.yTime_ != soTPoint.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Text text = new Annote.Text(string, soTPoint, sGLabel);
        text.addPropertyChangeListener(this);
        this.text_.add(text);
        this.changes_.firePropertyChange("textAdded", true, false);
        return text;
    }

    private boolean removeText(Annote annote) {
        boolean bl = false;
        if (annote instanceof Annote.Text) {
            annote.removePropertyChangeListener(this);
            bl = this.text_.remove(annote);
            if (bl) {
                this.changes_.firePropertyChange("textRemoved", true, false);
            }
        }
        return bl;
    }

    public Iterator getTextIterator() {
        return this.text_.iterator();
    }

    public boolean hasText() {
        return !this.text_.isEmpty();
    }

    public Annote addOval(String string, SoTPoint soTPoint, SoTPoint soTPoint2, LineAttribute lineAttribute, Color color) throws SGException {
        if (this.xTime_ != soTPoint.isXTime() || this.yTime_ != soTPoint.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Oval oval = new Annote.Oval(string, soTPoint, soTPoint2, lineAttribute, color);
        oval.addPropertyChangeListener(this);
        this.oval_.add(oval);
        this.changes_.firePropertyChange("ovalAdded", true, false);
        return oval;
    }

    private boolean removeOval(Annote annote) {
        boolean bl = false;
        if (annote instanceof Annote.Oval) {
            annote.removePropertyChangeListener(this);
            bl = this.oval_.remove(annote);
            if (bl) {
                this.changes_.firePropertyChange("ovalRemoved", true, false);
            }
        }
        return bl;
    }

    public Iterator getOvalIterator() {
        return this.oval_.iterator();
    }

    public boolean hasOval() {
        return !this.oval_.isEmpty();
    }

    public Annote addRect(String string, SoTPoint soTPoint, SoTPoint soTPoint2, LineAttribute lineAttribute, Color color) throws SGException {
        if (this.xTime_ != soTPoint.isXTime() || this.yTime_ != soTPoint.isYTime()) {
            throw new SGException("Time axes do not match");
        }
        Annote.Rect rect = new Annote.Rect(string, soTPoint, soTPoint2, lineAttribute, color);
        rect.addPropertyChangeListener(this);
        this.rect_.add(rect);
        this.changes_.firePropertyChange("rectAdded", true, false);
        return rect;
    }

    private boolean removeRect(Annote annote) {
        boolean bl = false;
        if (annote instanceof Annote.Rect) {
            annote.removePropertyChangeListener(this);
            bl = this.rect_.remove(annote);
            if (bl) {
                this.changes_.firePropertyChange("rectRemoved", true, false);
            }
        }
        return bl;
    }

    public Iterator getRectIterator() {
        return this.rect_.iterator();
    }

    public boolean hasRect() {
        return !this.rect_.isEmpty();
    }

    public Annote findAnnote(String string) {
        Iterator iterator;
        Annote annote = null;
        if (!this.line_.isEmpty()) {
            iterator = this.line_.iterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                if (!annote.getAnnoteId().equals(string)) continue;
                return annote;
            }
        }
        if (!this.point_.isEmpty()) {
            iterator = this.point_.iterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                if (!annote.getAnnoteId().equals(string)) continue;
                return annote;
            }
        }
        if (!this.oval_.isEmpty()) {
            iterator = this.oval_.iterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                if (!annote.getAnnoteId().equals(string)) continue;
                return annote;
            }
        }
        if (!this.rect_.isEmpty()) {
            iterator = this.rect_.iterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                if (!annote.getAnnoteId().equals(string)) continue;
                return annote;
            }
        }
        if (!this.text_.isEmpty()) {
            iterator = this.text_.iterator();
            while (iterator.hasNext()) {
                annote = (Annote)iterator.next();
                if (!annote.getAnnoteId().equals(string)) continue;
                return annote;
            }
        }
        return null;
    }

    public void setTitle(String string) {
        this.title_ = string;
    }

    public String getTitle() {
        return this.title_;
    }

    public SGLabel getKeyTitle() {
        return null;
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public String getId() {
        return this.id_;
    }

    public SGTData copy() {
        throw new UnsupportedOperationException("Method copy() not yet implemented.");
    }

    public boolean isXTime() {
        return this.xTime_;
    }

    public boolean isYTime() {
        return this.yTime_;
    }

    public void setXMetaData(SGTMetaData sGTMetaData) {
        this.xMeta_ = sGTMetaData;
    }

    public SGTMetaData getXMetaData() {
        return this.xMeta_;
    }

    public void setYMetaData(SGTMetaData sGTMetaData) {
        this.yMeta_ = sGTMetaData;
    }

    public SGTMetaData getYMetaData() {
        return this.yMeta_;
    }

    public SoTRange getXRange() {
        return this.xRange_;
    }

    public SoTRange getYRange() {
        return this.yRange_;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changes_.firePropertyChange(propertyChangeEvent);
    }
}

