/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.prop.GridAttributeDialog;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class JGridDemo
extends JApplet {
    static JPlotLayout rpl_;
    private GridAttribute gridAttr_;
    JButton edit_;
    JButton space_ = null;
    JButton tree_;
    JButton print_;
    JButton layout_;
    PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();

    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.setSize(600, 550);
        JPanel jPanel = new JPanel();
        rpl_ = this.makeGraph();
        JPanel jPanel2 = this.makeButtonPanel(false);
        rpl_.setBatch(true);
        jPanel.add((Component)rpl_, "Center");
        JPane jPane = rpl_.getKeyPane();
        jPane.setSize(new Dimension(600, 100));
        jPanel.add((Component)jPane, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        rpl_.setBatch(false);
    }

    JPanel makeButtonPanel(boolean bl) {
        MyAction myAction = new MyAction();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.print_ = new JButton("Print...");
        this.print_.addActionListener(myAction);
        jPanel.add(this.print_);
        this.layout_ = new JButton("Page Layout...");
        this.layout_.addActionListener(myAction);
        jPanel.add(this.layout_);
        this.tree_ = new JButton("Tree View");
        this.tree_.addActionListener(myAction);
        jPanel.add(this.tree_);
        this.edit_ = new JButton("Edit GridAttribute");
        this.edit_.addActionListener(myAction);
        jPanel.add(this.edit_);
        if (bl) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            jPanel.add(this.space_);
        }
        return jPanel;
    }

    public static void main(String[] stringArray) {
        JGridDemo jGridDemo = new JGridDemo();
        JFrame jFrame = new JFrame("Grid Demo");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jFrame.setSize(600, 500);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }

            public void windowOpened(WindowEvent windowEvent) {
                rpl_.getKeyPane().draw();
            }
        });
        JPanel jPanel2 = jGridDemo.makeButtonPanel(true);
        rpl_ = jGridDemo.makeGraph();
        rpl_.setBatch(true);
        jPanel.add((Component)rpl_, "Center");
        JPane jPane = rpl_.getKeyPane();
        jPane.setBatch(true);
        jPane.setSize(new Dimension(600, 100));
        rpl_.setKeyLayerSizeP(new Dimension2D(6.0, 1.0));
        rpl_.setKeyBoundsP(new Rectangle2D.Double(0.0, 1.0, 6.0, 1.0));
        jPanel.add((Component)jPane, "South");
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.getContentPane().add((Component)jPanel2, "South");
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        jFrame.pack();
        jFrame.setVisible(true);
        jPane.setBatch(false);
        rpl_.setBatch(false);
    }

    void edit_actionPerformed(ActionEvent actionEvent) {
        GridAttributeDialog gridAttributeDialog = new GridAttributeDialog();
        gridAttributeDialog.setJPane(rpl_);
        CartesianRenderer cartesianRenderer = ((CartesianGraph)rpl_.getFirstLayer().getGraph()).getRenderer();
        gridAttributeDialog.setGridCartesianRenderer((GridCartesianRenderer)cartesianRenderer);
        gridAttributeDialog.setVisible(true);
    }

    void tree_actionPerformed(ActionEvent actionEvent) {
        JClassTree jClassTree = new JClassTree();
        jClassTree.setModal(false);
        jClassTree.setJPane(rpl_);
        jClassTree.show();
    }

    void print_actionPerformed(ActionEvent actionEvent) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(rpl_, this.pageFormat);
        printerJob.setJobName("Grid Demo");
        if (printerJob.printDialog()) {
            try {
                Color color = rpl_.getBackground();
                if (!color.equals(Color.white)) {
                    rpl_.setBackground(Color.white);
                }
                rpl_.setPageAlign(0, 1);
                RepaintManager repaintManager = RepaintManager.currentManager(rpl_);
                repaintManager.setDoubleBufferingEnabled(false);
                printerJob.print();
                repaintManager.setDoubleBufferingEnabled(true);
                rpl_.setBackground(color);
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    void layout_actionPerformed(ActionEvent actionEvent) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.pageFormat = printerJob.pageDialog(this.pageFormat);
    }

    JPlotLayout makeGraph() {
        Range2D range2D = new Range2D(190.0, 250.0, 1.0);
        Range2D range2D2 = new Range2D(0.0, 45.0, 1.0);
        TestData testData = new TestData(5, range2D, range2D2, 3, 12.0f, 30.0f, 5.0f);
        SGTData sGTData = testData.getSGTData();
        JPlotLayout jPlotLayout = new JPlotLayout(true, false, false, "JGridDemo Pane", null, true);
        jPlotLayout.setEditClasses(false);
        Range2D range2D3 = new Range2D(-20.0, 45.0, 5.0);
        ContourLevels contourLevels = ContourLevels.getDefault(range2D3);
        this.gridAttr_ = new GridAttribute(contourLevels);
        ColorMap colorMap = this.createColorMap(range2D3);
        this.gridAttr_.setColorMap(colorMap);
        this.gridAttr_.setStyle(3);
        jPlotLayout.addData(sGTData, (Attribute)this.gridAttr_, "First Data");
        jPlotLayout.setTitles("Raster Plot Demo", "using a JPlotLayout", "");
        jPlotLayout.setSize(new Dimension(600, 400));
        return jPlotLayout;
    }

    ColorMap createColorMap(Range2D range2D) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] nArray3 = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IndexedColorMap indexedColorMap = new IndexedColorMap(nArray, nArray2, nArray3);
        indexedColorMap.setTransform(new LinearTransform(0.0, (double)nArray.length, range2D.start, range2D.end));
        return indexedColorMap;
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JGridDemo.this.edit_) {
                JGridDemo.this.edit_actionPerformed(actionEvent);
            } else if (object == JGridDemo.this.space_) {
                System.out.println("  <<Mark>>");
            } else if (object == JGridDemo.this.tree_) {
                JGridDemo.this.tree_actionPerformed(actionEvent);
            } else if (object == JGridDemo.this.print_) {
                JGridDemo.this.print_actionPerformed(actionEvent);
            } else if (object == JGridDemo.this.layout_) {
                JGridDemo.this.layout_actionPerformed(actionEvent);
            }
        }
    }
}

