/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.contour;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.contour.ContourLine;
import gov.noaa.pmel.sgt.contour.GridFlag;
import gov.noaa.pmel.sgt.contour.Sides;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;

public class Contour
implements PropertyChangeListener {
    private SGTGrid grid_;
    private SGTGrid mask_;
    private CartesianGraph cg_;
    private ContourLevels contourLevels_;
    private double zmin_;
    private double zmax_;
    private boolean upToDate_;
    private GeoDate tref_ = null;
    private boolean xTime_ = false;
    private boolean yTime_ = false;
    private double[] px_;
    private double[] py_;
    private double[] z_;
    private double[] xx_;
    private double[] yy_;
    private double[] zz_;
    private boolean[] used_;
    private int[] kabov_;
    private int[] isin_ = new int[]{0, 1, 0, -1};
    private double weezee_;
    private int nx_;
    private int ny_;
    private Vector contourLines_;
    private Sides sides_;
    private GridFlag gridFlag_;
    private static double DSLAB = 2.0;
    private static double SLAB1F = 0.4;

    public Contour(CartesianGraph cartesianGraph, SGTGrid sGTGrid, Range2D range2D) {
        this.cg_ = cartesianGraph;
        this.grid_ = sGTGrid;
        this.contourLevels_ = ContourLevels.getDefault(range2D);
        this.init();
        this.upToDate_ = false;
    }

    public Contour(CartesianGraph cartesianGraph, SGTGrid sGTGrid, double[] dArray) {
        this.cg_ = cartesianGraph;
        this.grid_ = sGTGrid;
        this.contourLevels_ = ContourLevels.getDefault(dArray);
        this.init();
        this.upToDate_ = false;
    }

    public Contour(CartesianGraph cartesianGraph, SGTGrid sGTGrid, ContourLevels contourLevels) {
        this.cg_ = cartesianGraph;
        this.grid_ = sGTGrid;
        this.contourLevels_ = contourLevels;
        this.contourLevels_.addPropertyChangeListener(this);
        this.init();
        this.upToDate_ = false;
    }

    public ContourLevels getContourLevels() {
        return this.contourLevels_;
    }

    public void setMask(SGTGrid sGTGrid) {
        if (this.mask_ == null || !this.mask_.equals(sGTGrid)) {
            this.upToDate_ = false;
        }
        this.mask_ = sGTGrid;
    }

    public SGTGrid getMask() {
        return this.mask_;
    }

    public Enumeration elements() {
        if (!this.upToDate_) {
            this.generateContourLines();
        }
        return this.contourLines_.elements();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void init() {
        GeoDate[] geoDateArray;
        if (this.grid_.isXTime()) {
            this.xTime_ = true;
            geoDateArray = this.grid_.getTimeArray();
            this.tref_ = geoDateArray[0];
            this.px_ = this.getTimeOffsetArray(geoDateArray, this.tref_);
            this.nx_ = this.grid_.getTSize();
        } else {
            this.px_ = this.grid_.getXArray();
            this.nx_ = this.grid_.getXSize();
        }
        if (this.grid_.isYTime()) {
            this.yTime_ = true;
            geoDateArray = this.grid_.getTimeArray();
            this.tref_ = geoDateArray[0];
            this.py_ = this.getTimeOffsetArray(geoDateArray, this.tref_);
            this.ny_ = this.grid_.getTSize();
        } else {
            this.py_ = this.grid_.getYArray();
            this.ny_ = this.grid_.getYSize();
        }
        this.sides_ = new Sides(this.nx_, this.ny_);
        this.xx_ = new double[4];
        this.yy_ = new double[4];
        this.zz_ = new double[4];
        this.used_ = new boolean[4];
        this.kabov_ = new int[4];
        this.z_ = this.grid_.getZArray();
    }

    private double[] getTimeOffsetArray(GeoDate[] geoDateArray, GeoDate geoDate) {
        double[] dArray = new double[geoDateArray.length];
        for (int i = 0; i < geoDateArray.length; ++i) {
            dArray[i] = geoDateArray[i].offset(geoDate);
        }
        return dArray;
    }

    private GeoDate[] getTimeArray(double[] dArray, GeoDate geoDate) {
        GeoDate[] geoDateArray = new GeoDate[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            geoDateArray[i] = new GeoDate(geoDate);
            geoDateArray[i].increment(dArray[i], 1);
        }
        return geoDateArray;
    }

    public void generateContourLines() {
        int n = 0;
        int n2 = 0;
        if (this.upToDate_) {
            return;
        }
        this.contourLines_ = new Vector();
        this.upToDate_ = true;
        this.computeMinMax();
        double d = (this.zmax_ - this.zmin_) * 1.1;
        if (d <= 0.0) {
            return;
        }
        this.weezee_ = d * 2.0E-4;
        Enumeration enumeration = this.contourLevels_.levelElements();
        while (enumeration.hasMoreElements()) {
            double d2 = (Double)enumeration.nextElement();
            if (d2 <= this.zmin_ || d2 >= this.zmax_) continue;
            this.sides_.clear();
            this.gridFlag_ = this.mask_ != null ? new GridFlag(this.grid_, this.mask_, d2) : new GridFlag(this.grid_, d2);
            for (int i = 0; i < this.nx_; ++i) {
                block4: for (int j = 0; j < this.ny_; ++j) {
                    n = i;
                    n2 = j;
                    int n3 = this.gridFlag_.getValue(n, n2);
                    int n4 = n < this.nx_ - 1 ? this.gridFlag_.getValue(n + 1, n2) : 10;
                    int n5 = n2 < this.ny_ - 1 ? this.gridFlag_.getValue(n, n2 + 1) : 10;
                    int n6 = this.sides_.getSide(n, n2, 0);
                    int n7 = this.sides_.getSide(n, n2, 3);
                    int n8 = 0;
                    if (n3 + n4 + n6 == 0) {
                        this.computeCorners(n, n2, d2);
                    } else {
                        if (n3 + n5 + n7 != 0) continue;
                        n8 = 3;
                        this.computeCorners(n, n2, d2);
                    }
                    int n9 = n8;
                    int n10 = 0;
                    int n11 = 1;
                    boolean bl = false;
                    ContourLine contourLine = new ContourLine();
                    try {
                        contourLine.setAttributes(this.contourLevels_.getDefaultContourLineAttribute(), this.contourLevels_.getContourLineAttribute(d2));
                    }
                    catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                        System.out.println(contourLevelNotFoundException);
                    }
                    contourLine.setLevel(d2);
                    contourLine.setCartesianGraph(this.cg_);
                    contourLine.setTime(this.tref_, this.xTime_, this.yTime_);
                    this.contourLines_.addElement(contourLine);
                    contourLine.addPoint(0.0, 0.0);
                    while (true) {
                        int n12;
                        int n13;
                        block19: {
                            double d3;
                            double d4;
                            double d5;
                            int n14;
                            int n15;
                            int n16;
                            block18: {
                                n16 = n9 + 1 - (n9 + 1) / 4 * 4;
                                n15 = n16 + 1 - (n16 + 1) / 4 * 4;
                                n14 = n15 + 1 - (n15 + 1) / 4 * 4;
                                if (!bl) {
                                    ++n10;
                                    d5 = (d2 - this.zz_[n9]) / (this.zz_[n16] - this.zz_[n9]);
                                    d4 = this.xx_[n9] + (this.xx_[n16] - this.xx_[n9]) * d5;
                                    d3 = this.yy_[n9] + (this.yy_[n16] - this.yy_[n9]) * d5;
                                    contourLine.addPoint(d4, d3);
                                    this.sides_.setSideUsed(n, n2, n9, true);
                                }
                                bl = false;
                                n13 = n14;
                                if (this.kabov_[n9] + this.kabov_[n14] != 0) break block18;
                                if (this.kabov_[n16] + this.kabov_[n15] != 0) break block19;
                                double d6 = (d2 - this.zz_[n9]) / (this.zz_[n14] - d2);
                                double d7 = (d2 - this.zz_[n16]) / (this.zz_[n15] - d2);
                                if (this.used_[n16] || d6 <= d7 && !this.used_[n14]) break block19;
                                n13 = n16;
                                break block19;
                            }
                            if (this.kabov_[n16] + this.kabov_[n15] == 0) {
                                n13 = n16;
                            } else {
                                n13 = n15;
                                if (this.kabov_[n15] + this.kabov_[n14] != 0) {
                                    if (this.kabov_[n15] + this.kabov_[n14] <= 15) {
                                        int n17 = n9;
                                        int n18 = n15;
                                        if (this.kabov_[n15] > 5) {
                                            n17 = n14;
                                            n18 = n16;
                                        }
                                        ++n10;
                                        d5 = (d2 - this.zz_[n17]) / (this.zz_[n18] - this.zz_[n17]);
                                        d4 = this.xx_[n17] + (this.xx_[n18] - this.xx_[n17]) * d5;
                                        d3 = this.yy_[n17] + (this.yy_[n18] - this.yy_[n17]) * d5;
                                        contourLine.addPoint(d4, d3);
                                    }
                                    if (n11 > 1) {
                                        n12 = n10;
                                        contourLine.setElementAt((Point2D.Double)contourLine.elementAt(1), 0);
                                        contourLine.addPoint((Point2D.Double)contourLine.elementAt(n10));
                                        contourLine.setClosed(false);
                                        contourLine.setKmax(n12);
                                        continue block4;
                                    }
                                    bl = true;
                                    n11 = 2;
                                    contourLine.reverseElements(n10);
                                    n = i;
                                    n2 = j;
                                    n13 = n8;
                                    n9 = n13 + 2 - (n13 + 2) / 4 * 4;
                                    this.computeCorners(n += this.isin_[n13], n2 += this.isin_[3 - n13], d2);
                                    continue;
                                }
                            }
                        }
                        if (this.used_[n13]) {
                            n12 = n10 + 1;
                            contourLine.addPoint((Point2D.Double)contourLine.elementAt(1));
                            contourLine.setElementAt((Point2D.Double)contourLine.elementAt(n10), 0);
                            contourLine.addPoint((Point2D.Double)contourLine.elementAt(2));
                            contourLine.setClosed(true);
                            contourLine.setKmax(n12);
                            continue block4;
                        }
                        n9 = n13 + 2 - (n13 + 2) / 4 * 4;
                        this.computeCorners(n += this.isin_[n13], n2 += this.isin_[3 - n13], d2);
                    }
                }
            }
        }
    }

    private void computeCorners(int n, int n2, double d) {
        boolean[] blArray = new boolean[]{false, false, false, false};
        for (int i = 0; i < 4; ++i) {
            int n3 = n2 + i / 2;
            int n4 = i + 1 - (i + 1) / 4 * 4;
            int n5 = n + n4 / 2;
            this.zz_[i] = Double.NaN;
            this.kabov_[i] = 10;
            if ((n5 + 1) * (this.nx_ - n5) > 0 && (n3 + 1) * (this.ny_ - n3) > 0 && !this.gridFlag_.isMissing(n5, n3)) {
                blArray[i] = this.sides_.isSideUsed(n, n2, i);
                this.zz_[i] = this.setZ(this.z(n5, n3), d);
                this.kabov_[i] = this.zz_[i] < d ? -1 : 1;
            }
            this.xx_[i] = this.px_[Math.max(0, Math.min(n5, this.nx_ - 1))];
            this.yy_[i] = this.py_[Math.max(0, Math.min(n3, this.ny_ - 1))];
        }
        this.used_[0] = blArray[0];
        this.used_[1] = blArray[1];
        this.used_[2] = blArray[2];
        this.used_[3] = blArray[3];
    }

    private double z(int n, int n2) {
        return this.z_[n2 + n * this.ny_];
    }

    private double setZ(double d, double d2) {
        double d3 = d - d2;
        if (Math.abs(d3) < this.weezee_) {
            return d2 + this.weezee_ * (d3 > 0.0 ? 1.0 : -1.0);
        }
        return d;
    }

    private void computeMinMax() {
        boolean bl;
        double[] dArray = this.grid_.getZArray();
        double[] dArray2 = null;
        boolean bl2 = bl = this.mask_ != null;
        if (bl) {
            dArray2 = this.mask_.getZArray();
        }
        this.zmin_ = Double.POSITIVE_INFINITY;
        this.zmax_ = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || bl && dArray2[i] == 0.0) continue;
            this.zmin_ = Math.min(this.zmin_, dArray[i]);
            this.zmax_ = Math.max(this.zmax_, dArray[i]);
        }
    }

    public void generateContourLabels(Graphics graphics) {
        GeoDate geoDate = null;
        double d = 0.0;
        double d2 = 1.0;
        Enumeration enumeration = this.contourLines_.elements();
        while (enumeration.hasMoreElements()) {
            double d3;
            double d4;
            int n;
            ContourLine contourLine = (ContourLine)enumeration.nextElement();
            int n2 = contourLine.getKmax();
            int n3 = this.contourLevels_.getIndex(contourLine.getLevel());
            DefaultContourLineAttribute defaultContourLineAttribute = contourLine.getDefaultContourLineAttribute();
            defaultContourLineAttribute.setContourLineAttribute(contourLine.getContourLineAttribute());
            if (n2 <= 1 || !defaultContourLineAttribute.isLabelEnabled()) continue;
            SGLabel sGLabel = new SGLabel("CLevel", defaultContourLineAttribute.getLabelText(), defaultContourLineAttribute.getLabelHeightP(), new Point2D.Double(0.0, 0.0), 2, 0);
            if (defaultContourLineAttribute.getLabelFont() != null) {
                sGLabel.setFont(defaultContourLineAttribute.getLabelFont());
            }
            sGLabel.setColor(defaultContourLineAttribute.getLabelColor());
            sGLabel.setLayer(this.cg_.getLayer());
            int n4 = (int)sGLabel.getStringWidth(graphics);
            int n5 = (int)sGLabel.getStringHeight(graphics);
            double d5 = this.cg_.getLayer().getXDtoP(n4) - this.cg_.getLayer().getXDtoP(0);
            double d6 = this.cg_.getLayer().getYDtoP(0) - this.cg_.getLayer().getYDtoP(n5);
            double d7 = d6 * 0.5;
            d5 += d7;
            double[] dArray = this.xArrayP();
            double[] dArray2 = this.yArrayP();
            double[] dArray3 = this.grid_.getZArray();
            boolean bl = dArray[0] < dArray[1];
            boolean bl2 = dArray2[0] < dArray2[1];
            int n6 = dArray.length;
            int n7 = dArray2.length;
            double[] dArray4 = new double[n2 + 1];
            double[] dArray5 = new double[n2 + 1];
            double[] dArray6 = new double[n2 + 1];
            if (contourLine.isXTime() || contourLine.isYTime()) {
                geoDate = contourLine.getReferenceTime();
            }
            dArray6[1] = 0.0;
            dArray4 = contourLine.getXArrayP();
            dArray5 = contourLine.getYArrayP();
            for (n = 2; n <= n2; ++n) {
                d4 = dArray4[n] - dArray4[n - 1];
                d3 = dArray5[n] - dArray5[n - 1];
                dArray6[n] = dArray6[n - 1] + Math.sqrt(d4 * d4 + d3 * d3);
            }
            double d8 = dArray6[n2];
            double d9 = d8 * SLAB1F;
            double d10 = Math.max(0.0, DSLAB - d9);
            n = 1;
            while (n < n2) {
                int n8;
                int n9 = Math.max(n - 1, 1);
                if ((d10 = d10 + dArray6[n] - dArray6[n9]) < DSLAB || d8 - dArray6[n] <= 2.0 * d5) {
                    ++n;
                    continue;
                }
                int n10 = n + 1;
                if (n3 != 0) {
                    try {
                        double d11;
                        int n11;
                        int n12;
                        double d12 = Math.abs(this.contourLevels_.getLevel(n3) - this.contourLevels_.getLevel(n3 - 1));
                        if (bl) {
                            for (n12 = 0; !(n12 >= n6 - 1 || dArray4[n] >= dArray[n12] && dArray4[n] <= dArray[n12 + 1]); ++n12) {
                            }
                        } else {
                            for (n12 = 0; !(n12 >= n6 - 1 || dArray4[n] <= dArray[n12] && dArray4[n] >= dArray[n12 + 1]); ++n12) {
                            }
                        }
                        if (bl2) {
                            for (n11 = 0; !(n11 >= n7 - 1 || dArray5[n] >= dArray2[n11] && dArray5[n] <= dArray2[n11 + 1]); ++n11) {
                            }
                        } else {
                            for (n11 = 0; !(n11 >= n7 - 1 || dArray5[n] <= dArray2[n11] && dArray5[n] >= dArray2[n11 + 1]); ++n11) {
                            }
                        }
                        n12 = Math.min(n12, n6 - 2);
                        n11 = Math.min(n11, n7 - 2);
                        double d13 = dArray[n12 + 1] - dArray[n12];
                        double d14 = dArray2[n11 + 1] - dArray2[n11];
                        double d15 = Double.isNaN(dArray3[n11 + (n12 + 1) * n7]) ? 0.0 : (dArray3[n11 + (n12 + 1) * n7] - dArray3[n11 + n12 * n7]) / d13;
                        double d16 = Double.isNaN(dArray3[n11 + 1 + n12 * n7]) ? 0.0 : (dArray3[n11 + 1 + n12 * n7] - dArray3[n11 + n12 * n7]) / d14;
                        double d17 = Math.abs(d15) + Math.abs(d16);
                        if (d17 != 0.0 && (d11 = d12 / d17) < d6 * 1.0) {
                            ++n;
                            continue;
                        }
                    }
                    catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                        System.out.println(contourLevelNotFoundException);
                    }
                }
                boolean bl3 = false;
                for (n8 = n10; n8 <= n2; ++n8) {
                    d4 = dArray4[n8] - dArray4[n];
                    d3 = dArray5[n8] - dArray5[n];
                    d = Math.sqrt(d4 * d4 + d3 * d3);
                    d2 = dArray6[n8] - dArray6[n];
                    if (!(d >= d5)) continue;
                    bl3 = true;
                    break;
                }
                if (d / d2 < 0.8 || !bl3) {
                    ++n;
                    continue;
                }
                contourLine.addLabel(n, (SGLabel)sGLabel.copy(), d6, d5);
                d10 = 0.0;
                n = n8;
            }
        }
    }

    private void drawRotatedRectangle(Graphics graphics, double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.sin(d * Math.PI / 180.0);
        double d7 = Math.cos(d * Math.PI / 180.0);
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        double d8 = d2;
        double d9 = d3;
        dArray[0] = d2;
        dArray2[0] = d3;
        dArray[1] = dArray[0] + d4;
        dArray2[1] = dArray2[0];
        dArray[2] = dArray[1];
        dArray2[2] = dArray2[0] + d5;
        dArray[3] = dArray[0];
        dArray2[3] = dArray2[2];
        for (int i = 0; i < 4; ++i) {
            double d10 = (dArray[i] - d8) * d7 - (dArray2[i] - d9) * d6 + d8;
            double d11 = (dArray2[i] - d9) * d7 + (dArray[i] - d8) * d6 + d9;
            nArray[i] = this.cg_.getLayer().getXPtoD(d10);
            nArray2[i] = this.cg_.getLayer().getYPtoD(d11);
        }
        nArray[4] = nArray[0];
        nArray2[4] = nArray2[0];
        graphics.setColor(Color.blue);
        graphics.drawPolyline(nArray, nArray2, 5);
        graphics.setColor(Color.black);
    }

    private double[] xArrayP() {
        double[] dArray;
        if (this.grid_.isXTime()) {
            GeoDate[] geoDateArray = this.grid_.getTimeArray();
            dArray = new double[geoDateArray.length];
            for (int i = 0; i < geoDateArray.length; ++i) {
                dArray[i] = this.cg_.getXUtoP(geoDateArray[i]);
            }
        } else {
            double[] dArray2 = this.grid_.getXArray();
            dArray = new double[dArray2.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray[i] = this.cg_.getXUtoP(dArray2[i]);
            }
        }
        return dArray;
    }

    private double[] yArrayP() {
        double[] dArray;
        if (this.grid_.isYTime()) {
            GeoDate[] geoDateArray = this.grid_.getTimeArray();
            dArray = new double[geoDateArray.length];
            for (int i = 0; i < geoDateArray.length; ++i) {
                dArray[i] = this.cg_.getYUtoP(geoDateArray[i]);
            }
        } else {
            double[] dArray2 = this.grid_.getYArray();
            dArray = new double[dArray2.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray[i] = this.cg_.getYUtoP(dArray2[i]);
            }
        }
        return dArray;
    }
}

