/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.TimeAxisStyle;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.TimeRange;

class MinuteHourAxis
implements TimeAxisStyle {
    static final int MINUTE_TEST__ = 31;
    static final String defaultMinorLabelFormat__ = "mm";
    static final String defaultMajorLabelFormat__ = "yyyy-MM-dd HH";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 6;

    public double computeLocation(double d, double d2) {
        return d;
    }

    public void computeDefaults(GeoDate geoDate) {
        long l = geoDate.getTime() % 86400000L;
        if (l > 0x6DDD00L) {
            this.defaultMinorLabelInterval_ = 15;
            this.defaultMajorLabelInterval_ = 2;
        } else if (l > 1800000L) {
            this.defaultMinorLabelInterval_ = 5;
            this.defaultMajorLabelInterval_ = 1;
        } else {
            this.defaultMinorLabelInterval_ = 1;
            this.defaultMajorLabelInterval_ = 1;
        }
    }

    public int getMinorValue(GeoDate geoDate) {
        return geoDate.getGMTMinutes();
    }

    public int getMajorValue(GeoDate geoDate) {
        return geoDate.getGMTHours() + 1;
    }

    public boolean isRoomForMajorLabel(GeoDate geoDate) {
        return 1440.0 * ((double)geoDate.getTime() / 8.64E7) > 31.0;
    }

    public boolean isStartOfMinor(GeoDate geoDate) {
        return geoDate.getGMTMinutes() == 0;
    }

    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    public int getDefaultNumSmallTics() {
        return 0;
    }

    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    public GeoDate getStartTime(TimeRange timeRange) {
        GeoDate geoDate = null;
        boolean bl = timeRange.end.after(timeRange.start);
        try {
            if (bl) {
                geoDate = new GeoDate(timeRange.start.getGMTMonth(), timeRange.start.getGMTDay(), timeRange.start.getGMTYear(), timeRange.start.getGMTHours(), timeRange.start.getGMTMinutes(), 0, 0);
                if (!geoDate.equals(timeRange.start)) {
                    geoDate.increment(1.0, 6);
                }
            } else {
                geoDate = new GeoDate(timeRange.end.getGMTMonth(), timeRange.end.getGMTDay(), timeRange.end.getGMTYear(), timeRange.end.getGMTHours(), timeRange.end.getGMTMinutes(), 0, 0);
                if (!geoDate.equals(timeRange.end)) {
                    geoDate.increment(1.0, 6);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return geoDate;
    }

    public double getIncrementValue() {
        return 1.0;
    }

    public int getIncrementUnits() {
        return 6;
    }

    public String toString() {
        return "MinuteHourAxis";
    }
}

