/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimeRange;

public class LinearTransform
extends AxisTransform
implements Cloneable {
    double at_;
    double bt_;
    double a_;
    double b_;

    public LinearTransform() {
    }

    public LinearTransform(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public LinearTransform(Range2D range2D, Range2D range2D2) {
        super(range2D, range2D2);
    }

    public LinearTransform(double d, double d2, GeoDate geoDate, GeoDate geoDate2) {
        super(d, d2, geoDate, geoDate2);
    }

    public LinearTransform(Range2D range2D, TimeRange timeRange) {
        super(range2D, timeRange);
    }

    public LinearTransform(Range2D range2D, SoTRange soTRange) {
        super(range2D, soTRange);
    }

    public double getTransP(double d) {
        return this.a_ * d + this.b_;
    }

    public AxisTransform copy() {
        LinearTransform linearTransform;
        try {
            linearTransform = (LinearTransform)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            linearTransform = new LinearTransform();
        }
        return linearTransform;
    }

    public double getTransP(GeoDate geoDate) {
        return this.at_ * (double)geoDate.getTime() + this.bt_;
    }

    public double getTransP(SoTValue soTValue) {
        if (soTValue.isTime()) {
            long l = soTValue.getLongTime();
            return this.at_ * (double)l + this.bt_;
        }
        double d = ((SoTValue.Double)soTValue).getValue();
        return this.a_ * d + this.b_;
    }

    public double getTransP(long l) {
        return this.at_ * (double)l + this.bt_;
    }

    public double getTransU(double d) {
        return (d - this.b_) / this.a_;
    }

    public GeoDate getTimeTransU(double d) {
        return new GeoDate((long)((d - this.bt_) / this.at_));
    }

    public long getLongTimeTransU(double d) {
        return (long)((d - this.bt_) / this.at_);
    }

    public SoTValue getSoTTransU(double d) {
        if (!this.space_) {
            return new SoTValue.Time((long)((d - this.bt_) / this.at_));
        }
        return new SoTValue.Double((d - this.b_) / this.a_);
    }

    void computeTransform() {
        if (this.space_) {
            double d = this.u1_ - this.u2_;
            if (d == 0.0) {
                this.a_ = 1.0;
                this.b_ = 0.0;
            } else {
                this.a_ = (this.p1_ - this.p2_) / d;
                this.b_ = this.p1_ - this.a_ * this.u1_;
            }
        } else {
            double d = this.t1_ - this.t2_;
            if (d == 0.0) {
                this.at_ = 1.0;
                this.bt_ = 0.0;
            } else {
                this.at_ = (this.p1_ - this.p2_) / d;
                this.bt_ = this.p1_ - this.at_ * (double)this.t1_;
            }
        }
    }

    public String toString() {
        return "LinearTransform: " + this.a_ + ", " + this.b_ + "; " + this.at_ + ", " + this.bt_;
    }
}

