/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.AttributeChangeEvent;
import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisNotFoundException;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorKey;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.DataNotFoundException;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.PointCollectionKey;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.TransformAccess;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.VectorCartesianRenderer;
import gov.noaa.pmel.sgt.VectorKey;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.PointCollection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.swing.JGraphicLayout;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Domain;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.TimeRange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;

public class JPlotLayout
extends JGraphicLayout
implements PropertyChangeListener {
    CartesianGraph coastLine_ = null;
    Layer coastLayer_ = null;
    Logo logo_;
    LineKey lineKey_;
    ColorKey colorKey_;
    PointCollectionKey pointKey_;
    VectorKey vectorKey_;
    private boolean computeScroll_ = false;
    int layerCount_;
    boolean revXAxis_ = false;
    boolean revYAxis_ = false;
    Layer firstLayer_;
    boolean inZoom_ = false;
    GridAttribute gAttr_ = null;
    private boolean isXTime_ = false;
    private boolean isYTime_ = false;
    double xSize_ = XSIZE_;
    double xMin_ = XMIN_;
    double xMax_ = XMAX_;
    double ySize_ = YSIZE_;
    double yMin_ = YMIN_;
    double yMax_ = YSIZE_ - 1.0 * MAIN_TITLE_HEIGHT_ - 2.0 * WARN_HEIGHT_ - 0.5 * WARN_HEIGHT_;
    double mainTitleHeight_ = MAIN_TITLE_HEIGHT_;
    double titleHeight_ = TITLE_HEIGHT_;
    double labelHeight_ = LABEL_HEIGHT_;
    double warnHeight_ = WARN_HEIGHT_;
    double keyHeight_ = KEY_HEIGHT_;
    double xKeySize_ = XKEYSIZE_;
    double yKeySize_ = YKEYSIZE_;
    Color paneColor_ = PANE_COLOR;
    Color keyPaneColor_ = KEYPANE_COLOR;
    boolean autoRangeX_ = false;
    boolean autoRangeY_ = false;
    int autoXIntervals_ = 10;
    int autoYIntervals_ = 10;
    public static final int POINTS = 0;
    public static final int LINE = 1;
    public static final int GRID = 2;
    public static final int VECTOR = 3;
    private int plotType_ = -1;
    private static final Color[] colorList_ = new Color[]{Color.blue, Color.cyan.darker(), Color.green, Color.orange.darker(), Color.red, Color.magenta, Color.black, Color.gray};
    private static final int[] markList_ = new int[]{1, 2, 9, 15, 10, 24, 11, 44};
    private static String LEFT_AXIS = "Left Axis";
    private static String BOTTOM_AXIS = "Bottom Axis";

    public JPlotLayout(SGTData sGTData) {
        this(sGTData, "", null, false);
    }

    public JPlotLayout(SGTData sGTData, String string, Image image, boolean bl) {
        this(sGTData instanceof SGTGrid ? 2 : (sGTData instanceof PointCollection ? 0 : (sGTData instanceof SGTVector ? 3 : 1)), sGTData.isXTime(), sGTData.isYTime(), string, image, bl);
    }

    public JPlotLayout(boolean bl, boolean bl2, boolean bl3, String string, Image image, boolean bl4) {
        this(bl ? 2 : 1, bl2, bl3, string, image, bl4);
    }

    public JPlotLayout(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, Image image, boolean bl5) {
        this(bl ? 2 : (bl2 ? 0 : 1), bl3, bl4, string, image, bl5);
    }

    public JPlotLayout(int n, boolean bl, boolean bl2, String string, Image image, boolean bl3) {
        super(string, image, new Dimension(400, 300));
        int n2;
        double d;
        int n3;
        int n4;
        Layer layer;
        PlainAxis plainAxis = null;
        PlainAxis plainAxis2 = null;
        TimeAxis timeAxis = null;
        TimeAxis timeAxis2 = null;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] nArray3 = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.isXTime_ = bl;
        this.isYTime_ = bl2;
        this.plotType_ = n;
        this.setOpaque(true);
        this.setLayout(new StackedLayout());
        this.setBackground(this.paneColor_);
        this.firstLayer_ = layer = new Layer("Layer 1", new Dimension2D(this.xSize_, this.ySize_));
        if (this.coastLine_ == null) {
            this.add((Component)layer, 0);
        } else {
            this.add((Component)layer, 1);
        }
        if (this.plotType_ == 2) {
            this.colorKey_ = new ColorKey(new Rectangle2D.Double(0.01, 0.01, this.xKeySize_ - 0.01, 1.0), 2, 0);
            this.colorKey_.setId("Color Key");
            this.colorKey_.setVisible(false);
            if (bl3) {
                this.colorKey_.setVAlign(0);
                this.colorKey_.setBorderStyle(2);
                this.colorKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                n4 = 500;
                n3 = (int)((double)n4 / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(n4, n3));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                Layer layer2 = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(layer2);
                layer2.addChild(this.colorKey_);
            } else {
                this.colorKey_.setHAlign(1);
                this.colorKey_.setLocationP(new Point2D.Double(this.xSize_ * 0.5, 0.01));
                layer.addChild(this.colorKey_);
            }
        } else if (this.plotType_ == 0) {
            this.pointKey_ = new PointCollectionKey();
            this.pointKey_.setSelectable(false);
            this.pointKey_.setId("Point Key");
            this.pointKey_.setVAlign(0);
            if (bl3) {
                this.pointKey_.setHAlign(0);
                this.pointKey_.setBorderStyle(2);
                this.pointKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                n4 = 500;
                n3 = (int)((double)n4 / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(n4, n3));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                Layer layer3 = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(layer3);
                layer3.addChild(this.pointKey_);
            } else {
                this.pointKey_.setVAlign(0);
                this.pointKey_.setHAlign(2);
                this.pointKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.02, this.ySize_ - 0.1));
                layer.addChild(this.pointKey_);
            }
        } else if (this.plotType_ == 1) {
            this.lineKey_ = new LineKey();
            this.lineKey_.setSelectable(false);
            this.lineKey_.setId("Line Key");
            this.lineKey_.setVAlign(0);
            if (bl3) {
                this.lineKey_.setHAlign(0);
                this.lineKey_.setBorderStyle(2);
                this.lineKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                n4 = 500;
                n3 = (int)((double)n4 / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(n4, n3));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                Layer layer4 = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(layer4);
                layer4.addChild(this.lineKey_);
            } else {
                this.lineKey_.setVAlign(0);
                this.lineKey_.setHAlign(2);
                this.lineKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.02, this.ySize_ - 0.1));
                layer.addChild(this.lineKey_);
            }
        } else if (this.plotType_ == 3) {
            this.vectorKey_ = new VectorKey();
            this.vectorKey_.setSelectable(false);
            this.vectorKey_.setId("Vector Key");
            this.vectorKey_.setVAlign(0);
            if (bl3) {
                this.vectorKey_.setHAlign(0);
                this.vectorKey_.setBorderStyle(2);
                this.vectorKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                n4 = 500;
                n3 = (int)((double)n4 / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(n4, n3));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                Layer layer5 = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(layer5);
                layer5.addChild(this.vectorKey_);
            } else {
                this.vectorKey_.setVAlign(0);
                this.vectorKey_.setHAlign(2);
                this.vectorKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.02, this.ySize_ - 0.1));
                this.vectorKey_.setSelectable(true);
                layer.addChild(this.vectorKey_);
            }
        }
        if (this.iconImage_ != null) {
            this.logo_ = new Logo(new Point2D.Double(0.0, this.ySize_), 0, 0);
            this.logo_.setImage(this.iconImage_);
            layer.addChild(this.logo_);
            Rectangle rectangle = this.logo_.getBounds();
            d = layer.getXDtoP(rectangle.x + rectangle.width) + 0.05;
            n2 = 0;
        } else {
            d = (this.xMin_ + this.xMax_) * 0.5;
            n2 = 1;
        }
        double d2 = this.ySize_ - 1.0 * this.mainTitleHeight_;
        Font font = new Font("Helvetica", 1, 14);
        this.mainTitle_ = new SGLabel("Line Profile Title", "Profile Plot", this.mainTitleHeight_, new Point2D.Double(d, d2), 2, n2);
        this.mainTitle_.setFont(font);
        layer.addChild(this.mainTitle_);
        Font font2 = new Font("Helvetica", 0, 10);
        this.title2_ = new SGLabel("Second Title", "Warning: Browse image only", this.warnHeight_, new Point2D.Double(d, d2 -= 1.0 * this.warnHeight_), 2, n2);
        this.title2_.setFont(font2);
        layer.addChild(this.title2_);
        this.title3_ = new SGLabel("Warning 2", "Verify accuracy of plot before research use", this.warnHeight_, new Point2D.Double(d, d2 -= 1.0 * this.warnHeight_), 2, n2);
        this.title3_.setFont(font2);
        layer.addChild(this.title3_);
        this.layerCount_ = 0;
        CartesianGraph cartesianGraph = new CartesianGraph("Profile Graph 1");
        GeoDate geoDate = null;
        Date date = null;
        try {
            geoDate = new GeoDate("1992-11-01", "yyyy-MM-dd");
            date = new GeoDate("1993-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        SoTRange soTRange = this.isXTime_ ? new SoTRange.Time(geoDate.getTime(), date.getTime()) : new SoTRange.Double(10.0, 20.0, 2.0);
        SoTRange soTRange2 = this.isYTime_ ? new SoTRange.Time(geoDate.getTime(), date.getTime()) : new SoTRange.Double(400.0, 0.0, -50.0);
        LinearTransform linearTransform = new LinearTransform(new Range2D(this.xMin_, this.xMax_), soTRange);
        LinearTransform linearTransform2 = new LinearTransform(new Range2D(this.yMin_, this.yMax_), soTRange2);
        SoTPoint soTPoint = new SoTPoint(soTRange.getStart(), soTRange2.getStart());
        cartesianGraph.setXTransform(linearTransform);
        cartesianGraph.setYTransform(linearTransform2);
        Font font3 = new Font("Helvetica", 2, 14);
        if (this.isXTime_) {
            timeAxis = new TimeAxis(BOTTOM_AXIS, 0);
            timeAxis.setRangeU(soTRange);
            timeAxis.setLabelHeightP(this.labelHeight_);
            timeAxis.setLocationU(soTPoint);
            timeAxis.setLabelFont(font3);
            cartesianGraph.addXAxis(timeAxis);
        } else {
            plainAxis = new PlainAxis(BOTTOM_AXIS);
            plainAxis.setRangeU(soTRange);
            plainAxis.setNumberSmallTics(0);
            plainAxis.setLocationU(soTPoint);
            plainAxis.setLabelHeightP(this.labelHeight_);
            plainAxis.setLabelFont(font3);
            cartesianGraph.addXAxis(plainAxis);
        }
        if (this.isYTime_) {
            timeAxis2 = new TimeAxis(LEFT_AXIS, 0);
            timeAxis2.setRangeU(soTRange2);
            timeAxis2.setLabelHeightP(this.labelHeight_);
            timeAxis2.setLocationU(soTPoint);
            timeAxis2.setLabelFont(font3);
            cartesianGraph.addYAxis(timeAxis2);
        } else {
            plainAxis2 = new PlainAxis(LEFT_AXIS);
            plainAxis2.setRangeU(soTRange2);
            plainAxis2.setNumberSmallTics(0);
            plainAxis2.setLabelHeightP(this.labelHeight_);
            plainAxis2.setLocationU(soTPoint);
            plainAxis2.setLabelFont(font3);
            cartesianGraph.addYAxis(plainAxis2);
        }
        if (this.plotType_ == 2) {
            IndexedColorMap indexedColorMap = new IndexedColorMap(nArray, nArray2, nArray3);
            LinearTransform linearTransform3 = new LinearTransform(0.0, (double)nArray.length, 0.0, 1.0);
            indexedColorMap.setTransform(linearTransform3);
            this.gAttr_ = new GridAttribute(0, indexedColorMap);
            this.gAttr_.addPropertyChangeListener(this);
            this.colorKey_.setColorMap(indexedColorMap);
        }
        layer.setGraph(cartesianGraph);
    }

    public String getLocationSummary(SGTData sGTData) {
        return "";
    }

    public void addData(Collection collection) {
        this.addData(collection, null, null);
    }

    public void addData(Collection collection, Attribute attribute) {
        this.addData(collection, attribute, null);
    }

    public void addData(PointCollection pointCollection, String string) {
        this.addData((SGTData)pointCollection, string);
    }

    public void addData(Collection collection, String string) {
        this.addData(collection, null, string);
    }

    public void addData(Collection collection, Attribute attribute, String string) {
        for (int i = 0; i < collection.size(); ++i) {
            SGTLine sGTLine = (SGTLine)collection.elementAt(i);
            this.addData(sGTLine, attribute, sGTLine.getTitle());
        }
    }

    public void addData(SGTData sGTData) {
        this.addData(sGTData, null, null);
    }

    public void addData(SGTData sGTData, Attribute attribute) {
        this.addData(sGTData, attribute, null);
    }

    public void addData(SGTData sGTData, String string) {
        this.addData(sGTData, null, string);
    }

    public void addData(SGTData sGTData, Attribute attribute, String string) {
        Axis axis = null;
        Axis axis2 = null;
        SGTGrid sGTGrid = null;
        SGTLine sGTLine = null;
        SGTVector sGTVector = null;
        PointCollection pointCollection = null;
        LineAttribute lineAttribute = null;
        GridAttribute gridAttribute = null;
        PointAttribute pointAttribute = null;
        VectorAttribute vectorAttribute = null;
        SoTRange soTRange = null;
        SoTRange soTRange2 = null;
        Object object = null;
        SoTRange soTRange3 = null;
        SoTPoint soTPoint = null;
        Range2D range2D = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.data_.size() == 0) {
            SGLabel sGLabel;
            Layer layer;
            Serializable serializable;
            super.addData(sGTData);
            SGTData sGTData2 = (SGTData)this.data_.firstElement();
            if (this.plotType_ == 2) {
                sGTGrid = (SGTGrid)sGTData2;
            } else if (this.plotType_ == 0) {
                pointCollection = (PointCollection)sGTData2;
            } else if (this.plotType_ == 1) {
                sGTLine = (SGTLine)sGTData2;
            } else if (this.plotType_ == 3) {
                sGTVector = (SGTVector)sGTData2;
            }
            if (this.plotType_ == 2) {
                if (attribute != null && attribute instanceof GridAttribute) {
                    gridAttribute = (GridAttribute)attribute;
                    gridAttribute.addPropertyChangeListener(this);
                } else {
                    gridAttribute = this.gAttr_;
                }
                this.addAttribute(sGTData, gridAttribute);
                bl4 = gridAttribute.isRaster();
                range2D = this.findRange(sGTGrid, gridAttribute, 3);
                if (gridAttribute.isRaster() && (serializable = gridAttribute.getColorMap()) instanceof TransformAccess) {
                    ((TransformAccess)((Object)serializable)).setRange(range2D);
                }
                soTRange = this.findSoTRange(sGTGrid, gridAttribute, 1);
                soTRange2 = this.findSoTRange(sGTGrid, gridAttribute, 2);
            } else if (this.plotType_ == 1 || this.plotType_ == 0) {
                soTRange = sGTData2.getXRange();
                soTRange2 = sGTData2.getYRange();
            } else if (this.plotType_ == 3) {
                soTRange = this.findSoTRange(sGTVector, 1);
                soTRange2 = this.findSoTRange(sGTVector, 2);
            }
            bl2 = sGTData2.getXMetaData().isReversed();
            bl3 = sGTData2.getYMetaData().isReversed();
            bl = !soTRange.isStartOrEndMissing() && !soTRange2.isStartOrEndMissing();
            this.revXAxis_ = bl2;
            this.revYAxis_ = bl3;
            if (bl) {
                if (bl2) {
                    soTRange.flipStartAndEnd();
                }
                if (bl3) {
                    soTRange2.flipStartAndEnd();
                }
                if (this.isXTime_) {
                    object = soTRange;
                } else if (this.autoRangeX_) {
                    object = Graph.computeRange(soTRange, this.autoXIntervals_);
                } else {
                    object = soTRange;
                    ((SoTRange.Double)object).delta = ((SoTRange.Double)Graph.computeRange((SoTRange)soTRange, (int)this.autoXIntervals_)).delta;
                }
                if (this.isYTime_) {
                    soTRange3 = soTRange2;
                } else if (this.autoRangeY_) {
                    soTRange3 = Graph.computeRange(soTRange2, this.autoYIntervals_);
                } else {
                    soTRange3 = soTRange2;
                    ((SoTRange.Double)soTRange3).delta = ((SoTRange.Double)Graph.computeRange((SoTRange)soTRange2, (int)this.autoYIntervals_)).delta;
                }
                this.adjustRange((SoTRange)object);
                this.adjustRange(soTRange3);
                soTPoint = new SoTPoint(((SoTRange)object).getStart(), soTRange3.getStart());
            }
            String string2 = sGTData2.getXMetaData().getName() + " (" + sGTData2.getXMetaData().getUnits() + ")";
            String string3 = sGTData2.getYMetaData().getName() + " (" + sGTData2.getYMetaData().getUnits() + ")";
            try {
                layer = this.getLayer("Layer 1");
            }
            catch (LayerNotFoundException layerNotFoundException) {
                return;
            }
            CartesianGraph cartesianGraph = (CartesianGraph)layer.getGraph();
            try {
                serializable = new Font("Helvetica", 0, 14);
                SGLabel sGLabel2 = new SGLabel("xaxis title", string2, new Point2D.Double(0.0, 0.0));
                sGLabel2.setFont((Font)serializable);
                sGLabel2.setHeightP(this.titleHeight_);
                axis = cartesianGraph.getXAxis(BOTTOM_AXIS);
                axis.setRangeU(soTRange);
                axis.setLocationU(soTPoint);
                axis.setTitle(sGLabel2);
                SGLabel sGLabel3 = new SGLabel("yaxis title", string3, new Point2D.Double(0.0, 0.0));
                sGLabel3.setFont((Font)serializable);
                sGLabel3.setHeightP(this.titleHeight_);
                axis2 = cartesianGraph.getYAxis(LEFT_AXIS);
                axis2.setRangeU(soTRange3);
                axis2.setLocationU(soTPoint);
                axis2.setTitle(sGLabel3);
            }
            catch (AxisNotFoundException axisNotFoundException) {
                // empty catch block
            }
            if (bl) {
                LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
                linearTransform.setRangeU((SoTRange)object);
                LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getYTransform();
                linearTransform2.setRangeU(soTRange3);
            }
            if (this.plotType_ == 2) {
                cartesianGraph.setData(sGTGrid, gridAttribute);
            } else if (this.plotType_ == 0) {
                if (attribute != null && attribute instanceof PointAttribute) {
                    pointAttribute = (PointAttribute)attribute;
                } else {
                    pointAttribute = new PointAttribute(markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
                    pointAttribute.setMarkHeightP(0.15);
                    pointAttribute.setLabelHeightP(0.15);
                    pointAttribute.setDrawLabel(false);
                    pointAttribute.setLabelColor(Color.red);
                    pointAttribute.setLabelPosition(2);
                }
                pointAttribute.addPropertyChangeListener(this);
                this.addAttribute(sGTData, pointAttribute);
                cartesianGraph.setData(pointCollection, pointAttribute);
            } else if (this.plotType_ == 1) {
                int n = this.isYTime_ ? sGTLine.getXArray().length : sGTLine.getYArray().length;
                lineAttribute = attribute != null && attribute instanceof LineAttribute ? (LineAttribute)attribute : (n >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]));
                lineAttribute.addPropertyChangeListener(this);
                this.addAttribute(sGTData, lineAttribute);
                cartesianGraph.setData(sGTLine, lineAttribute);
            } else if (this.plotType_ == 3) {
                vectorAttribute = attribute != null && attribute instanceof VectorAttribute ? (VectorAttribute)attribute : new VectorAttribute(2, 0.1, Color.black, 0.1);
                vectorAttribute.addPropertyChangeListener(this);
                this.addAttribute(sGTData, vectorAttribute);
                cartesianGraph.setData(sGTVector, vectorAttribute);
            }
            if (string == null) {
                sGLabel = sGTData.getKeyTitle();
                if (sGLabel == null) {
                    sGLabel = new SGLabel("line title", string2, new Point2D.Double(0.0, 0.0));
                }
            } else {
                sGLabel = new SGLabel("line title", string, new Point2D.Double(0.0, 0.0));
            }
            sGLabel.setHeightP(this.keyHeight_);
            int n = 1;
            if (!this.isShowing()) {
                this.computeScroll_ = true;
            }
            if (this.plotType_ == 2) {
                this.colorKey_.setTitle(sGLabel);
                this.colorKey_.setColorMap(gridAttribute.getColorMap());
                this.colorKey_.setVisible(bl4);
            } else if (this.plotType_ == 0) {
                this.pointKey_.addPointGraph((PointCartesianRenderer)cartesianGraph.getRenderer(), sGLabel);
                if (this.keyPane_ != null) {
                    Rectangle rectangle = this.keyPane_.getVisibleRect();
                    if (this.isShowing()) {
                        n = this.pointKey_.getRowHeight();
                    }
                    int n2 = rectangle.height / n;
                    this.keyPane_.setScrollableUnitIncrement(1, n);
                    this.keyPane_.setScrollableBlockIncrement(rectangle.width, n * n2);
                }
            } else if (this.plotType_ == 1) {
                this.lineKey_.addLineGraph((LineCartesianRenderer)cartesianGraph.getRenderer(), sGLabel);
                if (this.keyPane_ != null) {
                    Rectangle rectangle = this.keyPane_.getVisibleRect();
                    if (this.isShowing()) {
                        n = this.lineKey_.getRowHeight();
                    }
                    int n3 = rectangle.height / n;
                    this.keyPane_.setScrollableUnitIncrement(1, n);
                    this.keyPane_.setScrollableBlockIncrement(rectangle.width, n * n3);
                }
            } else if (this.plotType_ == 3) {
                this.vectorKey_.addVectorGraph((VectorCartesianRenderer)cartesianGraph.getRenderer(), sGLabel);
                if (this.keyPane_ != null) {
                    Rectangle rectangle = this.keyPane_.getVisibleRect();
                    if (this.isShowing()) {
                        n = this.vectorKey_.getRowHeight();
                    }
                    int n4 = rectangle.height / n;
                    this.keyPane_.setScrollableUnitIncrement(1, n);
                    this.keyPane_.setScrollableBlockIncrement(rectangle.width, n * n4);
                }
            }
            this.updateCoastLine();
        } else {
            Object object2;
            if (this.plotType_ == 2) {
                return;
            }
            if (sGTData instanceof SGTLine && sGTData.getYMetaData().isReversed() != this.revYAxis_) {
                object2 = this.flipY(sGTData);
                sGTData = object2;
            }
            super.addData(sGTData);
            bl = false;
            ++this.layerCount_;
            if (this.isOverlayed()) {
                SGLabel sGLabel;
                String string4;
                SoTRange soTRange4;
                Layer layer;
                try {
                    layer = this.getLayer("Layer 1");
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    return;
                }
                CartesianGraph cartesianGraph = (CartesianGraph)layer.getGraph();
                LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
                LinearTransform linearTransform3 = (LinearTransform)cartesianGraph.getYTransform();
                try {
                    axis = cartesianGraph.getXAxis(BOTTOM_AXIS);
                    axis2 = cartesianGraph.getYAxis(LEFT_AXIS);
                }
                catch (AxisNotFoundException axisNotFoundException) {
                    // empty catch block
                }
                if (!this.inZoom_) {
                    object2 = null;
                    soTRange4 = null;
                    boolean bl5 = true;
                    Enumeration enumeration = this.data_.elements();
                    while (enumeration.hasMoreElements()) {
                        SGTData sGTData3 = (SGTData)enumeration.nextElement();
                        soTRange = sGTData3.getXRange();
                        soTRange2 = sGTData3.getYRange();
                        bl2 = sGTData3.getXMetaData().isReversed();
                        bl3 = sGTData3.getYMetaData().isReversed();
                        this.revXAxis_ = bl2;
                        this.revYAxis_ = bl3;
                        if (bl2) {
                            soTRange.flipStartAndEnd();
                        }
                        if (bl3) {
                            soTRange2.flipStartAndEnd();
                        }
                        if (bl5) {
                            boolean bl6 = bl = !soTRange.isStartOrEndMissing() && !soTRange2.isStartOrEndMissing();
                            if (!bl) {
                                bl5 = true;
                                continue;
                            }
                            bl5 = false;
                            bl = true;
                            object2 = soTRange;
                            soTRange4 = soTRange2;
                            continue;
                        }
                        bl = !soTRange.isStartOrEndMissing() && !soTRange2.isStartOrEndMissing();
                        if (!bl) continue;
                        ((SoTRange)object2).add(soTRange);
                        soTRange4.add(soTRange2);
                    }
                    if (bl) {
                        if (this.isXTime_) {
                            object = object2;
                        } else if (this.autoRangeX_) {
                            object = Graph.computeRange((SoTRange)object2, this.autoXIntervals_);
                        } else {
                            object = object2;
                            ((SoTRange.Double)object).delta = ((SoTRange.Double)Graph.computeRange((SoTRange)object2, (int)this.autoXIntervals_)).delta;
                        }
                        if (this.isYTime_) {
                            soTRange3 = soTRange4;
                        } else if (this.autoRangeY_) {
                            soTRange3 = Graph.computeRange(soTRange4, this.autoYIntervals_);
                        } else {
                            soTRange3 = soTRange4;
                            ((SoTRange.Double)soTRange3).delta = ((SoTRange.Double)Graph.computeRange(soTRange4, (int)this.autoYIntervals_)).delta;
                        }
                        this.adjustRange((SoTRange)object);
                        this.adjustRange(soTRange3);
                        soTPoint = new SoTPoint(((SoTRange)object).getStart(), soTRange3.getStart());
                        axis.setRangeU((SoTRange)object);
                        axis.setLocationU(soTPoint);
                        axis2.setRangeU(soTRange3);
                        axis2.setLocationU(soTPoint);
                        linearTransform.setRangeU((SoTRange)object);
                        linearTransform3.setRangeU(soTRange3);
                        this.updateCoastLine();
                    }
                }
                Layer layer2 = new Layer("Layer " + (this.layerCount_ + 1), new Dimension2D(this.xSize_, this.ySize_));
                CartesianGraph cartesianGraph2 = new CartesianGraph("Graph " + (this.layerCount_ + 1), linearTransform, linearTransform3);
                if (this.inZoom_) {
                    object2 = null;
                    soTRange4 = null;
                    object2 = axis.getSoTRangeU();
                    soTRange4 = axis2.getSoTRangeU();
                    cartesianGraph2.setClip((SoTRange)object2, soTRange4);
                    cartesianGraph2.setClipping(true);
                }
                if (this.coastLine_ == null) {
                    this.add((Component)layer2, 0);
                } else {
                    this.add((Component)layer2, 1);
                }
                layer2.setGraph(cartesianGraph2);
                layer2.invalidate();
                this.validate();
                if (this.plotType_ == 0) {
                    if (attribute != null && attribute instanceof PointAttribute) {
                        pointAttribute = (PointAttribute)attribute;
                    } else {
                        pointAttribute = new PointAttribute(markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
                        pointAttribute.setMarkHeightP(0.15);
                        pointAttribute.setLabelHeightP(0.15);
                        pointAttribute.setDrawLabel(false);
                        pointAttribute.setLabelColor(Color.red);
                        pointAttribute.setLabelPosition(2);
                    }
                    pointAttribute.addPropertyChangeListener(this);
                    this.addAttribute(sGTData, pointAttribute);
                    cartesianGraph2.setData(sGTData, pointAttribute);
                } else if (this.plotType_ == 1) {
                    int n = this.isYTime_ ? ((SGTLine)sGTData).getXArray().length : ((SGTLine)sGTData).getYArray().length;
                    lineAttribute = attribute != null && attribute instanceof LineAttribute ? (LineAttribute)attribute : (n >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]));
                    lineAttribute.addPropertyChangeListener(this);
                    this.addAttribute(sGTData, lineAttribute);
                    cartesianGraph2.setData(sGTData, lineAttribute);
                } else if (this.plotType_ == 3) {
                    // empty if block
                }
                if (this.pointKey_ != null) {
                    if (string == null) {
                        string4 = sGTData.getXMetaData().getName();
                        sGLabel = new SGLabel("line title", string4, new Point2D.Double(0.0, 0.0));
                    } else {
                        sGLabel = new SGLabel("line title", string, new Point2D.Double(0.0, 0.0));
                    }
                    sGLabel.setHeightP(this.keyHeight_);
                    this.pointKey_.addPointGraph((PointCartesianRenderer)cartesianGraph2.getRenderer(), sGLabel);
                    if (this.keyPane_ != null) {
                        object2 = this.keyPane_.getVisibleRect();
                        int n = ((Rectangle)object2).height / this.pointKey_.getRowHeight();
                        this.keyPane_.setScrollableUnitIncrement(1, this.pointKey_.getRowHeight());
                        this.keyPane_.setScrollableBlockIncrement(((Rectangle)object2).width, this.pointKey_.getRowHeight() * n);
                    }
                }
                if (this.lineKey_ != null) {
                    if (string == null) {
                        string4 = sGTData.getXMetaData().getName();
                        sGLabel = new SGLabel("line title", string4, new Point2D.Double(0.0, 0.0));
                    } else {
                        sGLabel = new SGLabel("line title", string, new Point2D.Double(0.0, 0.0));
                    }
                    sGLabel.setHeightP(this.keyHeight_);
                    this.lineKey_.addLineGraph((LineCartesianRenderer)cartesianGraph2.getRenderer(), sGLabel);
                    if (this.keyPane_ != null) {
                        object2 = this.keyPane_.getVisibleRect();
                        int n = ((Rectangle)object2).height / this.lineKey_.getRowHeight();
                        this.keyPane_.setScrollableUnitIncrement(1, this.lineKey_.getRowHeight());
                        this.keyPane_.setScrollableBlockIncrement(((Rectangle)object2).width, this.lineKey_.getRowHeight() * n);
                    }
                }
            }
        }
    }

    private void adjustRange(SoTRange soTRange) {
        if (soTRange.isTime()) {
            long l;
            long l2 = soTRange.getEnd().getLongTime();
            if (l2 == (l = soTRange.getStart().getLongTime())) {
                l2 += -1702967296L;
                l -= -1702967296L;
                if (soTRange instanceof SoTRange.Time) {
                    ((SoTRange.Time)soTRange).end = l2;
                    ((SoTRange.Time)soTRange).start = l;
                } else {
                    ((SoTRange.GeoDate)soTRange).end = new GeoDate(l2);
                    ((SoTRange.GeoDate)soTRange).start = new GeoDate(l);
                }
            }
        } else {
            double d = ((SoTRange.Double)soTRange).end;
            double d2 = ((SoTRange.Double)soTRange).start;
            double d3 = ((SoTRange.Double)soTRange).delta;
            if (d3 == 0.0) {
                d = d2;
            }
            if (d == d2) {
                if (d == 0.0) {
                    d2 = -1.0;
                    d = 1.0;
                } else {
                    d = d > 0.0 ? 1.1 * d : 0.9 * d;
                    d2 = d2 > 0.0 ? 0.9 * d2 : 1.1 * d2;
                }
                ((SoTRange.Double)soTRange).end = d;
                ((SoTRange.Double)soTRange).start = d2;
                ((SoTRange.Double)soTRange).delta = ((SoTRange.Double)Graph.computeRange((SoTRange)soTRange, (int)10)).delta;
            }
        }
    }

    private SGTData flipY(SGTData sGTData) {
        SimpleLine simpleLine = null;
        SGTLine sGTLine = (SGTLine)sGTData;
        double[] dArray = sGTLine.getYArray();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = -dArray[i];
        }
        simpleLine = new SimpleLine(sGTLine.getXArray(), dArray2, sGTLine.getTitle());
        SGTMetaData sGTMetaData = sGTLine.getYMetaData();
        SGTMetaData sGTMetaData2 = new SGTMetaData(sGTMetaData.getName(), sGTMetaData.getUnits(), sGTMetaData.isReversed(), sGTMetaData.isModulo());
        sGTMetaData2.setModuloValue(sGTMetaData.getModuloValue());
        sGTMetaData2.setModuloTime(sGTMetaData.getModuloTime());
        simpleLine.setXMetaData(sGTLine.getXMetaData());
        simpleLine.setYMetaData(sGTMetaData2);
        return simpleLine;
    }

    public void resetZoom() {
        GridAttribute gridAttribute = null;
        SoTRange soTRange = null;
        SoTRange soTRange2 = null;
        SoTRange soTRange3 = null;
        SoTRange soTRange4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.isBatch();
        this.setBatch(true, "JPlotLayout: resetZoom");
        this.inZoom_ = false;
        this.setAllClipping(false);
        this.setClipping(false);
        boolean bl5 = true;
        Enumeration enumeration = this.data_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute;
            SGTData sGTData = (SGTData)enumeration.nextElement();
            try {
                attribute = this.getAttribute(sGTData);
            }
            catch (DataNotFoundException dataNotFoundException) {
                System.out.println(dataNotFoundException);
                attribute = null;
            }
            if (this.plotType_ == 2) {
                gridAttribute = attribute != null && attribute instanceof GridAttribute ? (GridAttribute)attribute : this.gAttr_;
                soTRange = this.findSoTRange((SGTGrid)sGTData, gridAttribute, 1);
                soTRange2 = this.findSoTRange((SGTGrid)sGTData, gridAttribute, 2);
            } else if (this.plotType_ == 0 || this.plotType_ == 1) {
                soTRange = sGTData.getXRange();
                soTRange2 = sGTData.getYRange();
            } else if (this.plotType_ == 3) {
                soTRange = this.findSoTRange((SGTVector)sGTData, 1);
                soTRange2 = this.findSoTRange((SGTVector)sGTData, 2);
            }
            bl3 = sGTData.getXMetaData().isReversed();
            bl2 = sGTData.getYMetaData().isReversed();
            this.revXAxis_ = bl3;
            this.revYAxis_ = bl2;
            if (bl3) {
                soTRange.flipStartAndEnd();
            }
            if (bl2) {
                soTRange2.flipStartAndEnd();
            }
            if (bl5) {
                boolean bl6 = bl = !soTRange.isStartOrEndMissing() && !soTRange2.isStartOrEndMissing();
                if (!bl) {
                    bl5 = true;
                    continue;
                }
                bl5 = false;
                bl = true;
                soTRange3 = soTRange;
                soTRange4 = soTRange2;
                continue;
            }
            bl = !soTRange.isStartOrEndMissing() && !soTRange2.isStartOrEndMissing();
            if (!bl) continue;
            soTRange3.add(soTRange);
            soTRange4.add(soTRange2);
        }
        if (soTRange3 != null && soTRange4 != null) {
            this.adjustRange(soTRange3);
            this.adjustRange(soTRange4);
            if (bl) {
                try {
                    this.setRange(new SoTDomain(soTRange3, soTRange4, bl3, bl2));
                }
                catch (PropertyVetoException propertyVetoException) {
                    System.out.println("zoom reset denied! " + propertyVetoException);
                }
            }
        }
        this.inZoom_ = false;
        this.updateCoastLine();
        if (!bl4) {
            this.setBatch(false, "JPlotLayout: resetZoom");
        }
    }

    public Domain getRange() {
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
        LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getYTransform();
        Range2D range2D = null;
        Range2D range2D2 = null;
        TimeRange timeRange = null;
        if (linearTransform.isTime()) {
            timeRange = linearTransform.getTimeRangeU();
        } else {
            range2D = linearTransform.getRangeU();
        }
        if (linearTransform2.isTime()) {
            timeRange = linearTransform2.getTimeRangeU();
        } else {
            range2D2 = linearTransform2.getRangeU();
        }
        if (linearTransform.isTime()) {
            return new Domain(timeRange, range2D2);
        }
        if (linearTransform2.isTime()) {
            return new Domain(range2D, timeRange);
        }
        return new Domain(range2D, range2D2);
    }

    public void setRange(SoTDomain soTDomain) throws PropertyVetoException {
        SoTRange soTRange;
        SoTRange soTRange2;
        Domain domain = new Domain();
        if (soTDomain.isXTime()) {
            soTRange2 = soTDomain.getXRange();
            if (soTRange2 instanceof SoTRange.Time) {
                soTRange = (SoTRange.Time)soTRange2;
                domain.setXRange(new TimeRange(soTRange.start, soTRange.end));
            } else {
                soTRange = (SoTRange.GeoDate)soTRange2;
                domain.setXRange(new TimeRange(((SoTRange.GeoDate)soTRange).start, ((SoTRange.GeoDate)soTRange).end));
            }
        } else {
            soTRange2 = (SoTRange.Double)soTDomain.getXRange();
            domain.setXRange(new Range2D(((SoTRange.Double)soTRange2).start, ((SoTRange.Double)soTRange2).end, ((SoTRange.Double)soTRange2).delta));
        }
        if (soTDomain.isYTime()) {
            soTRange2 = soTDomain.getYRange();
            if (soTRange2 instanceof SoTRange.Time) {
                soTRange = (SoTRange.Time)soTRange2;
                domain.setYRange(new TimeRange(soTRange.start, soTRange.end));
            } else {
                soTRange = (SoTRange.GeoDate)soTRange2;
                domain.setYRange(new TimeRange(((SoTRange.GeoDate)soTRange).start, ((SoTRange.GeoDate)soTRange).end));
            }
        } else {
            soTRange2 = (SoTRange.Double)soTDomain.getYRange();
            domain.setYRange(new Range2D(((SoTRange.Double)soTRange2).start, ((SoTRange.Double)soTRange2).end, ((SoTRange.Double)soTRange2).delta));
        }
        domain.setXReversed(soTDomain.isXReversed());
        domain.setYReversed(soTDomain.isYReversed());
        this.setRange(domain);
    }

    public void setRange(Domain domain) throws PropertyVetoException {
        Domain domain2 = this.getRange();
        if (!domain.equals(domain2)) {
            boolean bl = this.isBatch();
            this.setBatch(true, "JPlotLayout: setRange");
            this.vetos_.fireVetoableChange("domainRange", domain2, domain);
            this.inZoom_ = true;
            if (!domain.isXTime()) {
                this.setXRange(domain.getXRange());
            } else {
                this.setXRange(domain.getTimeRange());
            }
            if (!domain.isYTime()) {
                this.setYRange(domain.getYRange(), domain.isYReversed());
            } else {
                this.setYRange(domain.getTimeRange());
            }
            this.changes_.firePropertyChange("domainRange", domain2, domain);
            if (!bl) {
                this.setBatch(false, "JPlotLayout: setRange");
            }
            this.updateCoastLine();
        }
    }

    public void setRangeNoVeto(Domain domain) {
        boolean bl = this.isBatch();
        this.setBatch(true, "JPlotLayout: setRangeNoVeto");
        this.inZoom_ = true;
        this.setClipping(true);
        if (!domain.isXTime()) {
            this.setXRange(domain.getXRange());
        } else {
            this.setXRange(domain.getTimeRange());
        }
        if (!domain.isYTime()) {
            this.setYRange(domain.getYRange(), domain.isYReversed());
        } else {
            this.setYRange(domain.getTimeRange());
        }
        if (!bl) {
            this.setBatch(false, "JPlotLayout: setRangeNoVeto");
        }
        this.updateCoastLine();
    }

    void setXRange(TimeRange timeRange) {
        SoTRange.Time time = new SoTRange.Time(timeRange);
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
        linearTransform.setRangeU(time);
        try {
            Axis axis = cartesianGraph.getXAxis(BOTTOM_AXIS);
            Axis axis2 = cartesianGraph.getYAxis(LEFT_AXIS);
            axis.setRangeU(time);
            SoTRange soTRange = axis2.getSoTRangeU();
            SoTPoint soTPoint = new SoTPoint(((SoTRange)time).getStart(), soTRange.getStart());
            axis.setLocationU(soTPoint);
            axis2.setLocationU(soTPoint);
            if (this.clipping_) {
                this.setAllClip(time, soTRange);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    void setXRange(Range2D range2D) {
        SoTRange soTRange;
        SoTRange soTRange2 = new SoTRange.Double(range2D);
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
        if (this.autoRangeX_) {
            soTRange = Graph.computeRange(soTRange2, this.autoXIntervals_);
        } else {
            soTRange = soTRange2;
            soTRange.delta = ((SoTRange.Double)Graph.computeRange((SoTRange)soTRange2, (int)this.autoXIntervals_)).delta;
        }
        linearTransform.setRangeU(soTRange);
        try {
            Axis axis = cartesianGraph.getXAxis(BOTTOM_AXIS);
            Axis axis2 = cartesianGraph.getYAxis(LEFT_AXIS);
            SoTRange soTRange3 = axis2.getSoTRangeU();
            axis.setRangeU(soTRange);
            soTRange2 = axis.getSoTRangeU();
            SoTPoint soTPoint = new SoTPoint(soTRange2.getStart(), soTRange3.getStart());
            axis.setLocationU(soTPoint);
            axis2.setLocationU(soTPoint);
            if (this.clipping_) {
                this.setAllClip(soTRange2, soTRange3);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    void setYRange(TimeRange timeRange) {
        SoTRange.Time time = new SoTRange.Time(timeRange);
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getYTransform();
        linearTransform.setRangeU(time);
        try {
            Axis axis = cartesianGraph.getXAxis(BOTTOM_AXIS);
            Axis axis2 = cartesianGraph.getYAxis(LEFT_AXIS);
            axis2.setRangeU(time);
            SoTRange soTRange = axis.getSoTRangeU();
            SoTPoint soTPoint = new SoTPoint(soTRange.getStart(), ((SoTRange)time).getStart());
            axis2.setLocationU(soTPoint);
            axis.setLocationU(soTPoint);
            if (this.clipping_) {
                this.setAllClip(soTRange, time);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    void setYRange(Range2D range2D) {
        this.setYRange(range2D, true);
    }

    void setYRange(Range2D range2D, boolean bl) {
        SoTRange soTRange;
        SoTRange soTRange2 = new SoTRange.Double(range2D);
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getYTransform();
        if (!this.data_.isEmpty()) {
            SGTData sGTData = (SGTData)this.data_.elements().nextElement();
            if (this.data_.size() > 0 && bl != sGTData.getYMetaData().isReversed()) {
                soTRange2.flipStartAndEnd();
            }
        }
        if (this.autoRangeY_) {
            soTRange = Graph.computeRange(soTRange2, this.autoYIntervals_);
        } else {
            soTRange = soTRange2;
            soTRange.delta = ((SoTRange.Double)Graph.computeRange((SoTRange)soTRange2, (int)this.autoYIntervals_)).delta;
        }
        linearTransform.setRangeU(soTRange);
        try {
            Axis axis = cartesianGraph.getXAxis(BOTTOM_AXIS);
            Axis axis2 = cartesianGraph.getYAxis(LEFT_AXIS);
            SoTRange soTRange3 = axis.getSoTRangeU();
            axis2.setRangeU(soTRange);
            soTRange2 = axis2.getSoTRangeU();
            SoTPoint soTPoint = new SoTPoint(soTRange3.getStart(), soTRange2.getStart());
            axis2.setLocationU(soTPoint);
            axis.setLocationU(soTPoint);
            if (this.clipping_) {
                this.setAllClip(soTRange3, soTRange2);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    public SGTData getData(String string) {
        try {
            CartesianRenderer cartesianRenderer;
            Layer layer = this.getLayerFromDataId(string);
            if (layer != null && (cartesianRenderer = ((CartesianGraph)layer.getGraph()).getRenderer()) != null) {
                if (cartesianRenderer instanceof LineCartesianRenderer) {
                    return ((LineCartesianRenderer)cartesianRenderer).getLine();
                }
                if (cartesianRenderer instanceof GridCartesianRenderer) {
                    return ((GridCartesianRenderer)cartesianRenderer).getGrid();
                }
            }
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public SGTData getData(CartesianRenderer cartesianRenderer) {
        if (cartesianRenderer instanceof LineCartesianRenderer) {
            return ((LineCartesianRenderer)cartesianRenderer).getLine();
        }
        if (cartesianRenderer instanceof GridCartesianRenderer) {
            return ((GridCartesianRenderer)cartesianRenderer).getGrid();
        }
        return null;
    }

    public void clear() {
        this.data_.removeAllElements();
        ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
        this.removeAll();
        this.add((Component)this.firstLayer_, 0);
        if (this.coastLine_ != null) {
            this.add((Component)this.coastLayer_, 0);
        }
        if (this.lineKey_ != null) {
            this.lineKey_.clearAll();
        }
        if (this.pointKey_ != null) {
            this.pointKey_.clearAll();
        }
        this.inZoom_ = false;
    }

    public void clear(String string) {
        Layer layer = null;
        try {
            layer = this.getLayerFromDataId(string);
            this.remove(layer);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        Enumeration enumeration = this.data_.elements();
        while (enumeration.hasMoreElements()) {
            SGTData sGTData = (SGTData)enumeration.nextElement();
            if (!sGTData.getId().equals(string)) continue;
            this.data_.removeElement(sGTData);
        }
        if (this.lineKey_ != null) {
            this.lineKey_.clear(string);
        }
        if (this.pointKey_ != null) {
            this.pointKey_.clear(string);
        }
        if (this.getComponentCount() <= 0 || layer.equals(this.firstLayer_)) {
            ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
            this.add((Component)this.firstLayer_, 0);
        }
    }

    public Dimension2D getLayerSizeP() {
        return new Dimension2D(this.xSize_, this.ySize_);
    }

    public Layer getFirstLayer() {
        return this.firstLayer_;
    }

    public void setAxesOriginP(Point2D.Double double_) {
        this.xMin_ = double_.x;
        this.yMin_ = double_.y;
    }

    public SoTDomain getGraphDomain() {
        Object object;
        SoTRange soTRange = null;
        SoTRange soTRange2 = null;
        CartesianGraph cartesianGraph = null;
        try {
            object = this.getLayer("Layer 1");
            cartesianGraph = (CartesianGraph)((Layer)object).getGraph();
        }
        catch (LayerNotFoundException layerNotFoundException) {
            return null;
        }
        try {
            object = cartesianGraph.getXAxis(BOTTOM_AXIS);
            Axis axis = cartesianGraph.getYAxis(LEFT_AXIS);
            soTRange = ((Axis)object).getSoTRangeU();
            soTRange2 = axis.getSoTRangeU();
        }
        catch (AxisNotFoundException axisNotFoundException) {
            return null;
        }
        return new SoTDomain(soTRange, soTRange2);
    }

    public void setLayerSizeP(Dimension2D dimension2D) {
        double d;
        Component[] componentArray = this.getComponents();
        CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform linearTransform = (LinearTransform)cartesianGraph.getYTransform();
        LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getXTransform();
        this.xMax_ = dimension2D.width - (this.xSize_ - this.xMax_);
        this.yMax_ = dimension2D.height - (this.ySize_ - this.yMax_);
        this.xSize_ = dimension2D.width;
        this.ySize_ = dimension2D.height;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            ((Layer)componentArray[i]).setSizeP(dimension2D);
        }
        linearTransform.setRangeP(new Range2D(this.yMin_, this.yMax_));
        linearTransform2.setRangeP(new Range2D(this.xMin_, this.xMax_));
        if (this.iconImage_ != null) {
            Rectangle rectangle = this.logo_.getBounds();
            d = this.firstLayer_.getXDtoP(rectangle.x + rectangle.width) + 0.05;
        } else {
            d = (this.xMin_ + this.xMax_) * 0.5;
        }
        double d2 = this.ySize_ - 1.0 * this.mainTitleHeight_;
        this.mainTitle_.setLocationP(new Point2D.Double(d, d2));
        this.title2_.setLocationP(new Point2D.Double(d, d2 -= 1.0 * this.warnHeight_));
        this.title3_.setLocationP(new Point2D.Double(d, d2 -= 1.0 * this.warnHeight_));
    }

    public void setTitleHeightP(double d, double d2) {
        double d3 = this.ySize_ - 1.0 * d;
        double d4 = this.mainTitle_.getLocationP().x;
        boolean bl = this.isBatch();
        this.setBatch(true, "JPlotLayout: setTitleHeightP");
        if (d != this.mainTitleHeight_) {
            this.mainTitleHeight_ = d;
            this.mainTitle_.setHeightP(d);
            this.mainTitle_.setLocationP(new Point2D.Double(d4, d3));
        }
        if (d2 != this.warnHeight_) {
            this.warnHeight_ = d2;
            this.title2_.setHeightP(d2);
            this.title2_.setLocationP(new Point2D.Double(d4, d3 -= 1.0 * d2));
            this.title3_.setHeightP(d2);
            this.title3_.setLocationP(new Point2D.Double(d4, d3 -= 1.0 * this.warnHeight_));
        }
        if (!bl) {
            this.setBatch(false, "JPlotLayout: setTitleHeightP");
        }
    }

    public double getMainTitleHeightP() {
        return this.mainTitleHeight_;
    }

    public double getSecondaryTitleHeightP() {
        return this.warnHeight_;
    }

    public void setKeyBoundsP(Rectangle2D.Double double_) {
        if (this.plotType_ == 2 && this.colorKey_ != null) {
            this.colorKey_.setBoundsP(double_);
        } else if (this.plotType_ == 0 && this.pointKey_ != null) {
            this.pointKey_.setBoundsP(double_);
        } else if (this.plotType_ == 1 && this.lineKey_ != null) {
            this.lineKey_.setBoundsP(double_);
        } else if (this.plotType_ == 3 && this.vectorKey_ != null) {
            this.vectorKey_.setBoundsP(double_);
        }
    }

    public Rectangle2D.Double getKeyBoundsP() {
        if (this.plotType_ == 2 && this.colorKey_ != null) {
            return this.colorKey_.getBoundsP();
        }
        if (this.plotType_ == 0 && this.pointKey_ != null) {
            return this.pointKey_.getBoundsP();
        }
        if (this.plotType_ == 1 && this.lineKey_ != null) {
            return this.lineKey_.getBoundsP();
        }
        if (this.plotType_ == 3 && this.vectorKey_ != null) {
            return this.vectorKey_.getBoundsP();
        }
        return null;
    }

    public void setKeyAlignment(int n, int n2) {
        if (this.plotType_ == 2 && this.colorKey_ != null) {
            this.colorKey_.setAlign(n, n2);
        } else if (this.plotType_ == 0 && this.pointKey_ != null) {
            this.pointKey_.setAlign(n, n2);
        } else if (this.plotType_ == 1 && this.lineKey_ != null) {
            this.lineKey_.setAlign(n, n2);
        } else if (this.plotType_ == 3 && this.vectorKey_ != null) {
            this.vectorKey_.setAlign(n, n2);
        }
    }

    public Point2D.Double getKeyPositionP() {
        Rectangle2D.Double double_ = this.getKeyBoundsP();
        double d = double_.x;
        double d2 = double_.y;
        return new Point2D.Double(d, d2);
    }

    public void setKeyLocationP(Point2D.Double double_) {
        if (this.keyPane_ == null) {
            if (this.plotType_ == 2) {
                this.colorKey_.setLocationP(double_);
            } else if (this.plotType_ == 0) {
                this.pointKey_.setLocationP(double_);
            } else if (this.plotType_ == 1) {
                this.lineKey_.setLocationP(double_);
            } else if (this.plotType_ == 3) {
                this.vectorKey_.setLocationP(double_);
            }
        }
    }

    private void resetAxes() {
        Domain domain = this.getRange();
        if (domain.isXTime()) {
            this.setXRange(domain.getTimeRange());
        } else {
            this.setXRange(domain.getXRange());
        }
        if (domain.isYTime()) {
            this.setYRange(domain.getTimeRange());
        } else {
            this.setYRange(domain.getYRange());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof GridAttribute && propertyChangeEvent.getPropertyName() == "style" && this.plotType_ == 2) {
            SGTGrid sGTGrid = (SGTGrid)this.data_.firstElement();
            try {
                GridAttribute gridAttribute = (GridAttribute)this.getAttribute(sGTGrid);
                Range2D range2D = this.findRange(sGTGrid, gridAttribute, 3);
                if (gridAttribute.isRaster()) {
                    ColorMap colorMap = gridAttribute.getColorMap();
                    if (colorMap instanceof TransformAccess) {
                        ((TransformAccess)((Object)colorMap)).setRange(range2D);
                    }
                    this.colorKey_.setColorMap(colorMap);
                    this.colorKey_.setVisible(true);
                } else {
                    this.colorKey_.setVisible(false);
                }
            }
            catch (DataNotFoundException dataNotFoundException) {
                System.out.println(dataNotFoundException);
            }
            if (this.keyPane_ != null) {
                this.keyPane_.setModified(true, "JPlotLayout: forced setModified");
                this.keyPane_.setBatch(false, "JPlotLayout: propertyChange");
            }
        }
        if (propertyChangeEvent.getSource() instanceof Attribute) {
            boolean bl = true;
            if (propertyChangeEvent instanceof AttributeChangeEvent) {
                bl = ((AttributeChangeEvent)propertyChangeEvent).isLocal();
            }
            this.changes_.firePropertyChange(new AttributeChangeEvent(this, "attribute", null, propertyChangeEvent.getSource(), bl));
        }
    }

    public void setCoastLine(SGTLine sGTLine) {
        if (this.coastLine_ == null) {
            CartesianGraph cartesianGraph = (CartesianGraph)this.firstLayer_.getGraph();
            LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
            LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getYTransform();
            Range2D range2D = linearTransform.getRangeU();
            Range2D range2D2 = linearTransform2.getRangeU();
            this.coastLayer_ = new Layer("CoastLine", new Dimension2D(this.xSize_, this.ySize_));
            this.add((Component)this.coastLayer_, 0);
            this.coastLine_ = new CartesianGraph("CoastLine Graph");
            this.coastLayer_.setGraph(this.coastLine_);
            this.coastLine_.setXTransform(linearTransform);
            this.coastLine_.setYTransform(linearTransform2);
            LineAttribute lineAttribute = new LineAttribute();
            lineAttribute.setColor(new Color(244, 164, 96));
            lineAttribute.addPropertyChangeListener(this);
            this.coastLine_.setData(sGTLine, lineAttribute);
            this.coastLine_.setClip(range2D.start, range2D.end, range2D2.start, range2D2.end);
            this.coastLine_.setClipping(true);
            this.coastLayer_.invalidate();
            this.validate();
        }
    }

    void updateCoastLine() {
        if (this.coastLine_ != null) {
            CartesianGraph cartesianGraph = (CartesianGraph)this.coastLayer_.getGraph();
            LinearTransform linearTransform = (LinearTransform)cartesianGraph.getXTransform();
            LinearTransform linearTransform2 = (LinearTransform)cartesianGraph.getYTransform();
            Range2D range2D = linearTransform.getRangeU();
            Range2D range2D2 = linearTransform2.getRangeU();
            this.coastLine_.setClip(range2D.start, range2D.end, range2D2.start, range2D2.end);
            this.coastLine_.setClipping(true);
            this.coastLayer_.invalidate();
            this.validate();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawPage(graphics2D, pageFormat);
        if (this.keyPane_ != null) {
            graphics2D.setTransform(new AffineTransform());
            Point point = this.keyPane_.getLocation();
            double d = 72.0;
            double d2 = 0.5;
            int n2 = (int)((this.getLayerSizeP().getHeight() + d2) * d) - point.y;
            int n3 = -point.x;
            Point point2 = new Point(n3, n2);
            this.keyPane_.setPageOrigin(point2);
            this.keyPane_.setPageVAlign(-1);
            this.keyPane_.setPageHAlign(1);
            graphics2D.setClip(-1000, -1000, 5000, 5000);
            this.keyPane_.drawPage(graphics2D, pageFormat, true);
        }
        return 0;
    }

    public void setXAutoRange(boolean bl) {
        this.autoRangeX_ = bl;
    }

    public void setYAutoRange(boolean bl) {
        this.autoRangeY_ = bl;
    }

    public void setAutoRange(boolean bl, boolean bl2) {
        this.autoRangeX_ = bl;
        this.autoRangeY_ = bl2;
    }

    public boolean isXAutoRange() {
        return this.autoRangeX_;
    }

    public boolean isYAutoRange() {
        return this.autoRangeY_;
    }

    public void setXAutoIntervals(int n) {
        this.autoXIntervals_ = n;
    }

    public void setYAutoIntervals(int n) {
        this.autoYIntervals_ = n;
    }

    public void setAutoIntervals(int n, int n2) {
        this.autoXIntervals_ = n;
        this.autoYIntervals_ = n2;
    }

    public int getXAutoIntervals() {
        return this.autoXIntervals_;
    }

    public int getYAutoIntervals() {
        return this.autoYIntervals_;
    }

    public void init() {
        if (this.computeScroll_) {
            this.computeScroll_ = false;
            int n = 1;
            if (this.plotType_ != 2) {
                if (this.plotType_ == 0) {
                    if (this.keyPane_ != null) {
                        Rectangle rectangle = this.keyPane_.getVisibleRect();
                        n = this.pointKey_.getRowHeight();
                        int n2 = rectangle.height / n;
                        this.keyPane_.setScrollableUnitIncrement(1, n);
                        this.keyPane_.setScrollableBlockIncrement(rectangle.width, n * n2);
                    }
                } else if (this.plotType_ == 1) {
                    if (this.keyPane_ != null) {
                        Rectangle rectangle = this.keyPane_.getVisibleRect();
                        n = this.lineKey_.getRowHeight();
                        int n3 = rectangle.height / n;
                        this.keyPane_.setScrollableUnitIncrement(1, n);
                        this.keyPane_.setScrollableBlockIncrement(rectangle.width, n * n3);
                    }
                } else if (this.plotType_ == 3 && this.keyPane_ != null) {
                    Rectangle rectangle = this.keyPane_.getVisibleRect();
                    n = this.vectorKey_.getRowHeight();
                    int n4 = rectangle.height / n;
                    this.keyPane_.setScrollableUnitIncrement(1, n);
                    this.keyPane_.setScrollableBlockIncrement(rectangle.width, n * n4);
                }
            }
        }
    }
}

