/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.prop.LineAttributeDialog;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.TimeRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JTimeSeriesDemo
extends JApplet {
    JButton tree_;
    JButton space_ = null;
    JPane pane_;
    MyMouse myMouse_;
    LineAttributeDialog lad_;

    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(600, 500);
        this.pane_ = this.makeGraph();
        this.pane_.setBatch(true);
        JPanel jPanel = this.makeButtonPanel(false);
        this.getContentPane().add((Component)this.pane_, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.pane_.setBatch(false);
    }

    JPanel makeButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.tree_ = new JButton("Tree View");
        MyAction myAction = new MyAction();
        this.tree_.addActionListener(myAction);
        jPanel.add(this.tree_);
        if (bl) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            jPanel.add(this.space_);
        }
        return jPanel;
    }

    public static void main(String[] stringArray) {
        JTimeSeriesDemo jTimeSeriesDemo = new JTimeSeriesDemo();
        JFrame jFrame = new JFrame("Time Series Demo");
        JPanel jPanel = jTimeSeriesDemo.makeButtonPanel(true);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jTimeSeriesDemo.pane_ = jTimeSeriesDemo.makeGraph();
        jTimeSeriesDemo.pane_.setBatch(true);
        jFrame.setSize(600, 500);
        jFrame.getContentPane().add((Component)jTimeSeriesDemo.pane_, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.setVisible(true);
        jTimeSeriesDemo.pane_.setBatch(false);
    }

    JPlotLayout makeGraph() {
        GeoDate geoDate = new GeoDate();
        GeoDate geoDate2 = new GeoDate();
        try {
            geoDate = new GeoDate("1968-11-01", "yyyy-MM-dd");
            geoDate2 = new GeoDate("2001-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        TimeRange timeRange = new TimeRange(geoDate, geoDate2);
        TestData testData = new TestData(4, timeRange, 10.0f, 2, 1.2f, 0.5f, 30.0f);
        SGTData sGTData = testData.getSGTData();
        System.out.println("series length = " + ((SGTLine)sGTData).getYArray().length);
        JPlotLayout jPlotLayout = new JPlotLayout(sGTData, "Time Series Demo", null, false);
        jPlotLayout.addData(sGTData, "Random Data");
        jPlotLayout.setTitles("Time Series Demo", "using JPlotLayout", "");
        this.myMouse_ = new MyMouse();
        jPlotLayout.addMouseListener(this.myMouse_);
        return jPlotLayout;
    }

    void tree_actionPerformed(ActionEvent actionEvent) {
        JClassTree jClassTree = new JClassTree();
        jClassTree.setModal(false);
        jClassTree.setJPane(this.pane_);
        jClassTree.show();
    }

    class MyMouse
    extends MouseAdapter {
        MyMouse() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == JTimeSeriesDemo.this.pane_) {
                this.maybeShowLineAttributeDialog(mouseEvent);
            }
        }

        void maybeShowLineAttributeDialog(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getClickCount() == 2) {
                Object object = JTimeSeriesDemo.this.pane_.getObjectAt(mouseEvent.getX(), mouseEvent.getY());
                JTimeSeriesDemo.this.pane_.setSelectedObject(object);
                if (object instanceof LineCartesianRenderer) {
                    LineAttribute lineAttribute = ((LineCartesianRenderer)object).getLineAttribute();
                    if (JTimeSeriesDemo.this.lad_ == null) {
                        JTimeSeriesDemo.this.lad_ = new LineAttributeDialog();
                    }
                    JTimeSeriesDemo.this.lad_.setLineAttribute(lineAttribute);
                    if (!JTimeSeriesDemo.this.lad_.isShowing()) {
                        JTimeSeriesDemo.this.lad_.setVisible(true);
                    }
                }
            }
        }
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JTimeSeriesDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (object == JTimeSeriesDemo.this.tree_) {
                JTimeSeriesDemo.this.tree_actionPerformed(actionEvent);
            }
        }
    }
}

