/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.ChildNotFoundException;
import gov.noaa.pmel.sgt.ColorKey;
import gov.noaa.pmel.sgt.DataKey;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerControl;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.PaneNotFoundException;
import gov.noaa.pmel.sgt.PointCollectionKey;
import gov.noaa.pmel.sgt.Ruler;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.VectorKey;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataGroupLayer;
import gov.noaa.pmel.sgt.beans.DataTargetMismatchException;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;

public class Panel
extends JComponent
implements LayerControl {
    private JPane pane_ = null;
    private PanelHolder pHolder_ = null;
    private Layer labelLayer_ = null;
    private Layer legendLayer_ = null;
    private Map dataGroupLayerList_ = new HashMap(2);

    public Panel(String string) {
        this.setName(string);
        this.setLayout(new StackedLayout());
    }

    public Panel(PanelHolder panelHolder) {
        this(panelHolder.getId());
        this.pHolder_ = panelHolder;
        this.update();
    }

    public void setPanelHolder(PanelHolder panelHolder) {
        this.pHolder_ = panelHolder;
        this.setName(this.pHolder_.getId());
        this.update();
    }

    public void update() {
        float f = this.pHolder_.getPanelModel().getDpi();
        this.setBounds(this.pHolder_.getBounds());
        double d = (float)this.getBounds().width / f;
        double d2 = (float)this.getBounds().height / f;
        Dimension2D dimension2D = new Dimension2D(d, d2);
        if (this.pane_ != null) {
            boolean bl = this.pane_.isBatch();
            this.pane_.setBatch(true);
            if (this.labelLayer_ == null) {
                this.labelLayer_ = new Layer("Label Layer", dimension2D);
                this.add(this.labelLayer_);
                this.labelLayer_.setPane(this.pane_);
            } else {
                this.labelLayer_.setSizeP(dimension2D);
            }
            if (this.legendLayer_ == null) {
                this.legendLayer_ = new Layer("Legend Layer", dimension2D);
                this.add(this.legendLayer_);
                this.legendLayer_.setPane(this.pane_);
            } else {
                this.legendLayer_.setSizeP(dimension2D);
            }
            this.setBorder(this.pHolder_.getBorder());
            this.invalidate();
            try {
                this.updateLabels();
                this.updateLegends();
                this.updateDataGroups();
            }
            catch (ChildNotFoundException childNotFoundException) {
                childNotFoundException.printStackTrace();
            }
            this.pane_.setBatch(bl);
        }
    }

    private void updateLabels() throws ChildNotFoundException {
        Object object;
        Iterator iterator = this.pHolder_.labelIterator();
        LayerChild[] layerChildArray = this.labelLayer_.getChildren();
        for (int i = 0; i < layerChildArray.length; ++i) {
            object = layerChildArray[i];
            if (this.pHolder_.hasLabel(object.getId())) continue;
            this.labelLayer_.removeChild((LayerChild)object);
        }
        while (iterator.hasNext()) {
            double d;
            SGLabel sGLabel = null;
            object = (Label)iterator.next();
            LayerChild layerChild = this.labelLayer_.findChild(((Label)object).getId());
            Point2D.Double double_ = ((Label)object).getLocationP();
            Rectangle2D.Double double_2 = ((Label)object).getBoundsP();
            if (((Label)object).getOrientation() == 0) {
                d = ((Label)object).getHeightP();
                switch (((Label)object).getJustification()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        double_.x += double_2.getWidth() * 0.5;
                        break;
                    }
                    case 2: {
                        double_.x += double_2.getWidth();
                    }
                }
            } else {
                d = ((Label)object).getWidthP();
                double_.x += double_2.getWidth();
                switch (((Label)object).getJustification()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        double_.y += double_2.getHeight() * 0.5;
                        break;
                    }
                    case 2: {
                        double_.y += double_2.getHeight();
                    }
                }
            }
            if (layerChild == null) {
                sGLabel = new SGLabel(((Label)object).getId(), ((Label)object).getText(), d, double_, 2, ((Label)object).getJustification());
                sGLabel.setVisible(((Label)object).isVisible());
                sGLabel.setSelectable(((Label)object).isSelectable());
                sGLabel.setOrientation(((Label)object).getOrientation());
                sGLabel.setColor(((Label)object).getColor());
                sGLabel.setFont(((Label)object).getFont());
                this.labelLayer_.addChild(sGLabel);
                ((Label)object).setInstantiated(true);
                continue;
            }
            sGLabel = (SGLabel)layerChild;
            sGLabel.setText(((Label)object).getText());
            sGLabel.setHeightP(d);
            sGLabel.setLocationP(double_);
            sGLabel.setHAlign(((Label)object).getJustification());
            sGLabel.setVisible(((Label)object).isVisible());
            sGLabel.setSelectable(((Label)object).isSelectable());
            sGLabel.setOrientation(((Label)object).getOrientation());
            sGLabel.setColor(((Label)object).getColor());
            sGLabel.setFont(((Label)object).getFont());
        }
    }

    private void updateLegends() {
        Iterator iterator = this.pHolder_.legendIterator();
        while (iterator.hasNext()) {
            DataKey dataKey = null;
            Legend legend = (Legend)iterator.next();
            LayerChild layerChild = this.legendLayer_.findChild(legend.getId());
            Rectangle2D.Double double_ = legend.getBoundsP();
            if (layerChild == null) {
                switch (legend.getType()) {
                    case 0: {
                        dataKey = new LineKey(legend.getLocationP(), 0, 0);
                        break;
                    }
                    case 1: {
                        dataKey = new ColorKey(legend.getLocationP(), new Dimension2D(double_.width, double_.height), 0, 0);
                        break;
                    }
                    case 2: {
                        dataKey = new VectorKey(legend.getLocationP(), 0, 0);
                        break;
                    }
                    case 3: {
                        dataKey = new PointCollectionKey(legend.getLocationP(), 0, 0);
                    }
                }
                dataKey.setId(legend.getId());
                this.legendLayer_.addChild(dataKey);
                legend.setInstantiated(true);
            } else {
                dataKey = (DataKey)layerChild;
                dataKey.setLocationP(legend.getLocationP());
            }
            if (legend.isColor()) {
                ColorKey colorKey = (ColorKey)dataKey;
                colorKey.setSizeP(new Dimension2D(double_.width, double_.height));
                Ruler ruler = colorKey.getRuler();
                ruler.setLabelColor(legend.getScaleColor());
                ruler.setLineColor(legend.getScaleColor());
                ruler.setLabelFont(legend.getScaleLabelFont());
                ruler.setLabelHeightP(legend.getScaleLabelHeightP());
                ruler.setLabelInterval(legend.getScaleLabelInterval());
                ruler.setNumberSmallTics(legend.getScaleNumberSmallTics());
                ruler.setLargeTicHeightP(legend.getScaleLargeTicHeightP());
                ruler.setSmallTicHeightP(legend.getScaleSmallTicHeightP());
                ruler.setSignificantDigits(legend.getScaleSignificantDigits());
                ruler.setLabelFormat(legend.getScaleLabelFormat());
                ruler.setVisible(legend.isScaleVisible());
                if (double_.width >= double_.height) {
                    colorKey.setOrientation(1);
                } else {
                    colorKey.setOrientation(2);
                }
            }
            dataKey.setBorderStyle(legend.getBorderStyle());
            dataKey.setColumns(legend.getColumns());
            dataKey.setLineLengthP(legend.getLineLength());
            dataKey.setVisible(legend.isVisible());
        }
    }

    private void updateDataGroups() {
        Layer layer;
        float f = this.pHolder_.getPanelModel().getDpi();
        this.setBounds(this.pHolder_.getBounds());
        double d = (float)this.getBounds().width / f;
        double d2 = (float)this.getBounds().height / f;
        Dimension2D dimension2D = new Dimension2D(d, d2);
        Iterator iterator = this.pHolder_.dataGroupIterator();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer) || (layer = (Layer)componentArray[i]) == this.labelLayer_ || layer == this.legendLayer_ || this.pHolder_.hasDataGroup(layer.getId())) continue;
            this.remove(layer);
        }
        while (iterator.hasNext()) {
            DataGroup dataGroup = (DataGroup)iterator.next();
            layer = this.findDataGroupLayer(dataGroup.getId());
            if (layer == null) {
                layer = new DataGroupLayer(this, dataGroup);
                this.add(layer);
                ((DataGroupLayer)layer).setSizeP(dimension2D);
                dataGroup.setInstantiated(true);
                this.dataGroupLayerList_.put(layer.getId(), layer);
                continue;
            }
            ((DataGroupLayer)layer).update();
        }
    }

    public Object getObjectAt(int n, int n2, boolean bl) {
        Object object = null;
        object = this.labelLayer_.getObjectAt(n, n2, bl);
        if (object != null) {
            return object;
        }
        object = this.legendLayer_.getObjectAt(n, n2, bl);
        if (object != null) {
            return object;
        }
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            object = ((DataGroupLayer)iterator.next()).getObjectAt(n, n2, bl);
            if (object == null) continue;
            return object;
        }
        return object;
    }

    void zoomTo(Point point, Rectangle rectangle) {
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            ((DataGroupLayer)iterator.next()).zoomTo(point, rectangle);
        }
    }

    void resetZoom(int n, int n2) {
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            ((DataGroupLayer)iterator.next()).resetZoom(n, n2);
        }
    }

    public void resetZoom() {
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            ((DataGroupLayer)iterator.next()).resetZoom();
        }
    }

    public void setClipping(boolean bl) {
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            ((DataGroupLayer)iterator.next()).setClipping(bl);
        }
    }

    public boolean hasLayer(String string) {
        if (string.equals(this.labelLayer_.getId())) {
            return true;
        }
        if (string.equals(this.legendLayer_.getId())) {
            return true;
        }
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            if (!string.equals(((DataGroupLayer)iterator.next()).getId())) continue;
            return true;
        }
        return false;
    }

    public Layer getLayer(String string) {
        if (string.equals(this.labelLayer_.getId())) {
            return this.labelLayer_;
        }
        if (string.equals(this.legendLayer_.getId())) {
            return this.legendLayer_;
        }
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            DataGroupLayer dataGroupLayer = (DataGroupLayer)iterator.next();
            if (!string.equals(dataGroupLayer.getId())) continue;
            return dataGroupLayer;
        }
        return null;
    }

    public boolean isDataInPanel(String string) {
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            DataGroupLayer dataGroupLayer = (DataGroupLayer)iterator.next();
            if (!dataGroupLayer.isDataInLayer(string)) continue;
            return true;
        }
        return false;
    }

    public Layer getLayerFromDataId(String string) {
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            DataGroupLayer dataGroupLayer = (DataGroupLayer)iterator.next();
            if (!dataGroupLayer.isDataInLayer(string)) continue;
            return dataGroupLayer;
        }
        return null;
    }

    public Object[] getObjectsAt(int n, int n2, boolean bl) {
        int n3;
        Object[] objectArray = null;
        Vector<Object> vector = new Vector<Object>();
        objectArray = this.labelLayer_.getObjectsAt(n, n2, bl);
        if (objectArray != null) {
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                vector.addElement(objectArray[n3]);
            }
        }
        if ((objectArray = this.legendLayer_.getObjectsAt(n, n2, bl)) != null) {
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                vector.addElement(objectArray[n3]);
            }
        }
        Iterator iterator = this.dataGroupLayerList_.values().iterator();
        while (iterator.hasNext()) {
            objectArray = ((DataGroupLayer)iterator.next()).getObjectsAt(n, n2, bl);
            if (objectArray == null) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                vector.addElement(objectArray[i]);
            }
        }
        return vector.toArray();
    }

    public DataGroupLayer findDataGroupLayer(String string) {
        return (DataGroupLayer)this.dataGroupLayerList_.get(string);
    }

    public JPane getPane() {
        return this.pane_;
    }

    public void setPane(AbstractPane abstractPane) {
        this.pane_ = (JPane)abstractPane;
        this.update();
    }

    public void draw(Graphics graphics) throws PaneNotFoundException {
        Component[] componentArray;
        if (!this.pHolder_.isUsePageBackground()) {
            componentArray = graphics.getColor();
            Rectangle rectangle = this.pHolder_.getBounds();
            graphics.setColor(this.pHolder_.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor((Color)componentArray);
        }
        componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof LayerControl)) continue;
            ((LayerControl)((Object)componentArray[i])).draw(graphics);
        }
    }

    public void drawDraggableItems(Graphics graphics) throws PaneNotFoundException {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof LayerControl)) continue;
            ((LayerControl)((Object)componentArray[i])).drawDraggableItems(graphics);
        }
    }

    public void addData(SGTData sGTData, Attribute attribute, DataGroup dataGroup, Legend legend) throws DataTargetMismatchException {
        DataGroupLayer dataGroupLayer = this.findDataGroupLayer(dataGroup.getId());
        DataKey dataKey = null;
        if (legend != null) {
            dataKey = (DataKey)this.legendLayer_.findChild(legend.getId());
        }
        dataGroupLayer.addData(sGTData, attribute, dataKey);
    }

    public String getId() {
        return this.getName();
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.pHolder_.getId();
    }
}

