/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.DataKey;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.MethodNotImplementedError;
import gov.noaa.pmel.sgt.Moveable;
import gov.noaa.pmel.sgt.SGException;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.VectorCartesianRenderer;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;

public class VectorKey
implements Cloneable,
DataKey,
Moveable,
PropertyChangeListener {
    private String ident_;
    private Layer layer_;
    private Vector vectors_;
    private Vector label_;
    private Vector scaleLabel_;
    private int columns_;
    private int style_;
    private int valign_;
    private int halign_;
    private Point2D.Double porigin_;
    private double vectorLengthP_;
    private int maxLabelLength_;
    private int maxLabelHeight_;
    private int maxScaleLength_;
    private String floatScaleFormat_ = "###.##";
    private String expScaleFormat_ = "0.####E0";
    private DecimalFormat floatFormat_;
    private DecimalFormat expFormat_;
    private float xoff_;
    private float yoff_;
    private float slope_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private boolean moveable_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final int VERTICAL_BORDER_ = 3;
    private static final int HORIZONTAL_BORDER_ = 15;
    private static final int COLUMN_SPACE_ = 10;
    private static final int ROW_SPACE_ = 3;
    private static final int LABEL_SPACE_ = 10;
    private static final int SCALE_SPACE_ = 7;
    public static final int PLAIN_LINE = 0;
    public static final int RAISED = 1;
    public static final int NO_BORDER = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public VectorKey() {
        this(new Point2D.Double(0.0, 0.0), 2, 0);
    }

    public VectorKey(Point2D.Double double_, int n, int n2) {
        this.porigin_ = double_;
        this.valign_ = n;
        this.halign_ = n2;
        this.vectors_ = new Vector(2, 2);
        this.label_ = new Vector(2, 2);
        this.scaleLabel_ = new Vector(2, 2);
        this.style_ = 0;
        this.columns_ = 1;
        this.ident_ = "";
        this.vectorLengthP_ = 0.3f;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.moveable_ = true;
        this.floatFormat_ = new DecimalFormat(this.floatScaleFormat_);
        this.expFormat_ = new DecimalFormat(this.expScaleFormat_);
    }

    public LayerChild copy() {
        VectorKey vectorKey;
        try {
            vectorKey = (VectorKey)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            vectorKey = new VectorKey();
        }
        vectorKey.vectors_ = new Vector(2, 2);
        vectorKey.label_ = new Vector(2, 2);
        return vectorKey;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelectable(boolean bl) {
        this.selectable_ = bl;
    }

    public boolean isSelectable() {
        return this.selectable_;
    }

    public boolean isMoveable() {
        return this.moveable_;
    }

    public void setMoveable(boolean bl) {
        this.moveable_ = bl;
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    public void modified(String string) {
        if (this.layer_ != null) {
            this.layer_.modified(string);
        }
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setVectorLengthP(double d) {
        if (this.vectorLengthP_ != d) {
            this.vectorLengthP_ = d;
            this.modified("VectorKey: setVectorLengthP()");
        }
    }

    public void setLineLengthP(double d) {
        this.setVectorLengthP(d);
    }

    public double getVectorLengthP() {
        return this.vectorLengthP_;
    }

    public void setColumns(int n) {
        if (this.columns_ != n) {
            this.columns_ = n;
            this.modified("VectorKey: setColumms()");
        }
    }

    public int getColumns() {
        return this.columns_;
    }

    public void setBorderStyle(int n) {
        if (this.style_ != n) {
            this.style_ = n;
            this.modified("VectorKey: setBorderStyle()");
        }
    }

    public int getBorderStyle() {
        return this.style_;
    }

    public void setAlign(int n, int n2) {
        if (this.valign_ != n || this.halign_ != n2) {
            this.valign_ = n;
            this.halign_ = n2;
            this.modified("VectorKey: setAlign()");
        }
    }

    public void setVAlign(int n) {
        if (this.valign_ != n) {
            this.valign_ = n;
            this.modified("VectorKey: setVAlign()");
        }
    }

    public void setHAlign(int n) {
        if (this.halign_ != n) {
            this.halign_ = n;
            this.modified("VectorKey: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public void setLocationP(Point2D.Double double_) {
        if (this.porigin_ == null || !this.porigin_.equals(double_)) {
            Point2D.Double double_2 = this.porigin_;
            this.porigin_ = double_;
            this.changes_.firePropertyChange("location", double_2, this.porigin_);
            this.modified("VectorKey: setLocationP()");
        }
    }

    public void setBoundsP(Rectangle2D.Double double_) {
        this.setLocationP(new Point2D.Double(double_.x, double_.y));
    }

    public Rectangle2D.Double getBoundsP() {
        throw new MethodNotImplementedError();
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public void addVectorGraph(VectorCartesianRenderer vectorCartesianRenderer, SGLabel sGLabel) {
        this.vectors_.addElement(vectorCartesianRenderer);
        sGLabel.setLayer(this.layer_);
        sGLabel.setMoveable(false);
        sGLabel.setSelectable(false);
        this.label_.addElement(sGLabel);
        SGLabel sGLabel2 = new SGLabel("scale label", " ", sGLabel.getHeightP(), sGLabel.getLocationP(), sGLabel.getVAlign(), sGLabel.getHAlign());
        sGLabel2.setFont(sGLabel.getFont());
        sGLabel2.setLayer(sGLabel.getLayer());
        sGLabel2.setMoveable(false);
        sGLabel2.setSelectable(false);
        this.scaleLabel_.addElement(sGLabel2);
        ((VectorAttribute)vectorCartesianRenderer.getAttribute()).addPropertyChangeListener(this);
        this.modified("VectorKey: addVectorGraph()");
    }

    public void addGraph(CartesianRenderer cartesianRenderer, SGLabel sGLabel) throws IllegalArgumentException {
        if (!(cartesianRenderer instanceof VectorCartesianRenderer)) {
            throw new IllegalArgumentException("Renderer is not a VectorCartesianRenderer");
        }
        this.addVectorGraph((VectorCartesianRenderer)cartesianRenderer, sGLabel);
    }

    public void removeVectorGraph(SGLabel sGLabel) {
    }

    public void removeVectorRenderer(VectorCartesianRenderer vectorCartesianRenderer) {
    }

    public void removeVectorGraph(String string) {
    }

    public void clearAll() {
        Enumeration enumeration = this.vectors_.elements();
        while (enumeration.hasMoreElements()) {
            VectorAttribute vectorAttribute = (VectorAttribute)((VectorCartesianRenderer)enumeration.nextElement()).getAttribute();
            vectorAttribute.removePropertyChangeListener(this);
        }
        this.vectors_.removeAllElements();
        this.label_.removeAllElements();
        this.modified("VectorKey: clearAll()");
    }

    public void clear(String string) {
        int n = -1;
        Enumeration enumeration = this.vectors_.elements();
        while (enumeration.hasMoreElements()) {
            ++n;
            VectorCartesianRenderer vectorCartesianRenderer = (VectorCartesianRenderer)enumeration.nextElement();
        }
    }

    public int getRowHeight() {
        Rectangle rectangle = this.getBounds();
        return 3 + this.maxLabelHeight_;
    }

    public void draw(Graphics graphics) {
        int n;
        VectorCartesianRenderer vectorCartesianRenderer = null;
        VectorAttribute vectorAttribute = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        this.slope_ = (float)this.layer_.getXSlope();
        this.xoff_ = (float)this.layer_.getXOffset();
        this.yoff_ = (float)this.layer_.getYOffset();
        int n2 = this.vectors_.size();
        if (n2 <= 0 || !this.visible_) {
            return;
        }
        int n3 = n2 / this.columns_;
        if (n2 % this.columns_ != 0) {
            ++n3;
        }
        double[] dArray = new double[this.columns_];
        int[] nArray = new int[this.columns_];
        double[] dArray2 = new double[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[2];
        graphics.setColor(this.layer_.getPane().getComponent().getForeground());
        Rectangle rectangle = this.getBounds();
        float f = this.xPtoD((float)this.vectorLengthP_) - this.xPtoD(0.0f);
        double d = this.layer_.getXDtoP(10) - this.layer_.getXDtoP(0);
        double d2 = this.layer_.getXDtoP(this.maxScaleLength_) - this.layer_.getXDtoP(0);
        double d3 = this.layer_.getXDtoP(7) - this.layer_.getXDtoP(0);
        nArray2[0] = rectangle.y + 3 + this.maxLabelHeight_;
        dArray2[0] = this.layer_.getYDtoP(nArray2[0]);
        for (n = 1; n < n3; ++n) {
            nArray2[n] = nArray2[n - 1] + 3 + this.maxLabelHeight_;
            dArray2[n] = this.layer_.getYDtoP(nArray2[n]);
        }
        nArray[0] = rectangle.x + 15;
        dArray[0] = this.layer_.getXDtoP(nArray[0]);
        for (n = 1; n < this.columns_; ++n) {
            nArray[n] = nArray[n - 1] + 10 + (int)f + 7 + this.maxScaleLength_ + 10 + this.maxLabelLength_;
            dArray[n] = this.layer_.getXDtoP(nArray[n]);
        }
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = this.label_.elements();
        Enumeration enumeration2 = this.scaleLabel_.elements();
        Enumeration enumeration3 = this.vectors_.elements();
        while (enumeration3.hasMoreElements()) {
            Object e = enumeration3.nextElement();
            vectorCartesianRenderer = (VectorCartesianRenderer)e;
            vectorAttribute = (VectorAttribute)vectorCartesianRenderer.getAttribute();
            SGLabel sGLabel = (SGLabel)enumeration.nextElement();
            SGLabel sGLabel2 = (SGLabel)enumeration2.nextElement();
            graphics2D.setColor(vectorAttribute.getVectorColor());
            BasicStroke basicStroke = new BasicStroke(vectorAttribute.getWidth(), vectorAttribute.getCapStyle(), vectorAttribute.getMiterStyle(), vectorAttribute.getMiterLimit());
            float f2 = (float)vectorAttribute.getVectorScale();
            float f3 = (float)vectorAttribute.getHeadScale() * 0.94386f;
            float f4 = (float)((double)f3 * vectorAttribute.getHeadFixedSize());
            float f5 = (float)vectorAttribute.getHeadMinSize();
            float f6 = (float)vectorAttribute.getHeadMaxSize();
            float f7 = (float)(this.vectorLengthP_ / (double)f2);
            graphics2D.setStroke(basicStroke);
            GeneralPath generalPath = new GeneralPath();
            float f8 = nArray[n5];
            float f9 = nArray2[n4] - this.maxLabelHeight_ / 2;
            float f10 = f8 + f;
            float f11 = f9;
            float f12 = this.xDtoP(f10);
            float f13 = this.yDtoP(f11);
            generalPath.moveTo(f8, f9);
            generalPath.lineTo(f10, f11);
            if ((double)f == 0.0) {
                graphics.drawLine((int)f10, (int)f11, (int)f10, (int)f11);
            } else if (vectorAttribute.getVectorStyle() != 0) {
                float f14;
                float f15;
                float f16;
                float f17;
                float f18;
                if (vectorAttribute.getVectorStyle() == 1) {
                    f18 = f4;
                    f17 = this.xPtoD(f12 - f18);
                    f16 = this.yPtoD(f13 + 0.35f * f18);
                    f15 = this.xPtoD(f12 - f18);
                    f14 = this.yPtoD(f13 - 0.35f * f18);
                    generalPath.moveTo(f17, f16);
                    generalPath.lineTo(f10, f11);
                    generalPath.lineTo(f15, f14);
                } else {
                    f18 = this.vectorLengthP_ >= (double)f6 ? f6 * f3 : (this.vectorLengthP_ <= (double)f5 ? f5 * f3 : (float)(this.vectorLengthP_ * (double)f3));
                    f17 = this.xPtoD(f12 - f18);
                    f16 = this.yPtoD(f13 + 0.35f * f18);
                    f15 = this.xPtoD(f12 - f18);
                    f14 = this.yPtoD(f13 - 0.35f * f18);
                    generalPath.moveTo(f17, f16);
                    generalPath.lineTo(f10, f11);
                    generalPath.lineTo(f15, f14);
                }
            }
            graphics2D.draw(generalPath);
            graphics2D.setStroke(stroke);
            nArray3[0] = (int)f8;
            nArray4[0] = (int)f9;
            if (vectorAttribute.getOriginStyle() == 1) {
                graphics.setColor(vectorAttribute.getMarkColor());
                vectorCartesianRenderer.drawMark(graphics, nArray3, nArray4, 1, vectorAttribute);
            }
            double d4 = dArray[n5] + this.vectorLengthP_ + d3;
            String string = (double)f7 > 1000.0 || (double)f7 < 0.01 ? this.expFormat_.format(f7) : this.floatFormat_.format(f7);
            sGLabel2.setText(string);
            sGLabel2.setLocationP(new Point2D.Double(d4, dArray2[n4]));
            d4 = d4 + d2 + d;
            sGLabel.setLocationP(new Point2D.Double(d4, dArray2[n4]));
            try {
                sGLabel2.draw(graphics);
                sGLabel.draw(graphics);
            }
            catch (SGException sGException) {
                System.out.println(sGException);
            }
            if (++n5 < this.columns_) continue;
            n5 = 0;
            ++n4;
        }
        switch (this.style_) {
            case 0: {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private float xPtoD(float f) {
        return this.slope_ * f + this.xoff_;
    }

    private float yPtoD(float f) {
        return this.yoff_ - this.slope_ * f;
    }

    private float xDtoP(float f) {
        return (f - this.xoff_) / this.slope_;
    }

    private float yDtoP(float f) {
        return (this.yoff_ - f) / this.slope_;
    }

    public Rectangle getBounds() {
        int n = this.vectors_.size();
        if (n <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.maxLabelLength_ = 0;
        this.maxLabelHeight_ = 0;
        this.maxScaleLength_ = 0;
        Enumeration enumeration = this.vectors_.elements();
        Enumeration enumeration2 = this.scaleLabel_.elements();
        Enumeration enumeration3 = this.label_.elements();
        while (enumeration3.hasMoreElements()) {
            SGLabel sGLabel = (SGLabel)enumeration3.nextElement();
            Rectangle rectangle = sGLabel.getBounds();
            this.maxLabelLength_ = Math.max(this.maxLabelLength_, rectangle.width);
            this.maxLabelHeight_ = Math.max(this.maxLabelHeight_, rectangle.height);
            Object e = enumeration.nextElement();
            VectorCartesianRenderer vectorCartesianRenderer = (VectorCartesianRenderer)e;
            VectorAttribute vectorAttribute = (VectorAttribute)vectorCartesianRenderer.getAttribute();
            double d = this.vectorLengthP_ / vectorAttribute.getVectorScale();
            String string = d > 1000.0 || d < 0.01 ? this.expFormat_.format(d) : this.floatFormat_.format(d);
            SGLabel sGLabel2 = (SGLabel)enumeration2.nextElement();
            sGLabel2.setText(string);
            rectangle = sGLabel2.getBounds();
            this.maxScaleLength_ = Math.max(this.maxScaleLength_, rectangle.width);
        }
        int n2 = n / this.columns_;
        if (n % this.columns_ != 0) {
            ++n2;
        }
        int n3 = this.layer_.getXPtoD(this.vectorLengthP_) - this.layer_.getXPtoD(0.0);
        int n4 = 30 + this.columns_ * (n3 + 7 + this.maxScaleLength_ + 10 + this.maxLabelLength_) + (this.columns_ - 1) * 10;
        int n5 = 6 + n2 * this.maxLabelHeight_ + (n2 - 1) * 3;
        n5 += 5;
        int n6 = this.layer_.getXPtoD(this.porigin_.x);
        int n7 = this.layer_.getYPtoD(this.porigin_.y);
        switch (this.halign_) {
            case 2: {
                n6 -= n4;
                break;
            }
            case 1: {
                n6 -= n4 / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                n7 -= n5;
                break;
            }
            case 1: {
                n7 -= n5 / 2;
            }
        }
        return new Rectangle(n6, n7, n4, n5);
    }

    public Point getLocation() {
        Rectangle rectangle = this.getBounds();
        return new Point(rectangle.x, rectangle.y);
    }

    public void setLocation(Point point) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(point.x, point.y, rectangle.width, rectangle.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        switch (this.halign_) {
            case 2: {
                n += n3;
                break;
            }
            case 1: {
                n += n3 / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                n2 += n4;
                break;
            }
            case 1: {
                n2 += n4 / 2;
            }
        }
        double d = this.layer_.getXDtoP(n);
        double d2 = this.layer_.getYDtoP(n2);
        if (this.porigin_.x != d || this.porigin_.y != d2) {
            Point2D.Double double_ = this.porigin_;
            this.porigin_.x = d;
            this.porigin_.y = d2;
            this.changes_.firePropertyChange("location", double_, new Point2D.Double(d, d2));
            this.modified("VectorKey: setBounds()");
        }
    }

    Object getObjectAt(Point point) {
        int n;
        int n2 = this.vectors_.size();
        if (n2 <= 0) {
            return null;
        }
        int n3 = n2 / this.columns_;
        if (n2 % this.columns_ != 0) {
            ++n3;
        }
        int[] nArray = new int[this.columns_];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[2];
        Rectangle rectangle = this.getBounds();
        int n4 = this.layer_.getXPtoD(this.vectorLengthP_) - this.layer_.getXPtoD(0.0);
        double d = this.layer_.getXDtoP(10) - this.layer_.getXDtoP(0);
        double d2 = this.layer_.getXDtoP(7) - this.layer_.getXDtoP(0);
        nArray2[0] = rectangle.y + 3 + this.maxLabelHeight_;
        for (n = 1; n < n3; ++n) {
            nArray2[n] = nArray2[n - 1] + 3 + this.maxLabelHeight_;
        }
        nArray[0] = rectangle.x + 15;
        for (n = 1; n < this.columns_; ++n) {
            nArray[n] = nArray[n - 1] + 10 + n4 + 7 + this.maxScaleLength_ + 10 + this.maxLabelLength_;
        }
        int n5 = 0;
        int n6 = 0;
        Enumeration enumeration = this.vectors_.elements();
        while (enumeration.hasMoreElements()) {
            VectorCartesianRenderer vectorCartesianRenderer = (VectorCartesianRenderer)enumeration.nextElement();
            nArray3[0] = nArray[n6];
            nArray3[1] = nArray3[0] + n4 + 7;
            nArray4[0] = nArray2[n5] - this.maxLabelHeight_;
            nArray4[1] = nArray2[n5];
            Rectangle rectangle2 = new Rectangle(nArray3[0], nArray4[0], nArray3[1] - nArray3[0], nArray4[1] - nArray4[0]);
            if (rectangle2.contains(point)) {
                return vectorCartesianRenderer;
            }
            if (++n6 < this.columns_) continue;
            n6 = 0;
            ++n5;
        }
        if (rectangle.contains(point)) {
            return this;
        }
        return null;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean bl) {
        if (this.visible_ != bl) {
            this.visible_ = bl;
            this.modified("VectorKey: setVisible()");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("VectorKey: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }
}

