/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.Moveable;
import gov.noaa.pmel.util.Point2D;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;

public class Logo
implements Cloneable,
LayerChild,
Moveable {
    private String ident_;
    private Layer layer_ = null;
    private Point2D.Double porigin_;
    private int valign_;
    private int halign_;
    private Image image_ = null;
    private URL imageURL_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private boolean moveable_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public Logo() {
        this(new Point2D.Double(0.0, 0.0), 2, 0);
    }

    public Logo(Point2D.Double double_, int n, int n2) {
        this.porigin_ = double_;
        this.valign_ = n;
        this.halign_ = n2;
        this.ident_ = "";
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.moveable_ = true;
    }

    public LayerChild copy() {
        Logo logo;
        try {
            logo = (Logo)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logo = new Logo();
        }
        return logo;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelectable(boolean bl) {
        this.selectable_ = bl;
    }

    public boolean isSelectable() {
        return this.selectable_;
    }

    public boolean isMoveable() {
        return this.moveable_;
    }

    public void setMoveable(boolean bl) {
        this.moveable_ = bl;
    }

    public void setImageURL(URL uRL) {
        if (this.imageURL_ == null || !this.imageURL_.equals(uRL)) {
            this.imageURL_ = uRL;
            this.modified("Logo: setImageURL()");
        }
    }

    public URL getImageURL() {
        return this.imageURL_;
    }

    public void setImage(Image image) {
        if (this.image_ == null || !this.image_.equals(image)) {
            this.image_ = image;
            this.modified("Logo: setImage()");
        }
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    public void modified(String string) {
        if (this.layer_ != null) {
            this.layer_.modified(string);
        }
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setAlign(int n, int n2) {
        if (this.valign_ != n || this.halign_ != n2) {
            this.valign_ = n;
            this.halign_ = n2;
            this.modified("Logo: setAlign()");
        }
    }

    public void setVAlign(int n) {
        if (this.valign_ != n) {
            this.valign_ = n;
            this.modified("Logo: setVAlign()");
        }
    }

    public void setHAlign(int n) {
        if (this.halign_ != n) {
            this.halign_ = n;
            this.modified("Logo: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public void setLocationP(Point2D.Double double_) {
        if (this.porigin_ == null || !this.porigin_.equals(double_)) {
            Point2D.Double double_2 = this.porigin_;
            this.porigin_ = double_;
            this.changes_.firePropertyChange("location", double_2, this.porigin_);
            this.modified("Logo: setLocationP()");
        }
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public void draw(Graphics graphics) {
        if (!this.visible_) {
            return;
        }
        if (this.imageURL_ != null && this.layer_ != null && this.image_ == null) {
            this.image_ = this.layer_.getPane().getComponent().getToolkit().getImage(this.imageURL_);
            if (this.image_ != null) {
                MediaTracker mediaTracker = new MediaTracker(this.layer_.getPane().getComponent());
                try {
                    mediaTracker.addImage(this.image_, 0);
                    mediaTracker.waitForAll();
                    if (mediaTracker.isErrorAny()) {
                        System.err.println("Logo: Error loading image");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("MediaTracker: " + mediaTracker.checkAll());
            }
        }
        this.layer_.getPane().getComponent().invalidate();
        if (this.image_ != null) {
            Rectangle rectangle = this.getBounds();
            graphics.drawImage(this.image_, rectangle.x, rectangle.y, this.layer_.getPane().getComponent());
        }
    }

    public Rectangle getBounds() {
        if (this.image_ != null) {
            int n = this.image_.getWidth(this.layer_.getPane().getComponent());
            int n2 = this.image_.getHeight(this.layer_.getPane().getComponent());
            int n3 = this.layer_.getXPtoD(this.porigin_.x);
            int n4 = this.layer_.getYPtoD(this.porigin_.y);
            switch (this.halign_) {
                case 2: {
                    n3 -= n;
                    break;
                }
                case 1: {
                    n3 -= n / 2;
                }
            }
            switch (this.valign_) {
                case 2: {
                    n4 -= n2;
                    break;
                }
                case 1: {
                    n4 -= n2 / 2;
                }
            }
            return new Rectangle(n3, n4, n, n2);
        }
        return null;
    }

    public Point getLocation() {
        Rectangle rectangle = this.getBounds();
        return new Point(rectangle.x, rectangle.y);
    }

    public void setLocation(Point point) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(point.x, point.y, rectangle.width, rectangle.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        switch (this.halign_) {
            case 2: {
                n += n3;
                break;
            }
            case 1: {
                n += n3 / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                n2 += n4;
                break;
            }
            case 1: {
                n2 += n4 / 2;
            }
        }
        double d = this.layer_.getXDtoP(n);
        double d2 = this.layer_.getYDtoP(n2);
        if (this.porigin_.x != d || this.porigin_.y != d2) {
            Point2D.Double double_ = this.porigin_;
            this.porigin_.x = d;
            this.porigin_.y = d2;
            this.changes_.firePropertyChange("location", double_, new Point2D.Double(d, d2));
            this.modified("Logo: setBounds()");
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean bl) {
        if (this.visible_ != bl) {
            this.visible_ = bl;
            this.modified("Logo: setVisible()");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }
}

