/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Transform;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimeRange;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AxisTransform
implements Transform {
    protected PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final long serialVersionUID = -1577305732337537031L;
    protected double p1_;
    protected double p2_;
    protected double u1_;
    protected double u2_;
    protected long t1_;
    protected long t2_;
    protected boolean space_;
    protected String ident_;

    public AxisTransform() {
        this(0.0, 1.0, 0.0, 1.0);
    }

    public AxisTransform(double d, double d2, double d3, double d4) {
        this.p1_ = d;
        this.p2_ = d2;
        this.u1_ = d3;
        this.u2_ = d4;
        this.space_ = true;
        this.computeTransform();
        this.ident_ = "space transform";
    }

    public AxisTransform(Range2D range2D, Range2D range2D2) {
        this(range2D.start, range2D.end, range2D2.start, range2D2.end);
    }

    public AxisTransform(double d, double d2, GeoDate geoDate, GeoDate geoDate2) {
        this.p1_ = d;
        this.p2_ = d2;
        this.t1_ = geoDate.getTime();
        this.t2_ = geoDate2.getTime();
        this.space_ = false;
        this.computeTransform();
        this.ident_ = "time transform";
    }

    public AxisTransform(double d, double d2, long l, long l2) {
        this.p1_ = d;
        this.p2_ = d2;
        this.t1_ = l;
        this.t2_ = l2;
        this.space_ = false;
        this.computeTransform();
        this.ident_ = "time transform";
    }

    public AxisTransform(Range2D range2D, TimeRange timeRange) {
        this(range2D.start, range2D.end, timeRange.start, timeRange.end);
    }

    public AxisTransform(Range2D range2D, SoTRange soTRange) {
        if (soTRange.isTime()) {
            this.t1_ = soTRange.getStart().getLongTime();
            this.t2_ = soTRange.getEnd().getLongTime();
            this.space_ = false;
        } else {
            this.u1_ = ((SoTRange.Double)soTRange).start;
            this.u2_ = ((SoTRange.Double)soTRange).end;
            this.space_ = true;
        }
        this.setRangeP(range2D);
        this.computeTransform();
    }

    public void setRangeP(double d, double d2) {
        if (this.p1_ != d || this.p2_ != d2) {
            Range2D range2D = new Range2D(this.p1_, this.p2_);
            this.p1_ = d;
            this.p2_ = d2;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeP", range2D, new Range2D(this.p1_, this.p2_));
        }
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setRangeP(Range2D range2D) {
        this.setRangeP(range2D.start, range2D.end);
    }

    public Range2D getRangeP() {
        return new Range2D(this.p1_, this.p2_);
    }

    public void setRangeU(double d, double d2) {
        if (this.u1_ != d || this.u2_ != d2) {
            Range2D range2D = new Range2D(this.u1_, this.u2_);
            this.u1_ = d;
            this.u2_ = d2;
            this.space_ = true;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeU", range2D, new Range2D(this.u1_, this.u2_));
        }
    }

    public void setRangeU(Range2D range2D) {
        this.setRangeU(range2D.start, range2D.end);
    }

    public Range2D getRangeU() {
        return new Range2D(this.u1_, this.u2_);
    }

    public void setRangeU(GeoDate geoDate, GeoDate geoDate2) {
        this.setRangeU(geoDate.getTime(), geoDate2.getTime());
    }

    public void setRangeU(long l, long l2) {
        if (this.t1_ != l || this.t2_ != l2) {
            SoTRange.Time time = new SoTRange.Time(this.t1_, this.t2_);
            this.t1_ = l;
            this.t2_ = l2;
            this.space_ = false;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeU", time, new SoTRange.Time(this.t1_, this.t2_));
        }
    }

    public void setRangeU(TimeRange timeRange) {
        this.setRangeU(timeRange.start, timeRange.end);
    }

    public TimeRange getTimeRangeU() {
        return new TimeRange(new GeoDate(this.t1_), new GeoDate(this.t2_));
    }

    public void setRangeU(SoTRange soTRange) {
        if (soTRange.isTime()) {
            this.setRangeU(soTRange.getStart().getLongTime(), soTRange.getEnd().getLongTime());
        } else {
            this.setRangeU(((SoTRange.Double)soTRange).start, ((SoTRange.Double)soTRange).end);
        }
    }

    public SoTRange getSoTRangeU() {
        if (this.space_) {
            return new SoTRange.Double(this.u1_, this.u2_);
        }
        return new SoTRange.Time(this.t1_, this.t2_);
    }

    public boolean isSpace() {
        return this.space_;
    }

    public boolean isTime() {
        return !this.space_;
    }

    abstract double getTransP(GeoDate var1);

    abstract double getTransP(long var1);

    abstract GeoDate getTimeTransU(double var1);

    abstract long getLongTimeTransU(double var1);

    abstract void computeTransform();

    abstract AxisTransform copy();

    public abstract double getTransP(SoTValue var1);

    public abstract SoTValue getSoTTransU(double var1);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }
}

