/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.GeoDate;
import java.io.Serializable;
import java.util.Date;

public class GeoDateArray
implements Serializable {
    private long[] date_;

    public GeoDateArray(GeoDate[] geoDateArray) {
        this.date_ = new long[geoDateArray.length];
        for (int i = 0; i < geoDateArray.length; ++i) {
            this.date_[i] = geoDateArray[i] != null && !geoDateArray[i].isMissing() ? geoDateArray[i].getTime() : Long.MAX_VALUE;
        }
    }

    public GeoDateArray(Date[] dateArray) {
        this.date_ = new long[dateArray.length];
        for (int i = 0; i < dateArray.length; ++i) {
            this.date_[i] = dateArray[i] != null ? dateArray[i].getTime() : Long.MAX_VALUE;
        }
    }

    public GeoDateArray(long[] lArray) {
        this.date_ = lArray;
    }

    public long[] getTime() {
        return this.date_;
    }

    public long getTime(int n) {
        if (n < 0 || n >= this.date_.length) {
            return Long.MAX_VALUE;
        }
        return this.date_[n];
    }

    public GeoDate getGeoDate(int n) {
        if (n < 0 || n >= this.date_.length) {
            return null;
        }
        return new GeoDate(this.date_[n]);
    }

    public GeoDate[] getGeoDate() {
        GeoDate[] geoDateArray = new GeoDate[this.date_.length];
        for (int i = 0; i < this.date_.length; ++i) {
            geoDateArray[i] = new GeoDate(this.date_[i]);
        }
        return geoDateArray;
    }

    public double getOffset(int n, GeoDate geoDate) {
        if (n < 0 || n >= this.date_.length) {
            return Double.NaN;
        }
        return (double)(this.date_[n] - geoDate.getTime()) / 8.64E7;
    }

    public double[] getOffset(GeoDate geoDate) {
        long l = geoDate.getTime();
        double[] dArray = new double[this.date_.length];
        for (int i = 0; i < this.date_.length; ++i) {
            dArray[i] = (double)(this.date_[i] - l) / 8.64E7;
        }
        return dArray;
    }

    public long getOffsetTime(int n, GeoDate geoDate) {
        if (n < 0 || n >= this.date_.length) {
            return Long.MAX_VALUE;
        }
        return this.date_[n] - geoDate.getTime();
    }

    public long[] getOffsetTime(GeoDate geoDate) {
        long l = geoDate.getTime();
        long[] lArray = new long[this.date_.length];
        for (int i = 0; i < this.date_.length; ++i) {
            lArray[i] = this.date_[i] - l;
        }
        return lArray;
    }

    public void addOffset(long l) {
        int n = 0;
        while (n < this.date_.length) {
            int n2 = n++;
            this.date_[n2] = this.date_[n2] + l;
        }
    }

    public void addOffset(int n, long l) {
        if (n < 0 || n >= this.date_.length) {
            return;
        }
        int n2 = n;
        this.date_[n2] = this.date_[n2] + l;
    }

    public int getLength() {
        return this.date_.length;
    }
}

