/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.util.SoTRange;
import java.util.Enumeration;

public class PointCollection
extends Collection {
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private int colLen_ = 0;
    private SGTMetaData xMetaData_;
    private SGTMetaData yMetaData_;

    public PointCollection() {
        this("");
    }

    public PointCollection(String string) {
        super(string);
    }

    public PointCollection(String string, int n) {
        super(string, n);
    }

    public PointCollection(String string, int n, int n2) {
        super(string, n, n2);
    }

    public SGTData copy() {
        PointCollection pointCollection = (PointCollection)this.clone();
        return pointCollection;
    }

    public SoTRange getXRange() {
        this.computeRange();
        return this.xRange_.copy();
    }

    public SoTRange getYRange() {
        this.computeRange();
        return this.yRange_.copy();
    }

    private void computeRange() {
        if (this.colLen_ == this.size()) {
            return;
        }
        this.colLen_ = this.size();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = d;
        double d4 = d2;
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SGTPoint)) continue;
            SGTPoint sGTPoint = (SGTPoint)e;
            double d5 = sGTPoint.getX();
            double d6 = sGTPoint.getY();
            if (Double.isNaN(d5) || Double.isNaN(d6)) continue;
            d = Math.min(d, d5);
            d2 = Math.max(d2, d5);
            d3 = Math.min(d3, d6);
            d4 = Math.max(d4, d6);
            ++n;
        }
        if (n == 0) {
            this.xRange_ = new SoTRange.Double(Double.NaN, Double.NaN);
            this.yRange_ = new SoTRange.Double(Double.NaN, Double.NaN);
        } else {
            this.xRange_ = new SoTRange.Double(d, d2);
            this.yRange_ = new SoTRange.Double(d3, d4);
        }
    }

    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public void setXMetaData(SGTMetaData sGTMetaData) {
        this.xMetaData_ = sGTMetaData;
    }

    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public void setYMetaData(SGTMetaData sGTMetaData) {
        this.yMetaData_ = sGTMetaData;
    }
}

