/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import java.awt.Color;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class Annote
implements SGTData,
Serializable,
PropertyChangeListener {
    protected transient PropertyChangeSupport changes_;
    private static final long serialVersionUID = 7305616377566581275L;
    protected String id_ = null;

    protected Annote() {
    }

    protected Rectangle computeBounds(Graph graph, SoTDomain soTDomain) {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle = null;
        if (soTDomain == null || !(graph instanceof CartesianGraph)) {
            return rectangle;
        }
        CartesianGraph cartesianGraph = (CartesianGraph)graph;
        int n5 = cartesianGraph.getXUtoD(soTDomain.getXRange().getStart());
        int n6 = cartesianGraph.getYUtoD(soTDomain.getYRange().getStart());
        int n7 = cartesianGraph.getXUtoD(soTDomain.getXRange().getEnd());
        int n8 = cartesianGraph.getYUtoD(soTDomain.getYRange().getEnd());
        if (n5 < n7) {
            n4 = n5;
            n3 = n7 - n5;
        } else {
            n4 = n7;
            n3 = n5 - n7;
        }
        if (n6 < n8) {
            n2 = n6;
            n = n8 - n6;
        } else {
            n2 = n8;
            n = n6 - n8;
        }
        rectangle = new Rectangle(n4, n2, n3, n);
        return rectangle;
    }

    public abstract Rectangle getBounds(Graph var1);

    public abstract SoTDomain getDomain();

    public abstract void moveBy(SoTPoint var1);

    public abstract void propertyChange(PropertyChangeEvent var1);

    public String getAnnoteId() {
        return this.id_;
    }

    public abstract void init();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public static class Rect
    extends Annote {
        SoTPoint upperLeft;
        SoTPoint lowerRight;
        LineAttribute attr;
        Color color;
        SoTRange xRange_ = null;
        SoTRange yRange_ = null;

        public Rect(String string, SoTPoint soTPoint, SoTPoint soTPoint2, LineAttribute lineAttribute, Color color) {
            this.id_ = string;
            this.upperLeft = soTPoint;
            this.lowerRight = soTPoint2;
            this.attr = lineAttribute;
            this.color = color;
            this.init();
            this.computeRange();
        }

        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(this);
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SoTPoint getUpperLeft() {
            return this.upperLeft;
        }

        public void setUpperLeft(SoTPoint soTPoint) {
            this.upperLeft = soTPoint;
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        public SoTPoint getLowerRight() {
            return this.lowerRight;
        }

        public void setLowerRight(SoTPoint soTPoint) {
            this.lowerRight = soTPoint;
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        public void setLocation(SoTPoint soTPoint, SoTPoint soTPoint2) {
            this.upperLeft = soTPoint;
            this.lowerRight = soTPoint2;
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        public LineAttribute getLineAttribute() {
            return this.attr;
        }

        public Color getFillColor() {
            return this.color;
        }

        public void setFillColor(Color color) {
            this.color = color;
            this.changes_.firePropertyChange("colorChanged", true, false);
        }

        public SoTDomain getDomain() {
            return new SoTDomain(this.xRange_, this.yRange_);
        }

        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain());
        }

        public void moveBy(SoTPoint soTPoint) {
            this.upperLeft.add(soTPoint);
            this.lowerRight.add(soTPoint);
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        private void computeRange() {
            double d;
            double d2;
            if (this.upperLeft.getX().isTime()) {
                this.xRange_ = new SoTRange.Time(this.upperLeft.getX().getLongTime(), this.lowerRight.getX().getLongTime());
            } else {
                d2 = ((Number)this.upperLeft.getX().getObjectValue()).doubleValue();
                d = ((Number)this.lowerRight.getX().getObjectValue()).doubleValue();
                this.xRange_ = new SoTRange.Double(d2, d);
            }
            if (this.upperLeft.getY().isTime()) {
                this.yRange_ = new SoTRange.Time(this.lowerRight.getY().getLongTime(), this.upperLeft.getY().getLongTime());
            } else {
                d2 = ((Number)this.lowerRight.getY().getObjectValue()).doubleValue();
                d = ((Number)this.upperLeft.getY().getObjectValue()).doubleValue();
                this.yRange_ = new SoTRange.Double(d2, d);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.changes_.firePropertyChange(propertyChangeEvent);
        }

        public SGTData copy() {
            SGTData sGTData = null;
            try {
                sGTData = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return sGTData;
        }

        public String getId() {
            return null;
        }

        public SGLabel getKeyTitle() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public SGTMetaData getXMetaData() {
            return null;
        }

        public SoTRange getXRange() {
            return this.xRange_;
        }

        public SGTMetaData getYMetaData() {
            return null;
        }

        public SoTRange getYRange() {
            return this.yRange_;
        }

        public boolean isXTime() {
            return this.upperLeft.isXTime();
        }

        public boolean isYTime() {
            return this.upperLeft.isYTime();
        }
    }

    public static class Oval
    extends Annote {
        SoTPoint upperLeft;
        SoTPoint lowerRight;
        LineAttribute attr;
        Color color;
        SoTRange xRange_ = null;
        SoTRange yRange_ = null;

        public Oval(String string, SoTPoint soTPoint, SoTPoint soTPoint2, LineAttribute lineAttribute, Color color) {
            this.id_ = string;
            this.upperLeft = soTPoint;
            this.lowerRight = soTPoint2;
            this.attr = lineAttribute;
            this.color = color;
            this.init();
            this.computeRange();
        }

        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(this);
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SoTPoint getUpperLeft() {
            return this.upperLeft;
        }

        public void setUpperLeft(SoTPoint soTPoint) {
            this.upperLeft = soTPoint;
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        public SoTPoint getLowerRight() {
            return this.lowerRight;
        }

        public void setLowerRight(SoTPoint soTPoint) {
            this.lowerRight = soTPoint;
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        public void setLocation(SoTPoint soTPoint, SoTPoint soTPoint2) {
            this.upperLeft = soTPoint;
            this.lowerRight = soTPoint2;
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        public LineAttribute getLineAttribute() {
            return this.attr;
        }

        public Color getFillColor() {
            return this.color;
        }

        public void setFillColor(Color color) {
            this.color = color;
            this.changes_.firePropertyChange("colorChanged", true, false);
        }

        public SoTDomain getDomain() {
            return new SoTDomain(this.xRange_, this.yRange_);
        }

        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain());
        }

        public void moveBy(SoTPoint soTPoint) {
            this.upperLeft.add(soTPoint);
            this.lowerRight.add(soTPoint);
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        private void computeRange() {
            double d;
            double d2;
            if (this.upperLeft.getX().isTime()) {
                this.xRange_ = new SoTRange.Time(this.upperLeft.getX().getLongTime(), this.lowerRight.getX().getLongTime());
            } else {
                d2 = ((Number)this.upperLeft.getX().getObjectValue()).doubleValue();
                d = ((Number)this.lowerRight.getX().getObjectValue()).doubleValue();
                this.xRange_ = new SoTRange.Double(d2, d);
            }
            if (this.upperLeft.getY().isTime()) {
                this.yRange_ = new SoTRange.Time(this.lowerRight.getY().getLongTime(), this.upperLeft.getY().getLongTime());
            } else {
                d2 = ((Number)this.lowerRight.getY().getObjectValue()).doubleValue();
                d = ((Number)this.upperLeft.getY().getObjectValue()).doubleValue();
                this.yRange_ = new SoTRange.Double(d2, d);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.changes_.firePropertyChange(propertyChangeEvent);
        }

        public SGTData copy() {
            SGTData sGTData = null;
            try {
                sGTData = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return sGTData;
        }

        public String getId() {
            return null;
        }

        public SGLabel getKeyTitle() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public SGTMetaData getXMetaData() {
            return null;
        }

        public SoTRange getXRange() {
            return this.xRange_;
        }

        public SGTMetaData getYMetaData() {
            return null;
        }

        public SoTRange getYRange() {
            return this.yRange_;
        }

        public boolean isXTime() {
            return this.upperLeft.isXTime();
        }

        public boolean isYTime() {
            return this.upperLeft.isYTime();
        }
    }

    public static class Text
    extends Annote {
        SoTPoint location;
        SGLabel text;

        public Text(String string, SoTPoint soTPoint, SGLabel sGLabel) {
            this.id_ = string;
            this.location = soTPoint;
            this.text = sGLabel;
            this.init();
        }

        public void init() {
            if (this.text != null) {
                this.text.addPropertyChangeListener(this);
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SoTPoint getLocation() {
            return this.location;
        }

        public SGLabel getText() {
            return this.text;
        }

        public SoTDomain getDomain() {
            return null;
        }

        private SoTDomain getDomain(Graph graph) {
            long l;
            long l2;
            CartesianGraph cartesianGraph = (CartesianGraph)graph;
            SoTRange soTRange = null;
            SoTRange soTRange2 = null;
            Rectangle2D.Double double_ = this.text.getBoundsP();
            double d = cartesianGraph.getXUtoP(this.location.getX());
            double d2 = cartesianGraph.getYUtoP(this.location.getY());
            double d3 = double_.width;
            double d4 = double_.height;
            if (this.location.isXTime()) {
                l2 = cartesianGraph.getXPtoLongTime(d);
                l = cartesianGraph.getXPtoLongTime(d + d3);
                soTRange = new SoTRange.Time(l2, l);
            } else {
                double d5 = cartesianGraph.getXPtoU(d);
                double d6 = cartesianGraph.getXPtoU(d + d3);
                soTRange = new SoTRange.Double(d5, d6);
            }
            if (this.location.isYTime()) {
                l2 = cartesianGraph.getYPtoLongTime(d2);
                l = cartesianGraph.getYPtoLongTime(d2 + d4);
                soTRange2 = new SoTRange.Time(l2, l);
            } else {
                double d7 = cartesianGraph.getYPtoU(d2);
                double d8 = cartesianGraph.getYPtoU(d2 + d4);
                soTRange2 = new SoTRange.Double(d7, d8);
            }
            return new SoTDomain(soTRange, soTRange2);
        }

        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain(graph));
        }

        public void moveBy(SoTPoint soTPoint) {
            this.location.add(soTPoint);
            this.changes_.firePropertyChange("textMoved", true, false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.changes_.firePropertyChange(propertyChangeEvent);
        }

        public SGTData copy() {
            SGTData sGTData = null;
            try {
                sGTData = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return sGTData;
        }

        public String getId() {
            return this.text.getId();
        }

        public SGLabel getKeyTitle() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public SGTMetaData getXMetaData() {
            return null;
        }

        public SoTRange getXRange() {
            return null;
        }

        public SGTMetaData getYMetaData() {
            return null;
        }

        public SoTRange getYRange() {
            return null;
        }

        public boolean isXTime() {
            return this.location.isXTime();
        }

        public boolean isYTime() {
            return this.location.isYTime();
        }
    }

    public static class Point
    extends Annote {
        SGTPoint point;
        PointAttribute attr;

        public Point(String string, SGTPoint sGTPoint, PointAttribute pointAttribute) {
            this.id_ = string;
            this.point = sGTPoint;
            this.attr = pointAttribute;
            this.init();
        }

        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(this);
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SGTPoint getPoint() {
            return this.point;
        }

        public PointAttribute getAttribute() {
            return this.attr;
        }

        public SoTDomain getDomain() {
            return new SoTDomain(this.point.getXRange(), this.point.getYRange());
        }

        public Rectangle getBounds(Graph graph) {
            Rectangle rectangle = this.computeBounds(graph, this.getDomain());
            double d = this.attr.getMarkHeightP();
            int n = graph.getLayer().getXPtoD(d);
            rectangle.setBounds(rectangle.x - n / 2, rectangle.y - n / 2, n, n);
            return rectangle;
        }

        public void moveBy(SoTPoint soTPoint) {
            double d;
            long l;
            double d2 = 0.0;
            double d3 = 0.0;
            long l2 = 0L;
            if (!(this.point instanceof SimplePoint)) {
                return;
            }
            if (this.point.isXTime()) {
                l2 = this.point.getLongTime();
                l = soTPoint.getX().getLongTime();
                ((SimplePoint)this.point).setTime(l2 += l);
            } else {
                d2 = this.point.getX();
                d = ((Number)soTPoint.getX().getObjectValue()).doubleValue();
                ((SimplePoint)this.point).setX(d2 += d);
            }
            if (this.point.isYTime()) {
                l2 = this.point.getLongTime();
                l = soTPoint.getY().getLongTime();
                ((SimplePoint)this.point).setTime(l2 += l);
            } else {
                d3 = this.point.getY();
                d = ((Number)soTPoint.getY().getObjectValue()).doubleValue();
                ((SimplePoint)this.point).setY(d3 += d);
            }
            this.changes_.firePropertyChange("pointMoved", true, false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.changes_.firePropertyChange(propertyChangeEvent);
        }

        public SGTData copy() {
            SGTData sGTData = null;
            try {
                sGTData = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return sGTData;
        }

        public String getId() {
            return this.point.getId();
        }

        public SGLabel getKeyTitle() {
            return this.point.getKeyTitle();
        }

        public String getTitle() {
            return this.point.getTitle();
        }

        public SGTMetaData getXMetaData() {
            return this.point.getXMetaData();
        }

        public SoTRange getXRange() {
            return this.point.getXRange();
        }

        public SGTMetaData getYMetaData() {
            return this.point.getYMetaData();
        }

        public SoTRange getYRange() {
            return this.point.getYRange();
        }

        public boolean isXTime() {
            return this.point.isXTime();
        }

        public boolean isYTime() {
            return this.point.isYTime();
        }
    }

    public static class Line
    extends Annote {
        SGTLine line;
        LineAttribute attr;

        public Line(String string, SGTLine sGTLine, LineAttribute lineAttribute) {
            this.id_ = string;
            this.line = sGTLine;
            this.attr = lineAttribute;
            this.init();
        }

        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(this);
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SGTLine getLine() {
            return this.line;
        }

        public LineAttribute getAttribute() {
            return this.attr;
        }

        public SoTDomain getDomain() {
            return new SoTDomain(this.line.getXRange(), this.line.getYRange());
        }

        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain());
        }

        public void moveBy(SoTPoint soTPoint) {
            double d;
            int n;
            long l;
            double[] dArray = null;
            double[] dArray2 = null;
            long[] lArray = null;
            if (!(this.line instanceof SimpleLine)) {
                return;
            }
            if (this.line.isXTime()) {
                lArray = this.line.getGeoDateArray().getTime();
                l = soTPoint.getX().getLongTime();
                n = 0;
                while (n < lArray.length) {
                    int n2 = n++;
                    lArray[n2] = lArray[n2] + l;
                }
                ((SimpleLine)this.line).setTimeArray(new GeoDateArray(lArray));
            } else {
                dArray = this.line.getXArray();
                d = ((Number)soTPoint.getX().getObjectValue()).doubleValue();
                n = 0;
                while (n < dArray.length) {
                    int n3 = n++;
                    dArray[n3] = dArray[n3] + d;
                }
                ((SimpleLine)this.line).setXArray(dArray);
            }
            if (this.line.isYTime()) {
                lArray = this.line.getGeoDateArray().getTime();
                l = soTPoint.getY().getLongTime();
                n = 0;
                while (n < lArray.length) {
                    int n4 = n++;
                    lArray[n4] = lArray[n4] + l;
                }
                ((SimpleLine)this.line).setTimeArray(new GeoDateArray(lArray));
            } else {
                dArray2 = this.line.getYArray();
                d = ((Number)soTPoint.getY().getObjectValue()).doubleValue();
                n = 0;
                while (n < dArray2.length) {
                    int n5 = n++;
                    dArray2[n5] = dArray2[n5] + d;
                }
                ((SimpleLine)this.line).setYArray(dArray2);
            }
            this.changes_.firePropertyChange("lineMoved", true, false);
        }

        public void setXArray(double[] dArray) {
        }

        public void setYArray(double[] dArray) {
        }

        public void setTimeArray(GeoDateArray geoDateArray) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.changes_.firePropertyChange(propertyChangeEvent);
        }

        public SGTData copy() {
            SGTData sGTData = null;
            try {
                sGTData = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return sGTData;
        }

        public String getId() {
            return this.line.getId();
        }

        public SGLabel getKeyTitle() {
            return this.line.getKeyTitle();
        }

        public String getTitle() {
            return this.line.getTitle();
        }

        public SGTMetaData getXMetaData() {
            return this.line.getXMetaData();
        }

        public SoTRange getXRange() {
            return this.line.getXRange();
        }

        public SGTMetaData getYMetaData() {
            return this.line.getYMetaData();
        }

        public SoTRange getYRange() {
            return this.line.getYRange();
        }

        public boolean isXTime() {
            return this.line.isXTime();
        }

        public boolean isYTime() {
            return this.line.isYTime();
        }
    }
}

