/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.PointCollectionKey;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.ValueIcon;
import gov.noaa.pmel.sgt.swing.ValueIconFormat;
import gov.noaa.pmel.sgt.swing.prop.PointAttributeDialog;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TAOMap
extends JApplet
implements PropertyChangeListener {
    JButton tree_;
    JButton space_ = null;
    JButton reset_;
    JPane mainPane_;
    SGTLine coastLine_ = null;
    CartesianGraph graph_;
    LinearTransform xt_;
    LinearTransform yt_;
    Layer layer_;
    PlainAxis xbot_;
    PlainAxis yleft_;
    Range2D xrange_;
    Range2D yrange_;
    PointAttributeDialog pAttrDialog_ = null;

    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(553, 438);
        JPane jPane = this.makeGraph();
        jPane.setBatch(true);
        this.getContentPane().add((Component)jPane, "Center");
        this.getContentPane().add((Component)this.makeButtonPanel(false), "South");
        this.addValueIcon();
        jPane.setBatch(false);
    }

    JPanel makeButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.tree_ = new JButton("Tree View");
        MyAction myAction = new MyAction();
        this.tree_.addActionListener(myAction);
        jPanel.add(this.tree_);
        if (bl) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            jPanel.add(this.space_);
        }
        this.reset_ = new JButton("Reset Zoom");
        this.reset_.addActionListener(myAction);
        jPanel.add(this.reset_);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        TAOMap tAOMap = new TAOMap();
        JFrame jFrame = new JFrame("TAO Mooring Map");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.setSize(553, 438);
        JPane jPane = tAOMap.makeGraph();
        JPanel jPanel = tAOMap.makeButtonPanel(true);
        jPane.setBatch(true);
        jFrame.getContentPane().add((Component)jPane, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.pack();
        jFrame.setVisible(true);
        tAOMap.addValueIcon();
        jPane.setBatch(false);
    }

    JPane makeGraph() {
        Cloneable cloneable;
        Object object;
        Object object2;
        this.coastLine_ = this.getCoastLine("finerezcoast.bin", 50200);
        this.mainPane_ = new JPane("Point Plot Demo", new Dimension(553, 438));
        this.mainPane_.setLayout(new StackedLayout());
        this.mainPane_.setBackground(Color.white);
        Collection collection = this.readPointCollection("TAO.dat");
        Collection collection2 = this.readPointCollection("TRITON.dat");
        this.xrange_ = new Range2D(130.0, 270.0, 20.0);
        this.yrange_ = new Range2D(-10.0, 14.0, 2.0);
        double d = 4.0;
        double d2 = 0.45;
        double d3 = 3.75;
        double d4 = 3.0;
        double d5 = 0.45;
        double d6 = 2.95;
        this.xt_ = new LinearTransform(d2, d3, this.xrange_.start, this.xrange_.end);
        this.yt_ = new LinearTransform(d5, d6, this.yrange_.start, this.yrange_.end);
        if (this.coastLine_ != null) {
            object2 = new Layer("CoastLine", new Dimension2D(d, d4));
            this.mainPane_.add((Component)object2);
            object = new CartesianGraph("CoastLine Graph");
            ((Layer)object2).setGraph((Graph)object);
            ((CartesianGraph)object).setXTransform(this.xt_);
            ((CartesianGraph)object).setYTransform(this.yt_);
            cloneable = new LineAttribute();
            ((LineAttribute)cloneable).setColor(new Color(165, 42, 42));
            ((CartesianGraph)object).setData(this.coastLine_, (Attribute)((Object)cloneable));
            ((CartesianGraph)object).setClip(this.xrange_.start, this.xrange_.end, this.yrange_.start, this.yrange_.end);
            ((CartesianGraph)object).setClipping(true);
        }
        this.layer_ = new Layer("Layer 1", new Dimension2D(d, d4));
        this.mainPane_.add(this.layer_);
        this.graph_ = new CartesianGraph("Point Graph");
        this.layer_.setGraph(this.graph_);
        this.graph_.setXTransform(this.xt_);
        this.graph_.setYTransform(this.yt_);
        object2 = "Longitude";
        this.xbot_ = new PlainAxis("Botton Axis");
        this.xbot_.setRangeU(this.xrange_);
        this.xbot_.setLocationU(new Point2D.Double(this.xrange_.start, this.yrange_.start));
        object = new Font("Helvetica", 2, 14);
        this.xbot_.setLabelFont((Font)object);
        cloneable = new SGLabel("xaxis title", (String)object2, new Point2D.Double(0.0, 0.0));
        Font font = new Font("Helvetica", 0, 14);
        ((SGLabel)cloneable).setFont(font);
        ((SGLabel)cloneable).setHeightP(0.2);
        this.xbot_.setTitle((SGLabel)cloneable);
        this.graph_.addXAxis(this.xbot_);
        String string = "Latitude";
        this.yleft_ = new PlainAxis("Left Axis");
        this.yleft_.setRangeU(this.yrange_);
        this.yleft_.setLocationU(new Point2D.Double(this.xrange_.start, this.yrange_.start));
        this.yleft_.setLabelFont((Font)object);
        SGLabel sGLabel = new SGLabel("yaxis title", string, new Point2D.Double(0.0, 0.0));
        Font font2 = new Font("Helvetica", 0, 14);
        sGLabel.setFont(font2);
        sGLabel.setHeightP(0.2);
        this.yleft_.setTitle(sGLabel);
        this.graph_.addYAxis(this.yleft_);
        PointCollectionKey pointCollectionKey = new PointCollectionKey();
        pointCollectionKey.setId("Mooring Key");
        pointCollectionKey.setVAlign(0);
        pointCollectionKey.setHAlign(0);
        pointCollectionKey.setBorderStyle(0);
        pointCollectionKey.setLocationP(new Point2D.Double(d2 + 0.1, d6));
        this.layer_.addChild(pointCollectionKey);
        Color color = new Color(200, 0, 255);
        PointAttribute pointAttribute = new PointAttribute(44, color);
        pointAttribute.setLabelPosition(2);
        Font font3 = new Font("Helvetica", 0, 12);
        pointAttribute.setLabelFont(font3);
        pointAttribute.setLabelColor(Color.red.darker());
        pointAttribute.setLabelHeightP(0.08);
        pointAttribute.setDrawLabel(true);
        this.graph_.setData(collection, pointAttribute);
        SGLabel sGLabel2 = new SGLabel("TAO title", "TAO Moorings", new Point2D.Double(0.0, 0.0));
        sGLabel2.setHeightP(0.16);
        pointCollectionKey.addPointGraph((PointCartesianRenderer)this.graph_.getRenderer(), sGLabel2);
        Layer layer = new Layer("Layer 2", new Dimension2D(d, d4));
        this.mainPane_.add(layer);
        CartesianGraph cartesianGraph = new CartesianGraph("Point Graph2");
        layer.setGraph(cartesianGraph);
        cartesianGraph.setXTransform(this.xt_);
        cartesianGraph.setYTransform(this.yt_);
        PointAttribute pointAttribute2 = new PointAttribute(13, color);
        pointAttribute2.setLabelPosition(2);
        pointAttribute2.setLabelFont(font3);
        pointAttribute2.setLabelColor(Color.blue.darker());
        pointAttribute2.setLabelHeightP(0.08);
        pointAttribute2.setDrawLabel(true);
        cartesianGraph.setData(collection2, pointAttribute2);
        SGLabel sGLabel3 = new SGLabel("TRITON title", "TRITON Moorings", new Point2D.Double(0.0, 0.0));
        sGLabel3.setHeightP(0.16);
        pointCollectionKey.addPointGraph((PointCartesianRenderer)cartesianGraph.getRenderer(), sGLabel3);
        this.mainPane_.addPropertyChangeListener(this);
        return this.mainPane_;
    }

    private void addValueIcon() {
        ValueIcon valueIcon = new ValueIcon(this.getClass().getResource("query.gif"), "value");
        this.layer_.addChild(valueIcon);
        valueIcon.setId("local query");
        try {
            valueIcon.setLocationU(new SoTPoint(220.0, -5.0));
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        valueIcon.setVisible(true);
        valueIcon.setSelectable(true);
        valueIcon.setValueFormat(new GeoFormat());
    }

    void tree_actionPerformed(ActionEvent actionEvent) {
        JClassTree jClassTree = new JClassTree();
        jClassTree.setModal(false);
        jClassTree.setJPane(this.mainPane_);
        jClassTree.show();
    }

    Collection readPointCollection(String string) {
        SimplePoint simplePoint = null;
        BufferedReader bufferedReader = null;
        String string2 = null;
        Collection collection = new Collection(string);
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        while (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
            int n2 = Integer.parseInt(string4);
            if (n2 < 0) {
                n2 += 360;
            }
            simplePoint = new SimplePoint(n2 %= 360, n, string5);
            collection.addElement(simplePoint);
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return collection;
    }

    SGTLine getCoastLine(String string, int n) {
        int n2;
        Object object;
        if (string.length() == 0) {
            return null;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            int n6;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1000000);
            object = new DataInputStream(bufferedInputStream);
            while ((n6 = ((DataInputStream)object).readShort()) != -1) {
                n4 = n3;
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n3] = ((DataInputStream)object).readDouble();
                    ++n3;
                }
                n3 = n4;
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray2[n3] = (((DataInputStream)object).readDouble() + 360.0) % 360.0;
                    if (n3 > 0 && Math.abs(dArray2[n3] - dArray2[n3 - 1]) > 50.0) {
                        ++n5;
                    }
                    ++n3;
                }
                dArray[n3] = Double.NaN;
                dArray2[n3] = Double.NaN;
                ++n3;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(n3 + " points read");
        System.out.println(n5 + " cuts added");
        int n7 = n3;
        object = new double[n3 + n5];
        double[] dArray3 = new double[n3 + n5];
        n3 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            if (n2 > 0 && Math.abs(dArray2[n2] - dArray2[n2 - 1]) > 50.0) {
                object[n3] = Double.NaN;
                dArray3[n3] = Double.NaN;
                ++n3;
            }
            object[n3] = dArray[n2];
            dArray3[n3] = dArray2[n2];
            ++n3;
        }
        SimpleLine simpleLine = new SimpleLine(dArray3, (double[])object, "CoastLine");
        SGTMetaData sGTMetaData = new SGTMetaData("Latitude", "degrees_N", false, false);
        SGTMetaData sGTMetaData2 = new SGTMetaData("Longitude", "degrees_E", false, true);
        simpleLine.setXMetaData(sGTMetaData2);
        simpleLine.setYMetaData(sGTMetaData);
        return simpleLine;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("zoomRectangle")) {
            double d;
            Range2D range2D = new Range2D();
            Range2D range2D2 = new Range2D();
            Rectangle rectangle = (Rectangle)propertyChangeEvent.getNewValue();
            if (rectangle.width <= 1 || rectangle.height <= 1) {
                return;
            }
            range2D.start = this.graph_.getXPtoU(this.layer_.getXDtoP(rectangle.x));
            range2D.end = this.graph_.getXPtoU(this.layer_.getXDtoP(rectangle.x + rectangle.width));
            if (range2D.start > range2D.end) {
                d = range2D.start;
                range2D.start = range2D.end;
                range2D.end = d;
            }
            range2D2.start = this.graph_.getYPtoU(this.layer_.getYDtoP(rectangle.y));
            range2D2.end = this.graph_.getYPtoU(this.layer_.getYDtoP(rectangle.y + rectangle.height));
            if (range2D2.start > range2D2.end) {
                d = range2D2.start;
                range2D2.start = range2D2.end;
                range2D2.end = d;
            }
            this.mainPane_.setBatch(true);
            this.xt_.setRangeU(range2D);
            this.yt_.setRangeU(range2D2);
            Point2D.Double double_ = new Point2D.Double(range2D.start, range2D2.start);
            this.xbot_.setRangeU(range2D);
            this.xbot_.setLocationU(double_);
            this.yleft_.setRangeU(range2D2);
            this.yleft_.setLocationU(double_);
            Component[] componentArray = this.mainPane_.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Layer)) continue;
                Layer layer = (Layer)componentArray[i];
                ((CartesianGraph)layer.getGraph()).setClip(range2D.start, range2D.end, range2D2.start, range2D2.end);
            }
            this.mainPane_.setBatch(false);
        } else if (string.equals("objectSelected")) {
            if (propertyChangeEvent.getNewValue() instanceof PointCartesianRenderer) {
                PointAttribute pointAttribute = ((PointCartesianRenderer)propertyChangeEvent.getNewValue()).getPointAttribute();
                if (this.pAttrDialog_ == null) {
                    this.pAttrDialog_ = new PointAttributeDialog();
                }
                this.pAttrDialog_.setPointAttribute(pointAttribute, this.mainPane_);
                this.pAttrDialog_.setVisible(true);
            } else {
                System.out.println("objectSelected = " + propertyChangeEvent.getNewValue());
            }
        }
    }

    void reset_actionPerformed(ActionEvent actionEvent) {
        this.mainPane_.setBatch(true);
        Component[] componentArray = this.mainPane_.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            Layer layer = (Layer)componentArray[i];
            if (layer.getId().equals("CoastLine")) {
                ((CartesianGraph)layer.getGraph()).setClip(this.xrange_.start, this.xrange_.end, this.yrange_.start, this.yrange_.end);
                continue;
            }
            ((CartesianGraph)layer.getGraph()).setClipping(false);
        }
        this.xt_.setRangeU(this.xrange_);
        this.yt_.setRangeU(this.yrange_);
        Point2D.Double double_ = new Point2D.Double(this.xrange_.start, this.yrange_.start);
        this.xbot_.setRangeU(this.xrange_);
        this.xbot_.setLocationU(double_);
        this.yleft_.setRangeU(this.yrange_);
        this.yleft_.setLocationU(double_);
        this.mainPane_.setBatch(false);
    }

    class GeoFormat
    extends ValueIconFormat {
        public GeoFormat() {
            super("#####.##;#####.##W", "#####.##N;#####.##S");
            this.xfrm_.setPositiveSuffix("E");
        }

        public String format(double d, double d2) {
            double d3 = (d + 360.0) % 360.0;
            if (d > 180.0) {
                d -= 360.0;
            }
            return "(" + this.xfrm_.format(d) + ", " + this.yfrm_.format(d2) + ")";
        }
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == TAOMap.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (object == TAOMap.this.tree_) {
                TAOMap.this.tree_actionPerformed(actionEvent);
            }
            if (object == TAOMap.this.reset_) {
                TAOMap.this.reset_actionPerformed(actionEvent);
            }
        }
    }
}

