/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JPointDemo
extends JApplet {
    JButton tree_;
    JButton space_;
    JPane mainPane_;

    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(553, 438);
        this.add((Component)this.makeGraph(), "Center");
    }

    public static void main(String[] stringArray) {
        JPointDemo jPointDemo = new JPointDemo();
        JFrame jFrame = new JFrame("Point Demo");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPointDemo.tree_ = new JButton("Tree View");
        MyAction myAction = jPointDemo.new MyAction();
        jPointDemo.tree_.addActionListener(myAction);
        jPanel.add(jPointDemo.tree_);
        jPointDemo.space_ = new JButton("Add Mark");
        jPointDemo.space_.addActionListener(myAction);
        jPanel.add(jPointDemo.space_);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.setSize(553, 438);
        JPane jPane = jPointDemo.makeGraph();
        jPane.setBatch(true);
        jFrame.getContentPane().add((Component)jPane, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.pack();
        jFrame.setVisible(true);
        jPane.setBatch(false);
    }

    JPane makeGraph() {
        Object object;
        this.mainPane_ = new JPane("Point Plot Demo", new Dimension(553, 438));
        this.mainPane_.setLayout(new StackedLayout());
        this.mainPane_.setBackground(Color.white);
        Range2D range2D = new Range2D(50.0, 150.0, 10.0);
        Range2D range2D2 = new Range2D(-20.0, 20.0, 5.0);
        TestData testData = new TestData(range2D, range2D2, 50);
        Collection collection = testData.getCollection();
        double d = 4.0;
        double d2 = 0.6;
        double d3 = 3.5;
        double d4 = 3.0;
        double d5 = 0.6;
        double d6 = 2.75;
        Layer layer = new Layer("Layer 1", new Dimension2D(d, d4));
        this.mainPane_.add(layer);
        Image image = this.getToolkit().getImage(this.getClass().getResource("ncBrowse48.gif"));
        if (image != null) {
            object = new MediaTracker(this);
            try {
                ((MediaTracker)object).addImage(image, 0);
                ((MediaTracker)object).waitForAll();
                if (((MediaTracker)object).isErrorAny()) {
                    System.err.println("JPointDemo: Error loading image");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = new Logo(new Point2D.Double(0.0, 0.0), 2, 0);
        ((Logo)object).setId("ncBrowse logo");
        ((Logo)object).setImage(image);
        layer.addChild((LayerChild)object);
        CartesianGraph cartesianGraph = new CartesianGraph("Point Graph");
        layer.setGraph(cartesianGraph);
        LinearTransform linearTransform = new LinearTransform(d2, d3, range2D.start, range2D.end);
        LinearTransform linearTransform2 = new LinearTransform(d5, d6, range2D2.start, range2D2.end);
        cartesianGraph.setXTransform(linearTransform);
        cartesianGraph.setYTransform(linearTransform2);
        String string = "X Label";
        PlainAxis plainAxis = new PlainAxis("Botton Axis");
        plainAxis.setRangeU(range2D);
        plainAxis.setLocationU(new Point2D.Double(range2D.start, range2D2.start));
        Font font = new Font("Helvetica", 2, 14);
        plainAxis.setLabelFont(font);
        SGLabel sGLabel = new SGLabel("xaxis title", string, new Point2D.Double(0.0, 0.0));
        Font font2 = new Font("Helvetica", 0, 14);
        sGLabel.setFont(font2);
        sGLabel.setHeightP(0.2);
        plainAxis.setTitle(sGLabel);
        cartesianGraph.addXAxis(plainAxis);
        String string2 = "Y Label";
        PlainAxis plainAxis2 = new PlainAxis("Left Axis");
        plainAxis2.setRangeU(range2D2);
        plainAxis2.setLocationU(new Point2D.Double(range2D.start, range2D2.start));
        plainAxis2.setLabelFont(font);
        SGLabel sGLabel2 = new SGLabel("yaxis title", string2, new Point2D.Double(0.0, 0.0));
        Font font3 = new Font("Helvetica", 0, 14);
        sGLabel2.setFont(font3);
        sGLabel2.setHeightP(0.2);
        plainAxis2.setTitle(sGLabel2);
        cartesianGraph.addYAxis(plainAxis2);
        PointAttribute pointAttribute = new PointAttribute(20, Color.red);
        pointAttribute.setLabelPosition(2);
        Font font4 = new Font("Helvetica", 0, 12);
        pointAttribute.setLabelFont(font4);
        pointAttribute.setLabelColor(Color.blue);
        pointAttribute.setLabelHeightP(0.1);
        pointAttribute.setDrawLabel(true);
        cartesianGraph.setData(collection, pointAttribute);
        return this.mainPane_;
    }

    void tree_actionPerformed(ActionEvent actionEvent) {
        JClassTree jClassTree = new JClassTree();
        jClassTree.setModal(false);
        jClassTree.setJPane(this.mainPane_);
        jClassTree.show();
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JPointDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (object == JPointDemo.this.tree_) {
                JPointDemo.this.tree_actionPerformed(actionEvent);
            }
        }
    }
}

