/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.TimeRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JLayoutDemo
extends JApplet {
    JPane mainPane_;
    JClassTree tree_ = null;
    boolean isApplet_ = true;
    JFrame frame = null;
    JPanel controlPanel = new JPanel();
    JCheckBox stacked = new JCheckBox();
    ButtonGroup gridtype = new ButtonGroup();
    JCheckBox grid = new JCheckBox();
    JButton showTree = new JButton();

    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.setSize(426, 712);
        this.makeControlPanel();
        this.add((Component)this.controlPanel, "South");
        this.makeGraph();
        this.add((Component)this.mainPane_, "Center");
    }

    public static void main(String[] stringArray) {
        JLayoutDemo jLayoutDemo = new JLayoutDemo();
        jLayoutDemo.isApplet_ = false;
        jLayoutDemo.frame = new JFrame("Layout Demo");
        jLayoutDemo.frame.setSize(426, 712);
        jLayoutDemo.frame.getContentPane().setLayout(new BorderLayout());
        jLayoutDemo.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jLayoutDemo.makeControlPanel();
        jLayoutDemo.frame.getContentPane().add((Component)jLayoutDemo.controlPanel, "South");
        jLayoutDemo.makeGraph();
        jLayoutDemo.mainPane_.setBackground(Color.white);
        jLayoutDemo.mainPane_.setBatch(true);
        jLayoutDemo.frame.getContentPane().add((Component)jLayoutDemo.mainPane_, "Center");
        jLayoutDemo.frame.setVisible(true);
        jLayoutDemo.mainPane_.setBatch(false);
    }

    void makeControlPanel() {
        this.controlPanel.setLayout(new GridBagLayout());
        this.controlPanel.setBounds(0, 679, 426, 33);
        this.controlPanel.setBorder(new EtchedBorder());
        this.gridtype.add(this.stacked);
        this.stacked.setSelected(true);
        this.stacked.setText("Overlayed");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.controlPanel.add((Component)this.stacked, gridBagConstraints);
        this.stacked.setBounds(15, 5, 84, 23);
        this.gridtype.add(this.grid);
        this.grid.setText("Grid");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.controlPanel.add((Component)this.grid, gridBagConstraints);
        this.grid.setBounds(109, 5, 53, 23);
        this.showTree.setText("Show Class Tree");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.controlPanel.add((Component)this.showTree, gridBagConstraints);
        this.showTree.setBackground(Color.yellow.brighter());
        this.showTree.setBounds(302, 5, 109, 23);
        SymItem symItem = new SymItem();
        this.stacked.addItemListener(symItem);
        this.grid.addItemListener(symItem);
        SymAction symAction = new SymAction();
        this.showTree.addActionListener(symAction);
    }

    void makeGraph() {
        this.mainPane_ = new JPane("Layout Demo", new Dimension(426, 400));
        this.mainPane_.setLayout(new StackedLayout());
        GeoDate geoDate = null;
        GeoDate geoDate2 = null;
        try {
            geoDate = new GeoDate("1992-11-01", "yyyy-MM-dd");
            geoDate2 = new GeoDate("1993-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        TimeRange timeRange = new TimeRange(geoDate, geoDate2);
        TestData testData = new TestData(4, timeRange, 1.0f, 2, 1.2f, 0.0f, 20.0f);
        SimpleLine simpleLine = (SimpleLine)testData.getSGTData();
        try {
            geoDate = new GeoDate("1992-11-01", "yyyy-MM-dd");
            geoDate2 = new GeoDate("1993-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        timeRange = new TimeRange(geoDate, geoDate2);
        testData = new TestData(4, timeRange, 1.0f, 2, 1.2f, 0.5f, 30.0f);
        SimpleLine simpleLine2 = (SimpleLine)testData.getSGTData();
        SoTRange soTRange = simpleLine.getYRange();
        soTRange.add(simpleLine2.getYRange());
        SoTRange soTRange2 = simpleLine.getXRange();
        SoTRange soTRange3 = Graph.computeRange(soTRange, 6);
        String string = simpleLine.getYMetaData().getName();
        double d = 4.0;
        double d2 = 0.6;
        double d3 = 3.25;
        double d4 = 3.0;
        double d5 = 0.6;
        double d6 = 2.5;
        Layer layer = new Layer("First Layer", new Dimension2D(d, d4));
        GeoDate geoDate3 = new GeoDate();
        SGLabel sGLabel = new SGLabel("Date Stamp", geoDate3.toString(), new Point2D.Double(0.05, 0.05));
        sGLabel.setAlign(2, 0);
        sGLabel.setColor(Color.magenta);
        sGLabel.setHeightP(0.15);
        sGLabel.setFont(new Font("Dialog", 0, 10));
        layer.addChild(sGLabel);
        SGLabel sGLabel2 = new SGLabel("Title", "Layout Demo", new Point2D.Double(d / 2.0, d4));
        sGLabel2.setAlign(0, 1);
        sGLabel2.setHeightP(0.2);
        sGLabel2.setFont(new Font("Helvetica", 1, 14));
        layer.addChild(sGLabel2);
        LineKey lineKey = new LineKey();
        lineKey.setId("Legend");
        lineKey.setLocationP(new Point2D.Double(d - 0.01, d4));
        lineKey.setVAlign(0);
        lineKey.setHAlign(2);
        layer.addChild(lineKey);
        this.mainPane_.add(layer);
        CartesianGraph cartesianGraph = new CartesianGraph("First Graph");
        LinearTransform linearTransform = new LinearTransform(new Range2D(d2, d3), soTRange2);
        cartesianGraph.setXTransform(linearTransform);
        LinearTransform linearTransform2 = new LinearTransform(new Range2D(d5, d6), soTRange3);
        cartesianGraph.setYTransform(linearTransform2);
        SoTPoint soTPoint = new SoTPoint(soTRange3.getStart(), soTRange2.getStart());
        TimeAxis timeAxis = new TimeAxis("Bottom Axis", 2);
        timeAxis.setRangeU(soTRange2);
        timeAxis.setLocationU(soTPoint);
        Font font = new Font("Helvetica", 2, 14);
        timeAxis.setLabelFont(font);
        timeAxis.setMinorLabelInterval(1);
        cartesianGraph.addXAxis(timeAxis);
        PlainAxis plainAxis = new PlainAxis("Left Axis");
        plainAxis.setRangeU(soTRange3);
        plainAxis.setLocationU(soTPoint);
        plainAxis.setLabelFont(font);
        SGLabel sGLabel3 = new SGLabel("Y-Axis Title", string, new Point2D.Double(0.0, 0.0));
        Font font2 = new Font("Helvetica", 0, 14);
        sGLabel3.setFont(font2);
        sGLabel3.setHeightP(0.2);
        plainAxis.setTitle(sGLabel3);
        cartesianGraph.addYAxis(plainAxis);
        layer.setGraph(cartesianGraph);
        LineAttribute lineAttribute = new LineAttribute(4, 20, Color.red);
        lineAttribute.setMarkHeightP(0.1);
        cartesianGraph.setData(simpleLine, lineAttribute);
        lineKey.addLineGraph((LineCartesianRenderer)cartesianGraph.getRenderer(), new SGLabel("1st line", "Red Data", new Point2D.Double(0.0, 0.0)));
        Layer layer2 = new Layer("Second Layer", new Dimension2D(d, d4));
        this.mainPane_.add(layer2);
        CartesianGraph cartesianGraph2 = new CartesianGraph("Second Graph", linearTransform, linearTransform2);
        layer2.setGraph(cartesianGraph2);
        LineAttribute lineAttribute2 = new LineAttribute(4, 2, Color.blue);
        lineAttribute2.setMarkHeightP(0.1);
        cartesianGraph2.setData(simpleLine2, lineAttribute2);
        lineKey.addLineGraph((LineCartesianRenderer)cartesianGraph2.getRenderer(), new SGLabel("2nd line", "Blue Data", new Point2D.Double(0.0, 0.0)));
    }

    void stacked_itemStateChanged(ItemEvent itemEvent) {
        Component[] componentArray = this.mainPane_.getComponents();
        this.mainPane_.setBatch(true);
        this.mainPane_.setLayout(new StackedLayout());
        Graph graph = ((Layer)componentArray[1]).getGraph();
        ((CartesianGraph)graph).removeAllXAxes();
        ((CartesianGraph)graph).removeAllYAxes();
        if (this.isApplet_) {
            this.validate();
        } else {
            this.frame.validate();
        }
        this.mainPane_.setBatch(false);
        if (this.tree_ != null && this.tree_.isVisible()) {
            this.tree_.setJPane(this.mainPane_);
            this.tree_.expandTree();
        }
    }

    void grid_itemStateChanged(ItemEvent itemEvent) {
        Component[] componentArray = this.mainPane_.getComponents();
        this.mainPane_.setBatch(true);
        this.mainPane_.setLayout(new GridLayout(2, 0));
        Graph graph = ((Layer)componentArray[0]).getGraph();
        Graph graph2 = ((Layer)componentArray[1]).getGraph();
        Enumeration enumeration = ((CartesianGraph)graph).xAxisElements();
        while (enumeration.hasMoreElements()) {
            ((CartesianGraph)graph2).addXAxis(((Axis)enumeration.nextElement()).copy());
        }
        enumeration = ((CartesianGraph)graph).yAxisElements();
        while (enumeration.hasMoreElements()) {
            ((CartesianGraph)graph2).addYAxis(((Axis)enumeration.nextElement()).copy());
        }
        if (this.isApplet_) {
            this.validate();
        } else {
            this.frame.validate();
        }
        this.mainPane_.setBatch(false);
        if (this.tree_ != null && this.tree_.isVisible()) {
            this.tree_.setJPane(this.mainPane_);
            this.tree_.expandTree();
        }
    }

    void showTree_ActionPerformed(ActionEvent actionEvent) {
        if (this.tree_ == null) {
            this.tree_ = new JClassTree("Classes for LayoutDemo");
        }
        this.tree_.setJPane(this.mainPane_);
        this.tree_.show();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JLayoutDemo.this.showTree) {
                JLayoutDemo.this.showTree_ActionPerformed(actionEvent);
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == JLayoutDemo.this.stacked) {
                JLayoutDemo.this.stacked_itemStateChanged(itemEvent);
            } else if (object == JLayoutDemo.this.grid) {
                JLayoutDemo.this.grid_itemStateChanged(itemEvent);
            }
        }
    }
}

