/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.swing.ColorSwatchIcon;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

abstract class PropertyPanel
extends JComponent
implements DesignListener {
    private PanelHolder pHolder_ = null;
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Font hdrFont_ = new Font("Dialog", 1, 9);
    private Font textFont_ = new Font("Dialog", 0, 9);
    private Insets lInset = new Insets(2, 1, 1, 3);
    private Insets rInset = new Insets(2, 3, 1, 1);
    private static DecimalFormat numberFormat_ = new DecimalFormat("#.##");
    private String dateFormat_ = "yyyy-MM-dd hh:mm";

    public PropertyPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1.setText("Property");
        this.jLabel1.setFont(this.hdrFont_);
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setHorizontalAlignment(4);
        this.setLayout(this.gridBagLayout1);
        this.jLabel3.setText("Value");
        this.jLabel3.setFont(this.hdrFont_);
        this.jLabel3.setForeground(Color.black);
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, this.lInset, 5, 5));
        this.add((Component)this.jLabel3, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, this.rInset, 10, 5));
    }

    abstract void resetFields();

    public void reset() {
        this.removeAll();
        this.resetFields();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.create();
        this.revalidate();
    }

    protected void addProperty(int n, String string, JComponent jComponent, boolean bl) {
        int n2;
        int n3;
        double d;
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(4);
        jLabel.setFont(this.textFont_);
        jComponent.setFont(this.textFont_);
        if (bl) {
            d = 1.0;
            n3 = 12;
            n2 = 18;
        } else {
            d = 0.0;
            n3 = 13;
            n2 = 17;
        }
        this.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, d, n3, 1, this.lInset, 5, 5));
        this.add((Component)jComponent, new GridBagConstraints(1, n, 1, 1, 1.0, d, n2, 2, this.rInset, 5, 5));
    }

    abstract void update();

    abstract void create();

    protected JTextField createTextField(String string, String string2, EventListener eventListener, boolean bl) {
        JTextField jTextField = new JTextField(string);
        jTextField.setActionCommand(string2);
        jTextField.setName(string2);
        jTextField.setEditable(bl);
        if (eventListener != null) {
            if (eventListener instanceof ActionListener) {
                jTextField.addActionListener((ActionListener)eventListener);
            }
            if (eventListener instanceof FocusListener) {
                jTextField.addFocusListener((FocusListener)eventListener);
            }
        }
        return jTextField;
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    protected JLabel createLabel(int n) {
        return new JLabel(Integer.toString(n));
    }

    protected JCheckBox createCheckBox(boolean bl, String string, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox("", bl);
        jCheckBox.setHorizontalTextPosition(2);
        jCheckBox.setActionCommand(string);
        if (actionListener != null) {
            jCheckBox.addActionListener(actionListener);
        }
        return jCheckBox;
    }

    protected JComboBox createComboBox(Vector vector, int n, String string, ActionListener actionListener, boolean bl) {
        return this.createComboBox(vector.toArray(), n, string, actionListener, bl);
    }

    protected JComboBox createComboBox(Object[] objectArray, int n, String string, ActionListener actionListener, boolean bl) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setSelectedIndex(n);
        jComboBox.setActionCommand(string);
        jComboBox.setEditable(bl);
        jComboBox.setEnabled(bl);
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
        return jComboBox;
    }

    protected JButton createSGLabel(SGLabel sGLabel, String string, ActionListener actionListener) {
        if (sGLabel == null) {
            return new JButton("null");
        }
        JButton jButton = new JButton(sGLabel.getText());
        jButton.setFont(sGLabel.getFont());
        jButton.setForeground(sGLabel.getColor());
        jButton.setActionCommand(string);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    protected Point2D.Double parsePoint2D(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t\n\r\f");
        if (stringTokenizer.countTokens() != 2) {
            JOptionPane.showMessageDialog(this, "Four values required", "Illegal Response", 0);
            return null;
        }
        double d = Double.parseDouble(stringTokenizer.nextToken().trim());
        double d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
        return new Point2D.Double(d, d2);
    }

    protected Point parsePoint(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t\n\r\f");
        if (stringTokenizer.countTokens() != 2) {
            JOptionPane.showMessageDialog(this, "Two values required", "Illegal Response", 0);
            return null;
        }
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        return new Point(n, n2);
    }

    protected Dimension parseDimension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t\n\r\f");
        if (stringTokenizer.countTokens() != 2) {
            JOptionPane.showMessageDialog(this, "Two values required", "Illegal Response", 0);
            return null;
        }
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        return new Dimension(n, n2);
    }

    protected Rectangle2D parseBounds(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t\n\r\f");
        if (stringTokenizer.countTokens() != 4) {
            JOptionPane.showMessageDialog(this, "Four values required", "Illegal Response", 0);
            return null;
        }
        double d = Double.parseDouble(stringTokenizer.nextToken().trim());
        double d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
        double d3 = Double.parseDouble(stringTokenizer.nextToken().trim());
        double d4 = Double.parseDouble(stringTokenizer.nextToken().trim());
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    protected SoTRange parseRange(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t\n\r\f");
        if (stringTokenizer.countTokens() != 3) {
            JOptionPane.showMessageDialog(this, "Three values required", "Illegal Response", 0);
            return null;
        }
        SoTRange soTRange = null;
        if (bl) {
            try {
                GeoDate geoDate = new GeoDate(stringTokenizer.nextToken().trim(), this.dateFormat_);
                GeoDate geoDate2 = new GeoDate(stringTokenizer.nextToken().trim(), this.dateFormat_);
                long l = Long.parseLong(stringTokenizer.nextToken().trim()) * 86400000L;
                GeoDate geoDate3 = new GeoDate(l);
                soTRange = new SoTRange.Time(geoDate, geoDate2, geoDate3);
            }
            catch (IllegalTimeValue illegalTimeValue) {
                JOptionPane.showMessageDialog(this, "Illegal Time Value", "Illegal Response", 0);
                return null;
            }
        } else {
            double d = Double.parseDouble(stringTokenizer.nextToken().trim());
            double d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
            double d3 = Double.parseDouble(stringTokenizer.nextToken().trim());
            soTRange = new SoTRange.Double(d, d2, d3);
        }
        return soTRange;
    }

    protected String colorString(Color color) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(color.getRed()).append(", ");
        stringBuffer.append(color.getGreen()).append(", ");
        stringBuffer.append(color.getRed());
        if (color.getAlpha() == 255) {
            stringBuffer.append("]");
        } else {
            stringBuffer.append(", ").append(color.getAlpha()).append("]");
        }
        return stringBuffer.toString();
    }

    protected JButton createColor(Color color, String string, ActionListener actionListener) {
        ColorSwatchIcon colorSwatchIcon = new ColorSwatchIcon(color, 32, 20);
        JButton jButton = new JButton(this.colorString(color), colorSwatchIcon);
        jButton.setActionCommand(string);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    protected void updateColor(JButton jButton, Color color) {
        jButton.setText(this.colorString(color));
        ColorSwatchIcon colorSwatchIcon = new ColorSwatchIcon(color, 32, 20);
        jButton.setIcon(colorSwatchIcon);
    }

    protected JButton createFont(Font font, String string, ActionListener actionListener) {
        JButton jButton = new JButton(font.getName());
        jButton.setFont(font);
        jButton.setActionCommand(string);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    protected void updateFont(JButton jButton, Font font) {
        jButton.setText(font.getName());
        jButton.setFont(font);
    }

    protected void updateSGLabel(JButton jButton, SGLabel sGLabel) {
        jButton.setFont(sGLabel.getFont());
        jButton.setText(sGLabel.getText());
        jButton.setForeground(sGLabel.getColor());
    }

    protected String format(Point point, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(this.format(point.x)).append(", ");
        stringBuffer.append(this.format(point.y));
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String format(Dimension dimension, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(this.format(dimension.width)).append(", ");
        stringBuffer.append(this.format(dimension.height));
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String format(Rectangle2D.Double double_, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(this.format(double_.x)).append(", ");
        stringBuffer.append(this.format(double_.y)).append(", ");
        stringBuffer.append(this.format(double_.width)).append(", ");
        stringBuffer.append(this.format(double_.height));
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String format(Point2D.Double double_, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(this.format(double_.x)).append(", ");
        stringBuffer.append(this.format(double_.y));
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String format(Range2D range2D, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(this.format(range2D.start)).append(", ");
        stringBuffer.append(this.format(range2D.end)).append(", ");
        stringBuffer.append(this.format(range2D.delta));
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String format(SoTRange.Double double_, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(this.format(double_.start)).append(", ");
        stringBuffer.append(this.format(double_.end)).append(", ");
        stringBuffer.append(this.format(double_.delta));
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String format(SoTRange.Time time, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("[");
        }
        stringBuffer.append(time.getStart().toString()).append(", ");
        stringBuffer.append(time.getEnd().toString()).append(", ");
        stringBuffer.append(Long.toString(time.getDelta().getLongTime() / 86400000L));
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String format(SoTRange soTRange, boolean bl) {
        if (soTRange instanceof SoTRange.Float) {
            return this.format((SoTRange.Float)soTRange, bl);
        }
        if (soTRange instanceof SoTRange.Double) {
            return this.format((SoTRange.Double)soTRange, bl);
        }
        if (soTRange instanceof SoTRange.Time) {
            return this.format((SoTRange.Time)soTRange, bl);
        }
        return "";
    }

    protected String format(SoTPoint soTPoint, boolean bl) {
        if (soTPoint == null) {
            return "null";
        }
        return soTPoint.toString();
    }

    protected String format(float f) {
        return numberFormat_.format(f);
    }

    protected String format(float f, DecimalFormat decimalFormat) {
        return decimalFormat.format(f);
    }

    protected String format(double d, DecimalFormat decimalFormat) {
        return decimalFormat.format(d);
    }

    protected String format(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return decimalFormat.format(d);
    }

    protected void paintBorder(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; i += 2) {
            if (i == 0) {
                n = componentArray[0].getBounds().x - this.lInset.left;
                n2 = componentArray[0].getBounds().x + componentArray[0].getBounds().width + this.lInset.right;
                n3 = componentArray[1].getBounds().x + componentArray[1].getBounds().width;
                n5 = componentArray[0].getBounds().y - this.lInset.top;
            }
            int n6 = componentArray[i].getBounds().y - this.lInset.top;
            if (i >= componentArray.length - 2) {
                n4 = n6;
            }
            graphics.drawLine(0, n6, n3, n6);
        }
        graphics.drawLine(n, n5, n, n4);
        graphics.drawLine(n2, n5, n2, n4);
        graphics.drawLine(n3, n5, n3, n4);
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }

    Frame getFrame() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null && window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    public abstract void setExpert(boolean var1);

    public abstract boolean isExpert();
}

