/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.PlotMark;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.util.GeoDate;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class VectorCartesianRenderer
extends CartesianRenderer {
    private VectorAttribute attr_ = null;
    private SGTVector vector_ = null;
    private Collection collection_ = null;
    private float slope_;
    private float xoff_;
    private float yoff_;

    public Attribute getAttribute() {
        return this.attr_;
    }

    private void drawVector(Graphics graphics, SGTVector sGTVector, VectorAttribute vectorAttribute) {
        float[] fArray;
        int n;
        float[] fArray2;
        int n2;
        Layer layer = this.cg_.getLayer();
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.slope_ = (float)layer.getXSlope();
        this.xoff_ = (float)layer.getXOffset();
        this.yoff_ = (float)layer.getYOffset();
        GeneralPath generalPath = null;
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(this.attr_.getWidth(), this.attr_.getCapStyle(), this.attr_.getMiterStyle(), this.attr_.getMiterLimit());
        graphics2D.setStroke(basicStroke);
        float f = (float)this.attr_.getVectorScale();
        float f2 = (float)this.attr_.getHeadScale() * 0.94386f;
        float f3 = (float)((double)f2 * this.attr_.getHeadFixedSize());
        float f4 = (float)this.attr_.getHeadMinSize();
        float f5 = (float)this.attr_.getHeadMaxSize();
        double d = this.attr_.getOffsetAngle() * 0.017453293;
        if (sGTVector.isXTime()) {
            GeoDate[] geoDateArray = sGTVector.getU().getTimeArray();
            n2 = geoDateArray.length;
            fArray2 = new float[n2];
            for (n = 0; n < n2; ++n) {
                fArray2[n] = (float)this.cg_.getXUtoP(geoDateArray[n]);
            }
        } else {
            double[] dArray = sGTVector.getU().getXArray();
            n2 = dArray.length;
            fArray2 = new float[n2];
            for (n = 0; n < n2; ++n) {
                fArray2[n] = (float)this.cg_.getXUtoP(dArray[n]);
            }
        }
        if (sGTVector.isYTime()) {
            GeoDate[] geoDateArray = sGTVector.getU().getTimeArray();
            n2 = geoDateArray.length;
            fArray = new float[n2];
            for (n = 0; n < n2; ++n) {
                fArray[n] = (float)this.cg_.getYUtoP(geoDateArray[n]);
            }
        } else {
            double[] dArray = sGTVector.getU().getYArray();
            n2 = dArray.length;
            fArray = new float[n2];
            for (n = 0; n < n2; ++n) {
                fArray[n] = (float)this.cg_.getYUtoP(dArray[n]);
            }
        }
        double[] dArray = sGTVector.getU().getZArray();
        double[] dArray2 = sGTVector.getV().getZArray();
        int[] nArray = new int[dArray.length];
        int[] nArray2 = new int[dArray.length];
        n = 0;
        int n3 = fArray.length;
        for (int i = 0; i < fArray2.length; ++i) {
            int n4 = i * n3;
            for (int j = 0; j < fArray.length; ++j) {
                float f6;
                float f7;
                int n5 = j + n4;
                if (Double.isNaN(dArray[n5]) || Double.isNaN(dArray2[n5])) continue;
                float f8 = this.xPtoD(fArray2[i]);
                float f9 = this.yPtoD(fArray[j]);
                nArray[n] = (int)f8;
                nArray2[n] = (int)f9;
                double d2 = dArray[n5] * (double)f;
                double d3 = dArray2[n5] * (double)f;
                if (d != 0.0) {
                    f7 = (float)(d2 * Math.cos(d) - d3 * Math.sin(d));
                    f6 = (float)(d3 * Math.cos(d) + d2 * Math.sin(d));
                } else {
                    f7 = (float)d2;
                    f6 = (float)d3;
                }
                float f10 = fArray2[i] + f7;
                float f11 = fArray[j] + f6;
                generalPath = new GeneralPath();
                generalPath.moveTo(f8, f9);
                float f12 = this.xPtoD(f10);
                float f13 = this.yPtoD(f11);
                generalPath.lineTo(f12, f13);
                float f14 = (float)Math.sqrt(f7 * f7 + f6 * f6);
                if ((double)f14 == 0.0) {
                    graphics.drawLine((int)f12, (int)f13, (int)f12, (int)f13);
                } else if (this.attr_.getVectorStyle() != 0) {
                    float f15;
                    float f16;
                    float f17;
                    float f18;
                    float f19;
                    if (this.attr_.getVectorStyle() == 1) {
                        f19 = f3 / f14;
                        f18 = this.xPtoD(f10 + (-f7 - 0.35f * f6) * f19);
                        f17 = this.yPtoD(f11 + (-f6 + 0.35f * f7) * f19);
                        f16 = this.xPtoD(f10 + (-f7 + 0.35f * f6) * f19);
                        f15 = this.yPtoD(f11 + (-f6 - 0.35f * f7) * f19);
                        generalPath.moveTo(f18, f17);
                        generalPath.lineTo(f12, f13);
                        generalPath.lineTo(f16, f15);
                    } else {
                        f19 = f14 >= f5 ? f5 * f2 / f14 : (f14 <= f4 ? f4 * f2 / f14 : f2);
                        f18 = this.xPtoD(f10 + (-f7 - 0.35f * f6) * f19);
                        f17 = this.yPtoD(f11 + (-f6 + 0.35f * f7) * f19);
                        f16 = this.xPtoD(f10 + (-f7 + 0.35f * f6) * f19);
                        f15 = this.yPtoD(f11 + (-f6 - 0.35f * f7) * f19);
                        generalPath.moveTo(f18, f17);
                        generalPath.lineTo(f12, f13);
                        generalPath.lineTo(f16, f15);
                    }
                }
                ++n;
                graphics2D.draw(generalPath);
            }
        }
        graphics2D.setStroke(stroke);
        if (this.attr_.getOriginStyle() == 1) {
            graphics.setColor(this.attr_.getMarkColor());
            this.drawMark(graphics, nArray, nArray2, nArray.length, this.attr_);
        }
    }

    private float xPtoD(float f) {
        return this.slope_ * f + this.xoff_;
    }

    private float yPtoD(float f) {
        return this.yoff_ - this.slope_ * f;
    }

    protected void drawMark(Graphics graphics, int[] nArray, int[] nArray2, int n, VectorAttribute vectorAttribute) {
        Layer layer = this.cg_.getLayer();
        PlotMark plotMark = new PlotMark(vectorAttribute.getMark());
        plotMark.setMarkHeightP(vectorAttribute.getMarkHeightP());
        for (int i = 0; i < n; ++i) {
            plotMark.paintMark(graphics, layer, nArray[i], nArray2[i]);
        }
    }

    public VectorCartesianRenderer(CartesianGraph cartesianGraph) {
        this(cartesianGraph, (SGTVector)null, null);
    }

    public VectorCartesianRenderer(CartesianGraph cartesianGraph, SGTVector sGTVector) {
        this(cartesianGraph, sGTVector, null);
        this.cg_ = cartesianGraph;
        this.vector_ = sGTVector;
    }

    public VectorCartesianRenderer(CartesianGraph cartesianGraph, SGTVector sGTVector, VectorAttribute vectorAttribute) {
        this.cg_ = cartesianGraph;
        this.vector_ = sGTVector;
        this.attr_ = vectorAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public VectorCartesianRenderer(CartesianGraph cartesianGraph, Collection collection, VectorAttribute vectorAttribute) {
        this.cg_ = cartesianGraph;
        this.collection_ = collection;
        this.attr_ = vectorAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public void draw(Graphics graphics) {
        if (this.cg_.clipping_) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.cg_.xTransform_.isSpace()) {
                n8 = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                n8 = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                n7 = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                n6 = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                n6 = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                n5 = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (n8 < n7) {
                n4 = n8;
                n3 = n7 - n8;
            } else {
                n4 = n7;
                n3 = n8 - n7;
            }
            if (n6 < n5) {
                n2 = n6;
                n = n5 - n6;
            } else {
                n2 = n5;
                n = n6 - n5;
            }
            graphics.setClip(n4, n2, n3, n);
        }
        VectorAttribute vectorAttribute = this.attr_ == null ? new VectorAttribute(1.0, this.cg_.getPane().getComponent().getForeground()) : this.attr_;
        graphics.setColor(vectorAttribute.getVectorColor());
        if (this.collection_ == null) {
            this.drawVector(graphics, this.vector_, vectorAttribute);
        } else {
            Enumeration enumeration = this.collection_.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof SGTVector)) continue;
                this.drawVector(graphics, (SGTVector)e, vectorAttribute);
            }
        }
        Rectangle rectangle = this.cg_.getLayer().getPane().getBounds();
        graphics.setClip(rectangle);
    }

    public void setVectorAttribute(VectorAttribute vectorAttribute) {
        if (this.attr_ != null) {
            this.attr_.removePropertyChangeListener(this);
        }
        this.attr_ = vectorAttribute;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public VectorAttribute getVectorAttribute() {
        return this.attr_;
    }

    public boolean hasCollection() {
        return this.collection_ != null;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public SGTVector getVector() {
        return this.vector_;
    }

    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("VectorCartesianRenderer: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public SGTData getDataAt(Point point) {
        return null;
    }
}

