/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.Format;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.SpaceAxis;
import gov.noaa.pmel.util.Point2D;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class PlainAxis
extends SpaceAxis
implements Cloneable {
    static final double TIC_GAP = 0.05;
    static final double TIC_RATIO = 1.3;
    static final double LABEL_RATIO = 1.1;

    public PlainAxis() {
        this("");
    }

    public PlainAxis(String string) {
        super(string);
    }

    public Axis copy() {
        PlainAxis plainAxis;
        try {
            plainAxis = (PlainAxis)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            plainAxis = new PlainAxis();
        }
        plainAxis.registeredAxes_ = new Vector(2, 2);
        plainAxis.registeredTransforms_ = new Vector(2, 2);
        return plainAxis;
    }

    void draw(Graphics graphics) {
        double d = this.uRange_.delta;
        SGLabel sGLabel = this.getTitle();
        if (!this.visible_) {
            return;
        }
        if (Double.isNaN(d)) {
            d = (this.uRange_.end - this.uRange_.start) / 10.0;
        }
        if (sGLabel != null) {
            sGLabel.setLayer(this.graph_.getLayer());
        }
        if (this.lineColor_ == null) {
            graphics.setColor(this.graph_.getLayer().getPane().getComponent().getForeground());
        } else {
            graphics.setColor(this.lineColor_);
        }
        Format format = this.labelFormat_.length() <= 0 ? new Format(Format.computeFormat(this.uRange_.start, this.uRange_.end, this.sigDigits_)) : new Format(this.labelFormat_);
        if (this.orientation_ == 0) {
            double d2;
            double d3;
            int n;
            int n2;
            double d4;
            int n3;
            if (this.uLocation_ == null) {
                n3 = this.graph_.getYUtoD(this.tLocation_.t);
                d4 = this.graph_.getYUtoP(this.tLocation_.t);
            } else {
                n3 = this.graph_.getYUtoD(this.uLocation_.y);
                d4 = this.graph_.getYUtoP(this.uLocation_.y);
            }
            int n4 = this.graph_.getXUtoD(this.uRange_.start);
            int n5 = this.graph_.getXUtoD(this.uRange_.end);
            graphics.drawLine(n4, n3, n5, n3);
            double d5 = d > 0.0 ? 1.0 : -1.0;
            double d6 = (double)((int)(this.uRange_.start / d + (d5 * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * d;
            if (d5 * d6 < d5 * this.uRange_.start) {
                d6 += d;
            }
            int n6 = (int)((this.uRange_.end - d6) / d + 1.0E-5);
            double d7 = d6;
            double d8 = this.graph_.getXUtoP(d7);
            this.drawSmallXTics(graphics, d7, this.uRange_.start, -d, d4);
            this.drawXTic(graphics, d8, d4, this.largeTicHeight_);
            for (n2 = 0; n2 < n6; ++n2) {
                this.drawSmallXTics(graphics, d7, this.uRange_.end, d, d4);
                d8 = this.graph_.getXUtoP(d7 += d);
                this.drawXTic(graphics, d8, d4, this.largeTicHeight_);
            }
            this.drawSmallXTics(graphics, d7, this.uRange_.end, d, d4);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 0) {
                n = 2;
                d3 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d4 + 1.3 * this.largeTicHeight_ : d4 + 0.05;
                d2 = d3 + 1.1 * this.labelHeight_;
            } else {
                n = 0;
                d3 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d4 - 1.3 * this.largeTicHeight_ : d4 - 0.05;
                d2 = d3 - 1.1 * this.labelHeight_;
            }
            d7 = d5 * this.uRange_.start <= 0.0 && d5 * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (d * (double)this.labelInterval_) - 1.0E-5)) * d * (double)this.labelInterval_ : d6;
            n6 = (int)((this.uRange_.end - d7) / (d * (double)this.labelInterval_) + 1.0E-5);
            for (n2 = 0; n2 <= n6; ++n2) {
                d6 = this.graph_.getXUtoP(d7);
                String string = format.form(d7);
                SGLabel sGLabel2 = new SGLabel("coordinate", string, new Point2D.Double(d6, d3));
                sGLabel2.setAlign(n, 1);
                sGLabel2.setOrientation(0);
                sGLabel2.setFont(this.labelFont_);
                sGLabel2.setColor(this.labelColor_);
                sGLabel2.setHeightP(this.labelHeight_);
                sGLabel2.setLayer(this.graph_.getLayer());
                try {
                    sGLabel2.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                d7 += d * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double d9 = (this.uRange_.end + this.uRange_.start) * 0.5;
                d3 = d2;
                d6 = this.graph_.getXUtoP(d9);
                sGLabel.setLocationP(new Point2D.Double(d6, d3));
                sGLabel.setAlign(n, 1);
                sGLabel.setOrientation(0);
                try {
                    sGLabel.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        } else {
            double d10;
            double d11;
            int n;
            int n7;
            double d12;
            int n8;
            if (this.uLocation_ == null) {
                n8 = this.graph_.getXUtoD(this.tLocation_.t);
                d12 = this.graph_.getXUtoP(this.tLocation_.t);
            } else {
                n8 = this.graph_.getXUtoD(this.uLocation_.x);
                d12 = this.graph_.getXUtoP(this.uLocation_.x);
            }
            int n9 = this.graph_.getYUtoD(this.uRange_.start);
            int n10 = this.graph_.getYUtoD(this.uRange_.end);
            graphics.drawLine(n8, n9, n8, n10);
            double d13 = d > 0.0 ? 1.0 : -1.0;
            double d14 = (double)((int)(this.uRange_.start / d + (d13 * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * d;
            if (d13 * d14 < d13 * this.uRange_.start) {
                d14 += d;
            }
            int n11 = (int)((this.uRange_.end - d14) / d + 1.0E-5);
            double d15 = d14;
            double d16 = this.graph_.getYUtoP(d15);
            this.drawSmallYTics(graphics, d12, d15, this.uRange_.start, -d);
            this.drawYTic(graphics, d12, d16, this.largeTicHeight_);
            for (n7 = 0; n7 < n11; ++n7) {
                this.drawSmallYTics(graphics, d12, d15, this.uRange_.end, d);
                d16 = this.graph_.getYUtoP(d15 += d);
                this.drawYTic(graphics, d12, d16, this.largeTicHeight_);
            }
            this.drawSmallYTics(graphics, d12, d15, this.uRange_.end, d);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 1) {
                n = 2;
                d11 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d12 - 1.3 * this.largeTicHeight_ : d12 - 0.05;
                d10 = d11 - 1.1 * this.labelHeight_;
            } else {
                n = 0;
                d11 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d12 + 1.3 * this.largeTicHeight_ : d12 + 0.05;
                d10 = d11 + 1.1 * this.labelHeight_;
            }
            d15 = d13 * this.uRange_.start <= 0.0 && d13 * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (d * (double)this.labelInterval_) - 1.0E-5)) * d * (double)this.labelInterval_ : d14;
            n11 = (int)((this.uRange_.end - d15) / (d * (double)this.labelInterval_) + 1.0E-5);
            for (n7 = 0; n7 <= n11; ++n7) {
                d14 = this.graph_.getYUtoP(d15);
                String string = format.form(d15);
                SGLabel sGLabel3 = new SGLabel("coordinate", string, new Point2D.Double(d11, d14));
                sGLabel3.setAlign(n, 1);
                sGLabel3.setOrientation(1);
                sGLabel3.setFont(this.labelFont_);
                sGLabel3.setColor(this.labelColor_);
                sGLabel3.setHeightP(this.labelHeight_);
                sGLabel3.setLayer(this.graph_.getLayer());
                try {
                    sGLabel3.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                d15 += d * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double d17 = (this.uRange_.end + this.uRange_.start) * 0.5;
                d14 = this.graph_.getYUtoP(d17);
                d11 = d10;
                sGLabel.setLocationP(new Point2D.Double(d11, d14));
                sGLabel.setAlign(n, 1);
                sGLabel.setOrientation(1);
                try {
                    sGLabel.draw(graphics);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.orientation_ == 0) {
            int n5 = this.graph_.getXUtoD(this.uRange_.start);
            double d = this.uLocation_ == null ? this.graph_.getYUtoP(this.tLocation_.t) : this.graph_.getYUtoP(this.uLocation_.y);
            n4 = this.graph_.getXUtoD(this.uRange_.end) - n5;
            n3 = n5;
            double d2 = d;
            double d3 = d;
            if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                d3 += this.largeTicHeight_;
            }
            if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                d2 -= this.largeTicHeight_;
            }
            if (this.labelPosition_ == 0) {
                d3 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d3 + -0.30000000000000004 * this.largeTicHeight_ + this.labelHeight_ : d3 + 0.05 + this.labelHeight_;
            } else if (this.labelPosition_ == 1) {
                d2 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d2 - -0.30000000000000004 * this.largeTicHeight_ - this.labelHeight_ : d2 - 0.05 - this.labelHeight_;
            }
            n2 = this.graph_.getLayer().getYPtoD(d3);
            n = this.graph_.getLayer().getYPtoD(d2) - n2;
        } else {
            int n6 = this.graph_.getYUtoD(this.uRange_.start);
            double d = this.uLocation_ == null ? this.graph_.getXUtoP(this.tLocation_.t) : this.graph_.getXUtoP(this.uLocation_.x);
            n2 = this.graph_.getYUtoD(this.uRange_.end);
            n = n6 - n2;
            double d4 = d;
            double d5 = d;
            if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                d5 += this.largeTicHeight_;
            }
            if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                d4 -= this.largeTicHeight_;
            }
            if (this.labelPosition_ == 0) {
                d5 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d5 + -0.30000000000000004 * this.largeTicHeight_ + this.labelHeight_ : d5 + 0.05 + this.labelHeight_;
            } else if (this.labelPosition_ == 1) {
                d4 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d4 - -0.30000000000000004 * this.largeTicHeight_ - this.labelHeight_ : d4 - 0.05 - this.labelHeight_;
            }
            n3 = this.graph_.getLayer().getXPtoD(d4);
            n4 = this.graph_.getLayer().getXPtoD(d5) - n3;
        }
        return new Rectangle(n3, n2, n4, n);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
    }
}

