/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.TimeAxisStyle;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.TimeRange;

class DayMonthAxis
implements TimeAxisStyle {
    static final int MONTH_TEST__ = 3;
    static final String defaultMinorLabelFormat__ = "dd";
    static final String defaultMajorLabelFormat__ = "yyyy-MM";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 1;

    public double computeLocation(double d, double d2) {
        return (d + d2) * 0.5;
    }

    public void computeDefaults(GeoDate geoDate) {
        long l = geoDate.getTime() / 86400000L;
        this.defaultMinorLabelInterval_ = l > 30L ? 5 : (l > 10L ? 2 : 1);
    }

    public int getMinorValue(GeoDate geoDate) {
        return geoDate.getGMTDay();
    }

    public int getMajorValue(GeoDate geoDate) {
        return geoDate.getGMTMonth();
    }

    public boolean isRoomForMajorLabel(GeoDate geoDate) {
        return geoDate.getTime() / 86400000L > 3L;
    }

    public boolean isStartOfMinor(GeoDate geoDate) {
        return geoDate.getGMTDay() == 1;
    }

    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    public int getDefaultNumSmallTics() {
        return 0;
    }

    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    public GeoDate getStartTime(TimeRange timeRange) {
        GeoDate geoDate = null;
        boolean bl = timeRange.end.after(timeRange.start);
        try {
            if (bl) {
                geoDate = new GeoDate(timeRange.start.getGMTMonth(), timeRange.start.getGMTDay(), timeRange.start.getGMTYear(), 0, 0, 0, 0);
                if (!geoDate.equals(timeRange.start)) {
                    geoDate.increment(1.0, 1);
                }
            } else {
                geoDate = new GeoDate(timeRange.end.getGMTMonth(), timeRange.end.getGMTDay(), timeRange.end.getGMTYear(), 0, 0, 0, 0);
                if (!geoDate.equals(timeRange.end)) {
                    geoDate.increment(1.0, 1);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return geoDate;
    }

    public double getIncrementValue() {
        return 1.0;
    }

    public int getIncrementUnits() {
        return 1;
    }

    public String toString() {
        return "DayMonthAxis";
    }
}

