/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.DataKey;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Ruler;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ColorKey
implements Cloneable,
DataKey,
PropertyChangeListener {
    private SGLabel title_ = null;
    private String ident_;
    private Layer layer_;
    private Ruler scale_ = new Ruler();
    private int valign_;
    private int halign_;
    private int orient_;
    private int style_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private Point2D.Double porigin_;
    private Dimension2D psize_;
    private double[] insets_ = new double[]{0.05, 0.15, 0.05, 0.15};
    private double barWidth_ = 0.2;
    private ColorMap cm_ = null;
    public static final int PLAIN_LINE = 0;
    public static final int RAISED = 1;
    public static final int NO_BORDER = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

    public ColorKey() {
        this(new Rectangle2D.Double(), 2, 0);
    }

    public ColorKey(Rectangle2D.Double double_, int n, int n2) {
        this(new Point2D.Double(double_.x, double_.y), new Dimension2D(double_.width, double_.height), n, n2);
    }

    public ColorKey(Point2D.Double double_, Dimension2D dimension2D, int n, int n2) {
        this.porigin_ = double_;
        this.psize_ = dimension2D;
        this.valign_ = n;
        this.halign_ = n2;
        this.orient_ = 1;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.style_ = 0;
    }

    public LayerChild copy() {
        ColorKey colorKey;
        try {
            colorKey = (ColorKey)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            colorKey = new ColorKey();
        }
        return colorKey;
    }

    public void setSelected(boolean bl) {
        this.selected_ = bl;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelectable(boolean bl) {
        this.selectable_ = bl;
    }

    public boolean isSelectable() {
        return this.selectable_;
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    public void modified(String string) {
        if (this.layer_ != null) {
            this.layer_.modified(string);
        }
    }

    public void setColorMap(ColorMap colorMap) {
        if (this.cm_ == null || !this.cm_.equals(colorMap)) {
            if (this.cm_ != null) {
                this.cm_.removePropertyChangeListener(this);
            }
            this.cm_ = colorMap;
            this.cm_.addPropertyChangeListener(this);
            this.modified("ColorKey: setColorMap()");
        }
    }

    public void addGraph(CartesianRenderer cartesianRenderer, SGLabel sGLabel) throws IllegalArgumentException {
        if (!(cartesianRenderer instanceof GridCartesianRenderer)) {
            throw new IllegalArgumentException("Renderer is not a GridCartesianRenderer");
        }
        GridAttribute gridAttribute = (GridAttribute)((GridCartesianRenderer)cartesianRenderer).getAttribute();
        ColorMap colorMap = gridAttribute.getColorMap();
        this.setColorMap(colorMap);
        this.setTitle(sGLabel);
    }

    public ColorMap getColorMap() {
        return this.cm_;
    }

    public void setBorderStyle(int n) {
        if (this.style_ != n) {
            this.style_ = n;
            this.modified("LineKey: setBorderStyle()");
        }
    }

    public int getBorderStyle() {
        return this.style_;
    }

    public void setAlign(int n, int n2) {
        if (this.valign_ != n || this.halign_ != n2) {
            this.valign_ = n;
            this.halign_ = n2;
            this.modified("ColorKey: setAlign()");
        }
    }

    public void setOrientation(int n) {
        if (this.orient_ != n) {
            this.orient_ = n;
            this.modified("ColorKey: setOrientation()");
        }
    }

    public void setVAlign(int n) {
        if (this.valign_ != n) {
            this.valign_ = n;
            this.modified("ColorKey: setVAlign()");
        }
    }

    public void setHAlign(int n) {
        if (this.halign_ != n) {
            this.halign_ = n;
            this.modified("ColorKey: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public void setLocationP(Point2D.Double double_) {
        if (this.porigin_.x != double_.x || this.porigin_.y != double_.y) {
            this.porigin_.x = double_.x;
            this.porigin_.y = double_.y;
            this.modified("ColorKey: setLocationP()");
        }
    }

    public void setSizeP(Dimension2D dimension2D) {
        if (this.psize_.width != dimension2D.width || this.psize_.height != dimension2D.height) {
            this.psize_.width = dimension2D.width;
            this.psize_.height = dimension2D.height;
            this.modified("ColorKey: setSizeP()");
        }
    }

    public void setBoundsP(Rectangle2D.Double double_) {
        this.setLocationP(new Point2D.Double(double_.x, double_.y));
        this.setSizeP(new Dimension2D(double_.width, double_.height));
    }

    public Rectangle2D.Double getBoundsP() {
        return new Rectangle2D.Double(this.porigin_.x, this.porigin_.y, this.psize_.width, this.psize_.height);
    }

    public Rectangle getBounds() {
        int n = this.layer_.getXPtoD(this.porigin_.x);
        int n2 = this.layer_.getYPtoD(this.porigin_.y);
        int n3 = this.layer_.getXPtoD(this.porigin_.x + this.psize_.width) - n;
        int n4 = this.layer_.getYPtoD(this.porigin_.y - this.psize_.height) - n2;
        switch (this.halign_) {
            case 2: {
                n -= n3;
                break;
            }
            case 1: {
                n -= n3 / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                n2 -= n4;
                break;
            }
            case 1: {
                n2 -= n4 / 2;
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        switch (this.halign_) {
            case 2: {
                n += n3;
                break;
            }
            case 1: {
                n += n3 / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                n2 += n4;
                break;
            }
            case 1: {
                n2 += n4 / 2;
            }
        }
        double d = this.layer_.getXDtoP(n);
        double d2 = this.layer_.getYDtoP(n2);
        if (this.porigin_.x != d || this.porigin_.y != d2) {
            this.porigin_.x = d;
            this.porigin_.y = d2;
            this.modified("ColorKey: setBounds()");
        }
    }

    public void setTitle(SGLabel sGLabel) {
        if (this.title_ == null || !this.title_.equals(sGLabel)) {
            this.title_ = sGLabel;
            this.modified("ColorKey: setTitle()");
        }
    }

    public SGLabel getTitle() {
        return this.title_;
    }

    public Ruler getRuler() {
        return this.scale_;
    }

    public void draw(Graphics graphics) {
        double d;
        if (!this.visible_) {
            return;
        }
        double d2 = this.insets_[0];
        double d3 = this.insets_[2];
        double d4 = this.insets_[1];
        double d5 = this.insets_[3];
        double d6 = this.porigin_.x;
        double d7 = this.porigin_.y;
        switch (this.halign_) {
            case 2: {
                d6 -= this.psize_.width;
                break;
            }
            case 1: {
                d6 -= this.psize_.width / 2.0;
            }
        }
        switch (this.valign_) {
            case 0: {
                d7 -= this.psize_.height;
                break;
            }
            case 1: {
                d7 -= this.psize_.height / 2.0;
            }
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.black);
        switch (this.style_) {
            case 0: {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 1: {
                break;
            }
        }
        if (this.cm_ == null) {
            return;
        }
        Range2D range2D = this.cm_.getRange();
        if (Double.isNaN(range2D.delta)) {
            Range2D range2D2 = Graph.computeRange(range2D.start, range2D.end, 10);
            d = range2D2.delta;
        } else {
            d = range2D.delta;
        }
        if (this.orient_ == 1) {
            this.drawBar(graphics, d6 + d4, d7 + this.psize_.height - d2, this.psize_.width - d4 - d5, this.psize_.height - d2 - d3);
            this.scale_.setOrientation(1);
            this.scale_.setLayer(this.layer_);
            this.scale_.setTitle(this.title_);
            this.scale_.setTicPosition(1);
            this.scale_.setLabelPosition(1);
            this.scale_.setBoundsP(new Rectangle2D.Double(d6 + d4, d7 + this.psize_.height - d2 - this.barWidth_, this.psize_.width - d4 - d5, this.psize_.height - d2 - d3));
            this.scale_.setRangeU(new Range2D(range2D.start, range2D.end, d));
            this.scale_.draw(graphics);
        } else {
            this.drawBar(graphics, d6 + d4, d7 + d3, this.psize_.width - d4 - d5, this.psize_.height - d2 - d3);
            this.scale_.setOrientation(2);
            this.scale_.setLayer(this.layer_);
            this.scale_.setTitle(this.title_);
            this.scale_.setTicPosition(0);
            this.scale_.setLabelPosition(0);
            this.scale_.setBoundsP(new Rectangle2D.Double(d6 + d4 + this.barWidth_, d7 + d3, this.psize_.width - d4 - d5, this.psize_.height - d2 - d3));
            this.scale_.setRangeU(new Range2D(range2D.start, range2D.end, d));
            this.scale_.draw(graphics);
        }
    }

    void drawBar(Graphics graphics, double d, double d2, double d3, double d4) {
        Range2D range2D = this.cm_.getRange();
        if (this.orient_ == 1) {
            int n = this.layer_.getYPtoD(d2 - this.barWidth_) - this.layer_.getYPtoD(d2);
            LinearTransform linearTransform = new LinearTransform(d, d + d3, range2D.start, range2D.end);
            int n2 = this.layer_.getYPtoD(d2);
            int n3 = this.layer_.getXPtoD(linearTransform.getTransP(range2D.start));
            int n4 = this.layer_.getXPtoD(linearTransform.getTransP(range2D.end));
            for (int i = n3; i <= n4; ++i) {
                graphics.setColor(this.cm_.getColor(linearTransform.getTransU(this.layer_.getXDtoP(i))));
                graphics.fillRect(i, n2, 1, n);
            }
        } else {
            int n;
            int n5 = this.layer_.getXPtoD(d + this.barWidth_) - this.layer_.getXPtoD(d);
            LinearTransform linearTransform = new LinearTransform(d2, d2 + d4, range2D.start, range2D.end);
            int n6 = this.layer_.getXPtoD(d);
            int n7 = this.layer_.getYPtoD(linearTransform.getTransP(range2D.start));
            for (int i = n = this.layer_.getYPtoD(linearTransform.getTransP(range2D.end)); i <= n7; ++i) {
                graphics.setColor(this.cm_.getColor(linearTransform.getTransU(this.layer_.getXDtoP(i))));
                graphics.fillRect(n6, i, n5, 1);
            }
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean bl) {
        if (this.visible_ != bl) {
            this.visible_ = bl;
            this.modified("ColorKey: setVisible()");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.modified("ColorKey: propertyChange(" + propertyChangeEvent.getSource().toString() + "[" + propertyChangeEvent.getPropertyName() + "]" + ")");
    }

    public void setColumns(int n) {
    }

    public void setLineLengthP(double d) {
    }
}

