/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AbstractPane;
import gov.noaa.pmel.sgt.AnnotationCartesianRenderer;
import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.VectorCartesianRenderer;
import gov.noaa.pmel.sgt.dm.Annotation;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.sgt.dm.SGTVector;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyChangeListener;

public abstract class CartesianRenderer
implements PropertyChangeListener {
    protected CartesianGraph cg_;

    public static CartesianRenderer getRenderer(CartesianGraph cartesianGraph, SGTData sGTData, Attribute attribute) {
        if (sGTData instanceof SGTPoint) {
            return new PointCartesianRenderer(cartesianGraph, (SGTPoint)sGTData, (PointAttribute)attribute);
        }
        if (sGTData instanceof SGTLine) {
            return new LineCartesianRenderer(cartesianGraph, (SGTLine)sGTData, (LineAttribute)attribute);
        }
        if (sGTData instanceof SGTGrid) {
            return new GridCartesianRenderer(cartesianGraph, (SGTGrid)sGTData, (GridAttribute)attribute);
        }
        if (sGTData instanceof SGTVector) {
            return new VectorCartesianRenderer(cartesianGraph, (SGTVector)sGTData, (VectorAttribute)attribute);
        }
        if (sGTData instanceof Collection) {
            Object e = ((Collection)sGTData).firstElement();
            if (e instanceof SGTPoint) {
                return new PointCartesianRenderer(cartesianGraph, (Collection)sGTData, (PointAttribute)attribute);
            }
            if (e instanceof SGTLine) {
                return new LineCartesianRenderer(cartesianGraph, (Collection)sGTData, (LineAttribute)attribute);
            }
            if (e instanceof SGTVector) {
                return new VectorCartesianRenderer(cartesianGraph, (Collection)sGTData, (VectorAttribute)attribute);
            }
        } else if (sGTData instanceof Annotation) {
            return new AnnotationCartesianRenderer(cartesianGraph, (Annotation)sGTData, null);
        }
        return null;
    }

    public abstract void draw(Graphics var1);

    public abstract Attribute getAttribute();

    public abstract CartesianGraph getCartesianGraph();

    public AbstractPane getPane() {
        return this.cg_.getPane();
    }

    public void modified(String string) {
        if (this.cg_ != null) {
            this.cg_.modified(string);
        }
    }

    public SGTData getDataAt(int n, int n2) {
        return this.getDataAt(new Point(n, n2));
    }

    public abstract SGTData getDataAt(Point var1);
}

