/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.Range;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimeRange;
import java.io.Serializable;

public abstract class SoTRange
implements Serializable,
Cloneable {
    protected SoTRange() {
    }

    public abstract boolean isTime();

    public abstract String toString();

    public abstract boolean equals(SoTRange var1);

    public abstract void add(SoTRange var1);

    public abstract SoTValue getStart();

    public abstract SoTValue getEnd();

    public abstract SoTValue getDelta();

    public abstract Object getStartObject();

    public abstract Object getEndObject();

    public abstract Object getDeltaObject();

    public abstract void setStart(SoTValue var1);

    public abstract void setEnd(SoTValue var1);

    public abstract void setDelta(SoTValue var1);

    public abstract void flipStartAndEnd();

    public abstract boolean isStartOrEndMissing();

    public abstract SoTRange copy();

    public static class Double
    extends SoTRange {
        public double start;
        public double end;
        public double delta;

        public Double() {
            this(java.lang.Double.NaN, java.lang.Double.NaN, java.lang.Double.NaN);
        }

        public Double(double d, double d2) {
            this(d, d2, java.lang.Double.NaN);
        }

        public Double(double d, double d2, double d3) {
            this.start = d;
            this.end = d2;
            this.delta = d3;
        }

        public Double(Range2D range2D) {
            this.start = range2D.start;
            this.end = range2D.end;
            this.delta = range2D.delta;
        }

        public SoTValue getStart() {
            return new SoTValue.Double(this.start);
        }

        public void setStart(SoTValue soTValue) {
            this.start = ((SoTValue.Double)soTValue).getValue();
        }

        public SoTValue getEnd() {
            return new SoTValue.Double(this.end);
        }

        public void setEnd(SoTValue soTValue) {
            this.end = ((SoTValue.Double)soTValue).getValue();
        }

        public SoTValue getDelta() {
            return new SoTValue.Double(this.delta);
        }

        public void setDelta(SoTValue soTValue) {
            this.delta = ((SoTValue.Double)soTValue).getValue();
        }

        public Object getStartObject() {
            return new java.lang.Double(this.start);
        }

        public Object getEndObject() {
            return new java.lang.Double(this.end);
        }

        public Object getDeltaObject() {
            return new java.lang.Double(this.delta);
        }

        public void add(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Double)soTRange).start <= ((Double)soTRange).end) {
                this.start = Math.min(this.start, ((Double)soTRange).start);
                this.end = Math.max(this.end, ((Double)soTRange).end);
            } else {
                this.start = Math.max(this.start, ((Double)soTRange).start);
                this.end = Math.min(this.end, ((Double)soTRange).end);
            }
        }

        public boolean equals(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return false;
            }
            double d = ((Double)soTRange).start;
            double d2 = ((Double)soTRange).end;
            double d3 = ((Double)soTRange).delta;
            if (!java.lang.Double.isNaN(this.start) && !java.lang.Double.isNaN(d)) {
                if (java.lang.Double.isNaN(this.start) || java.lang.Double.isNaN(d)) {
                    return false;
                }
                if (this.start != d) {
                    return false;
                }
            }
            if (!java.lang.Double.isNaN(this.end) && !java.lang.Double.isNaN(d2)) {
                if (java.lang.Double.isNaN(this.end) || java.lang.Double.isNaN(d2)) {
                    return false;
                }
                if (this.end != d2) {
                    return false;
                }
            }
            if (!java.lang.Double.isNaN(this.delta) && !java.lang.Double.isNaN(d3)) {
                if (java.lang.Double.isNaN(this.delta) || java.lang.Double.isNaN(d3)) {
                    return false;
                }
                if (this.delta != d3) {
                    return false;
                }
            }
            return true;
        }

        public boolean isTime() {
            return false;
        }

        public void flipStartAndEnd() {
            double d = this.end;
            this.end = this.start;
            this.start = d;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("[").append(this.start).append(";").append(this.end);
            if (java.lang.Double.isNaN(this.delta)) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append(";").append(this.delta).append("]");
            }
            return stringBuffer.toString();
        }

        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isStartOrEndMissing() {
            return java.lang.Double.isNaN(this.start) || java.lang.Double.isNaN(this.end);
        }
    }

    public static class Float
    extends SoTRange {
        public float start;
        public float end;
        public float delta;

        public Float() {
            this(java.lang.Float.NaN, java.lang.Float.NaN, java.lang.Float.NaN);
        }

        public Float(float f, float f2) {
            this(f, f2, java.lang.Float.NaN);
        }

        public Float(float f, float f2, float f3) {
            this.start = f;
            this.end = f2;
            this.delta = f3;
        }

        public SoTValue getStart() {
            return new SoTValue.Float(this.start);
        }

        public void setStart(SoTValue soTValue) {
            this.start = ((SoTValue.Float)soTValue).getValue();
        }

        public SoTValue getEnd() {
            return new SoTValue.Float(this.end);
        }

        public void setEnd(SoTValue soTValue) {
            this.end = ((SoTValue.Float)soTValue).getValue();
        }

        public SoTValue getDelta() {
            return new SoTValue.Float(this.delta);
        }

        public void setDelta(SoTValue soTValue) {
            this.delta = ((SoTValue.Float)soTValue).getValue();
        }

        public Object getStartObject() {
            return new java.lang.Float(this.start);
        }

        public Object getEndObject() {
            return new java.lang.Float(this.end);
        }

        public Object getDeltaObject() {
            return new java.lang.Float(this.delta);
        }

        public void add(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Float)soTRange).start <= ((Float)soTRange).end) {
                this.start = Math.min(this.start, ((Float)soTRange).start);
                this.end = Math.max(this.end, ((Float)soTRange).end);
            } else {
                this.start = Math.max(this.start, ((Float)soTRange).start);
                this.end = Math.min(this.end, ((Float)soTRange).end);
            }
        }

        public boolean equals(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return false;
            }
            float f = ((Float)soTRange).start;
            float f2 = ((Float)soTRange).end;
            float f3 = ((Float)soTRange).delta;
            if (!java.lang.Float.isNaN(this.start) && !java.lang.Float.isNaN(f)) {
                if (java.lang.Float.isNaN(this.start) || java.lang.Float.isNaN(f)) {
                    return false;
                }
                if (this.start != f) {
                    return false;
                }
            }
            if (!java.lang.Float.isNaN(this.end) && !java.lang.Float.isNaN(f2)) {
                if (java.lang.Float.isNaN(this.end) || java.lang.Float.isNaN(f2)) {
                    return false;
                }
                if (this.end != f2) {
                    return false;
                }
            }
            if (!java.lang.Float.isNaN(this.delta) && !java.lang.Float.isNaN(f3)) {
                if (java.lang.Float.isNaN(this.delta) || java.lang.Float.isNaN(f3)) {
                    return false;
                }
                if (this.delta != f3) {
                    return false;
                }
            }
            return true;
        }

        public boolean isTime() {
            return false;
        }

        public void flipStartAndEnd() {
            float f = this.end;
            this.end = this.start;
            this.start = f;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("[").append(this.start).append(";").append(this.end);
            if (java.lang.Float.isNaN(this.delta)) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append(";").append(this.delta).append("]");
            }
            return stringBuffer.toString();
        }

        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isStartOrEndMissing() {
            return java.lang.Float.isNaN(this.start) || java.lang.Float.isNaN(this.end);
        }
    }

    public static class Short
    extends SoTRange {
        public short start;
        public short end;
        public short delta;

        public Short() {
            this(java.lang.Short.MAX_VALUE, java.lang.Short.MAX_VALUE, java.lang.Short.MAX_VALUE);
        }

        public Short(short s, short s2) {
            this(s, s2, java.lang.Short.MAX_VALUE);
        }

        public Short(short s, short s2, short s3) {
            this.start = s;
            this.end = s2;
            this.delta = s3;
        }

        public SoTValue getStart() {
            return new SoTValue.Short(this.start);
        }

        public void setStart(SoTValue soTValue) {
            this.start = ((SoTValue.Short)soTValue).getValue();
        }

        public SoTValue getEnd() {
            return new SoTValue.Short(this.end);
        }

        public void setEnd(SoTValue soTValue) {
            this.end = ((SoTValue.Short)soTValue).getValue();
        }

        public SoTValue getDelta() {
            return new SoTValue.Short(this.delta);
        }

        public void setDelta(SoTValue soTValue) {
            this.delta = ((SoTValue.Short)soTValue).getValue();
        }

        public Object getStartObject() {
            return new java.lang.Short(this.start);
        }

        public Object getEndObject() {
            return new java.lang.Short(this.end);
        }

        public Object getDeltaObject() {
            return new java.lang.Short(this.delta);
        }

        public void add(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Short)soTRange).start <= ((Short)soTRange).end) {
                this.start = (short)Math.min(this.start, ((Short)soTRange).start);
                this.end = (short)Math.max(this.end, ((Short)soTRange).end);
            } else {
                this.start = (short)Math.max(this.start, ((Short)soTRange).start);
                this.end = (short)Math.min(this.end, ((Short)soTRange).end);
            }
        }

        public boolean equals(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return false;
            }
            short s = ((Short)soTRange).start;
            short s2 = ((Short)soTRange).end;
            short s3 = ((Short)soTRange).delta;
            if (this.start != java.lang.Short.MAX_VALUE && s != java.lang.Short.MAX_VALUE) {
                if (this.start == java.lang.Short.MAX_VALUE || s == java.lang.Short.MAX_VALUE) {
                    return false;
                }
                if (this.start != s) {
                    return false;
                }
            }
            if (this.end != java.lang.Short.MAX_VALUE && s2 != java.lang.Short.MAX_VALUE) {
                if (this.end == java.lang.Short.MAX_VALUE || s2 == java.lang.Short.MAX_VALUE) {
                    return false;
                }
                if (this.end != s2) {
                    return false;
                }
            }
            if (this.delta != java.lang.Short.MAX_VALUE && s3 != java.lang.Short.MAX_VALUE) {
                if (this.delta == java.lang.Short.MAX_VALUE || s3 == java.lang.Short.MAX_VALUE) {
                    return false;
                }
                if (this.delta != s3) {
                    return false;
                }
            }
            return true;
        }

        public boolean isTime() {
            return false;
        }

        public void flipStartAndEnd() {
            short s = this.end;
            this.end = this.start;
            this.start = s;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == java.lang.Short.MAX_VALUE) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append(";").append(this.delta).append("]");
            }
            return stringBuffer.toString();
        }

        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isStartOrEndMissing() {
            return this.start == java.lang.Short.MAX_VALUE || this.end == java.lang.Short.MAX_VALUE;
        }
    }

    public static class Integer
    extends SoTRange {
        public int start;
        public int end;
        public int delta;

        public Integer() {
            this(java.lang.Integer.MAX_VALUE, java.lang.Integer.MAX_VALUE, java.lang.Integer.MAX_VALUE);
        }

        public Integer(int n, int n2) {
            this(n, n2, java.lang.Integer.MAX_VALUE);
        }

        public Integer(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.delta = n3;
        }

        public Integer(Range range) {
            this.start = range.start;
            this.end = range.end;
            this.delta = java.lang.Integer.MAX_VALUE;
        }

        public SoTValue getStart() {
            return new SoTValue.Integer(this.start);
        }

        public void setStart(SoTValue soTValue) {
            this.start = ((SoTValue.Integer)soTValue).getValue();
        }

        public SoTValue getEnd() {
            return new SoTValue.Integer(this.end);
        }

        public void setEnd(SoTValue soTValue) {
            this.end = ((SoTValue.Integer)soTValue).getValue();
        }

        public SoTValue getDelta() {
            return new SoTValue.Integer(this.delta);
        }

        public void setDelta(SoTValue soTValue) {
            this.delta = ((SoTValue.Integer)soTValue).getValue();
        }

        public Object getStartObject() {
            return new java.lang.Integer(this.start);
        }

        public Object getEndObject() {
            return new java.lang.Integer(this.end);
        }

        public Object getDeltaObject() {
            return new java.lang.Integer(this.delta);
        }

        public void add(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Integer)soTRange).start <= ((Integer)soTRange).end) {
                this.start = Math.min(this.start, ((Integer)soTRange).start);
                this.end = Math.max(this.end, ((Integer)soTRange).end);
            } else {
                this.start = Math.max(this.start, ((Integer)soTRange).start);
                this.end = Math.min(this.end, ((Integer)soTRange).end);
            }
        }

        public boolean equals(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return false;
            }
            int n = ((Integer)soTRange).start;
            int n2 = ((Integer)soTRange).end;
            int n3 = ((Integer)soTRange).delta;
            if (this.start != java.lang.Integer.MAX_VALUE && n != java.lang.Integer.MAX_VALUE) {
                if (this.start == java.lang.Integer.MAX_VALUE || n == java.lang.Integer.MAX_VALUE) {
                    return false;
                }
                if (this.start != n) {
                    return false;
                }
            }
            if (this.end != java.lang.Integer.MAX_VALUE && n2 != java.lang.Integer.MAX_VALUE) {
                if (this.end == java.lang.Integer.MAX_VALUE || n2 == java.lang.Integer.MAX_VALUE) {
                    return false;
                }
                if (this.end != n2) {
                    return false;
                }
            }
            if (this.delta != java.lang.Integer.MAX_VALUE && n3 != java.lang.Integer.MAX_VALUE) {
                if (this.delta == java.lang.Integer.MAX_VALUE || n3 == java.lang.Integer.MAX_VALUE) {
                    return false;
                }
                if (this.delta != n3) {
                    return false;
                }
            }
            return true;
        }

        public boolean isTime() {
            return false;
        }

        public void flipStartAndEnd() {
            int n = this.end;
            this.end = this.start;
            this.start = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == java.lang.Integer.MAX_VALUE) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append(";").append(this.delta).append("]");
            }
            return stringBuffer.toString();
        }

        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isStartOrEndMissing() {
            return this.start == java.lang.Integer.MAX_VALUE || this.end == java.lang.Integer.MAX_VALUE;
        }
    }

    public static class Time
    extends SoTRange {
        public long start;
        public long end;
        public long delta;

        public Time() {
            this(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        }

        public Time(long l, long l2) {
            this(l, l2, Long.MAX_VALUE);
        }

        public Time(gov.noaa.pmel.util.GeoDate geoDate, gov.noaa.pmel.util.GeoDate geoDate2) {
            this(geoDate.getTime(), geoDate2.getTime(), Long.MAX_VALUE);
        }

        public Time(long l, long l2, long l3) {
            this.start = l;
            this.end = l2;
            this.delta = l3;
        }

        public Time(gov.noaa.pmel.util.GeoDate geoDate, gov.noaa.pmel.util.GeoDate geoDate2, gov.noaa.pmel.util.GeoDate geoDate3) {
            this(geoDate.getTime(), geoDate2.getTime(), geoDate3.getTime());
        }

        public Time(TimeRange timeRange) {
            this.start = timeRange.start.getTime();
            this.end = timeRange.end.getTime();
            this.delta = timeRange.delta != null ? timeRange.delta.getTime() : Long.MAX_VALUE;
        }

        public Time(GeoDate geoDate) {
            this(geoDate.start, geoDate.end, geoDate.delta);
        }

        public Time(Time time) {
            this(time.start, time.end, time.delta);
        }

        public SoTValue getStart() {
            return new SoTValue.Time(this.start);
        }

        public void setStart(SoTValue soTValue) {
            this.start = ((SoTValue.Time)soTValue).getValue();
        }

        public SoTValue getEnd() {
            return new SoTValue.Time(this.end);
        }

        public void setEnd(SoTValue soTValue) {
            this.end = ((SoTValue.Time)soTValue).getValue();
        }

        public SoTValue getDelta() {
            return new SoTValue.Time(this.delta);
        }

        public void setDelta(SoTValue soTValue) {
            this.delta = ((SoTValue.Time)soTValue).getValue();
        }

        public Object getStartObject() {
            return new Long(this.start);
        }

        public Object getEndObject() {
            return new Long(this.end);
        }

        public Object getDeltaObject() {
            return new Long(this.delta);
        }

        public void add(SoTRange soTRange) {
            if (!soTRange.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Time)soTRange).start <= ((Time)soTRange).end) {
                this.start = Math.min(this.start, ((Time)soTRange).start);
                this.end = Math.max(this.end, ((Time)soTRange).end);
            } else {
                this.start = Math.max(this.start, ((Time)soTRange).start);
                this.end = Math.min(this.end, ((Time)soTRange).end);
            }
        }

        public boolean equals(SoTRange soTRange) {
            if (soTRange.isTime()) {
                return false;
            }
            long l = ((Time)soTRange).start;
            long l2 = ((Time)soTRange).end;
            long l3 = ((Time)soTRange).delta;
            if (this.start != Long.MAX_VALUE && l != Long.MAX_VALUE) {
                if (this.start == Long.MAX_VALUE || l == Long.MAX_VALUE) {
                    return false;
                }
                if (this.start != l) {
                    return false;
                }
            }
            if (this.end != Long.MAX_VALUE && l2 != Long.MAX_VALUE) {
                if (this.end == Long.MAX_VALUE || l2 == Long.MAX_VALUE) {
                    return false;
                }
                if (this.end != l2) {
                    return false;
                }
            }
            if (this.delta != Long.MAX_VALUE && l3 != Long.MAX_VALUE) {
                if (this.delta == Long.MAX_VALUE || l3 == Long.MAX_VALUE) {
                    return false;
                }
                if (this.delta != l3) {
                    return false;
                }
            }
            return true;
        }

        public boolean isTime() {
            return true;
        }

        public void flipStartAndEnd() {
            long l = this.end;
            this.end = this.start;
            this.start = l;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == Long.MAX_VALUE) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append(";").append(this.delta).append("]");
            }
            return stringBuffer.toString();
        }

        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isStartOrEndMissing() {
            return this.start == Long.MAX_VALUE || this.end == Long.MAX_VALUE;
        }
    }

    public static class GeoDate
    extends SoTRange {
        public gov.noaa.pmel.util.GeoDate start = null;
        public gov.noaa.pmel.util.GeoDate end = null;
        public gov.noaa.pmel.util.GeoDate delta = null;

        public GeoDate() {
        }

        public GeoDate(gov.noaa.pmel.util.GeoDate geoDate, gov.noaa.pmel.util.GeoDate geoDate2) {
            this(geoDate, geoDate2, null);
        }

        public GeoDate(gov.noaa.pmel.util.GeoDate geoDate, gov.noaa.pmel.util.GeoDate geoDate2, gov.noaa.pmel.util.GeoDate geoDate3) {
            this.start = geoDate;
            this.end = geoDate2;
            this.delta = geoDate3;
        }

        public GeoDate(TimeRange timeRange) {
            this.start = new gov.noaa.pmel.util.GeoDate(timeRange.start.getTime());
            this.end = new gov.noaa.pmel.util.GeoDate(timeRange.end.getTime());
            this.delta = timeRange.delta != null ? new gov.noaa.pmel.util.GeoDate(timeRange.delta.getTime()) : null;
        }

        public SoTValue getStart() {
            return new SoTValue.GeoDate(this.start);
        }

        public void setStart(SoTValue soTValue) {
            this.start = ((SoTValue.GeoDate)soTValue).getValue();
        }

        public SoTValue getEnd() {
            return new SoTValue.GeoDate(this.end);
        }

        public void setEnd(SoTValue soTValue) {
            this.end = ((SoTValue.GeoDate)soTValue).getValue();
        }

        public SoTValue getDelta() {
            return new SoTValue.GeoDate(this.delta);
        }

        public void setDelta(SoTValue soTValue) {
            this.delta = ((SoTValue.GeoDate)soTValue).getValue();
        }

        public Object getStartObject() {
            return this.start;
        }

        public Object getEndObject() {
            return this.end;
        }

        public Object getDeltaObject() {
            return this.delta;
        }

        public void add(SoTRange soTRange) {
            if (!soTRange.isTime()) {
                return;
            }
            GeoDate geoDate = (GeoDate)soTRange;
            if (geoDate.start.before(this.start)) {
                this.start = geoDate.start;
            }
            if (geoDate.end.after(this.end)) {
                this.end = geoDate.end;
            }
        }

        public boolean equals(SoTRange soTRange) {
            if (!soTRange.isTime()) {
                return false;
            }
            GeoDate geoDate = (GeoDate)soTRange;
            if (this.start != null && geoDate.start != null) {
                if (!this.start.equals(geoDate.start)) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.end != null && geoDate.end != null) {
                if (!this.end.equals(geoDate.end)) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.delta != null && geoDate.delta != null) {
                return this.delta.equals(geoDate.delta);
            }
            return this.delta == null && geoDate.delta == null;
        }

        public boolean isTime() {
            return true;
        }

        public void flipStartAndEnd() {
            gov.noaa.pmel.util.GeoDate geoDate = this.end;
            this.end = this.start;
            this.start = geoDate;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == null) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append(";").append(this.delta).append("]");
            }
            return stringBuffer.toString();
        }

        public SoTRange copy() {
            gov.noaa.pmel.util.GeoDate geoDate = null;
            gov.noaa.pmel.util.GeoDate geoDate2 = null;
            gov.noaa.pmel.util.GeoDate geoDate3 = null;
            if (this.start != null) {
                geoDate = new gov.noaa.pmel.util.GeoDate(this.start.getTime());
            }
            if (this.end != null) {
                geoDate2 = new gov.noaa.pmel.util.GeoDate(this.end.getTime());
            }
            if (this.delta != null) {
                geoDate3 = new gov.noaa.pmel.util.GeoDate(this.delta.getTime());
            }
            GeoDate geoDate4 = new GeoDate(geoDate, geoDate2, geoDate3);
            return geoDate4;
        }

        public boolean isStartOrEndMissing() {
            if (this.start == null || this.end == null) {
                return true;
            }
            return this.start.isMissing() || this.end.isMissing();
        }
    }
}

