/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import java.io.Serializable;

public class Range2D
implements Serializable,
Cloneable {
    public double start;
    public double end;
    public double delta;

    public Range2D() {
        this(Double.NaN, Double.NaN, Double.NaN);
    }

    public Range2D(double d, double d2) {
        this(d, d2, Double.NaN);
    }

    public Range2D(double d, double d2, double d3) {
        this.start = d;
        this.end = d2;
        this.delta = d3;
    }

    public void add(Range2D range2D) {
        this.start = Math.min(this.start, range2D.start);
        this.end = Math.max(this.end, range2D.end);
    }

    public boolean equals(Range2D range2D) {
        if (!Double.isNaN(this.start) && !Double.isNaN(range2D.start)) {
            if (Double.isNaN(this.start) || Double.isNaN(range2D.start)) {
                return false;
            }
            if (this.start != range2D.start) {
                return false;
            }
        }
        if (!Double.isNaN(this.end) && !Double.isNaN(range2D.end)) {
            if (Double.isNaN(this.end) || Double.isNaN(range2D.end)) {
                return false;
            }
            if (this.end != range2D.end) {
                return false;
            }
        }
        if (!Double.isNaN(this.delta) && !Double.isNaN(range2D.delta)) {
            if (Double.isNaN(this.delta) || Double.isNaN(range2D.delta)) {
                return false;
            }
            if (this.delta != range2D.delta) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("[").append(this.start).append(";").append(this.end);
        if (Double.isNaN(this.delta)) {
            stringBuffer.append("]");
        } else {
            stringBuffer.append(";").append(this.delta).append("]");
        }
        return stringBuffer.toString();
    }

    public Range2D copy() {
        try {
            return (Range2D)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

