/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.DataNotFoundException;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.sgt.swing.prop.LogoDialog;
import gov.noaa.pmel.sgt.swing.prop.SGLabelDialog;
import gov.noaa.pmel.sgt.swing.prop.SpaceAxisDialog;
import gov.noaa.pmel.sgt.swing.prop.TimeAxisDialog;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Domain;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.TimeRange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class JGraphicLayout
extends JPane {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final int Z_AXIS = 3;
    protected static double XSIZE_ = 6.0;
    protected static double XMIN_ = 0.6;
    protected static double XMAX_ = 5.4;
    protected static double YSIZE_ = 4.5;
    protected static double YMIN_ = 0.75;
    protected static double YMAX_ = 3.3;
    protected static double MAIN_TITLE_HEIGHT_ = 0.25;
    protected static double TITLE_HEIGHT_ = 0.22;
    protected static double LABEL_HEIGHT_ = 0.18;
    protected static double WARN_HEIGHT_ = 0.15;
    protected static double KEY_HEIGHT_ = 0.16;
    protected static double XKEYSIZE_ = 6.0;
    protected static double YKEYSIZE_ = 12.0;
    protected static Color PANE_COLOR = Color.white;
    protected static Color KEYPANE_COLOR = Color.white;
    protected int base_units_ = 0;
    private JGraphicLayout me_;
    protected JPane keyPane_;
    protected Vector data_;
    protected Hashtable dataAttrMap_ = new Hashtable();
    protected String ident_;
    protected boolean overlayed_;
    protected boolean clipping_ = false;
    protected Image iconImage_ = null;
    protected SGLabel mainTitle_;
    protected SGLabel title2_;
    protected SGLabel title3_;
    protected SymMouse aSymMouse_;
    protected boolean editClasses_ = true;
    protected SGLabelDialog sg_props_;
    protected SpaceAxisDialog pa_props_;
    protected TimeAxisDialog ta_props_;
    protected LogoDialog lo_props_;
    protected PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);

    public JGraphicLayout() {
        this("", null, new Dimension(50, 50));
    }

    public JGraphicLayout(String string, Image image) {
        this(string, image, new Dimension(50, 50));
    }

    public JGraphicLayout(String string, Image image, Dimension dimension) {
        super(string, dimension);
        this.ident_ = string;
        this.overlayed_ = true;
        this.data_ = new Vector(10);
        this.iconImage_ = image;
        this.mainTitle_ = null;
        this.title2_ = null;
        this.title3_ = null;
        this.me_ = this;
        if (this.aSymMouse_ == null) {
            this.aSymMouse_ = new SymMouse();
        }
        this.addMouseListener(this.aSymMouse_);
    }

    public void setId(String string) {
        this.ident_ = string;
    }

    public String getId() {
        return this.ident_;
    }

    public void setTitles(String string, String string2, String string3) {
        if (this.mainTitle_ != null) {
            this.mainTitle_.setText(string);
        }
        if (this.title2_ != null) {
            this.title2_.setText(string2);
        }
        if (this.title3_ != null) {
            this.title3_.setText(string3);
        }
    }

    public void setBaseUnit(int n) {
        this.base_units_ = n;
    }

    public int getBaseUnit() {
        return this.base_units_;
    }

    public void setOverlayed(boolean bl) {
        this.overlayed_ = bl;
    }

    public boolean isOverlayed() {
        return this.overlayed_;
    }

    public Image getIconImage() {
        return this.iconImage_;
    }

    public JPane getKeyPane() {
        return this.keyPane_;
    }

    public boolean isKeyPane() {
        return this.keyPane_ != null;
    }

    public void addData(SGTData sGTData) {
        this.data_.addElement(sGTData);
    }

    public void addAttribute(SGTData sGTData, Attribute attribute) {
        this.dataAttrMap_.put(sGTData, attribute);
    }

    public Attribute getAttribute(SGTData sGTData) throws DataNotFoundException {
        Attribute attribute = (Attribute)this.dataAttrMap_.get(sGTData);
        if (attribute == null) {
            throw new DataNotFoundException();
        }
        return attribute;
    }

    public Attribute findAttribute(String string) {
        Attribute attribute = null;
        Enumeration enumeration = this.dataAttrMap_.elements();
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            if (!attribute.getId().equals(string)) continue;
            return attribute;
        }
        return attribute;
    }

    public abstract void addData(SGTData var1, String var2);

    public abstract String getLocationSummary(SGTData var1);

    public Range2D findRange(SGTLine sGTLine, int n) {
        int n2;
        int n3;
        double[] dArray;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        switch (n) {
            case 1: {
                dArray = sGTLine.getXArray();
                n3 = dArray.length;
                break;
            }
            default: {
                dArray = sGTLine.getYArray();
                n3 = dArray.length;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (Double.isNaN(dArray[n2])) continue;
            d = dArray[n2];
            d2 = dArray[n2];
            bl = true;
            n4 = n2 + 1;
            break;
        }
        if (!bl) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        for (n2 = n4; n2 < n3; ++n2) {
            if (Double.isNaN(dArray[n2])) continue;
            d = Math.min(d, dArray[n2]);
            d2 = Math.max(d2, dArray[n2]);
        }
        return new Range2D(d, d2);
    }

    public SoTRange findSoTRange(SGTLine sGTLine, int n) {
        switch (n) {
            case 1: {
                return sGTLine.getXRange();
            }
            case 2: {
                return sGTLine.getYRange();
            }
        }
        return null;
    }

    public SoTRange findSoTRange(SGTVector sGTVector, int n) {
        int n2;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        switch (n) {
            case 1: {
                return sGTVector.getU().getXRange();
            }
            case 2: {
                return sGTVector.getU().getYRange();
            }
        }
        double[] dArray = sGTVector.getU().getZArray();
        double[] dArray2 = sGTVector.getV().getZArray();
        double[] dArray3 = new double[dArray.length];
        for (n2 = 0; n2 < dArray3.length; ++n2) {
            dArray3[n2] = Math.sqrt(dArray[n2] * dArray[n2] + dArray2[n2] * dArray2[n2]);
        }
        int n4 = dArray3.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (Double.isNaN(dArray3[n2])) continue;
            d = dArray3[n2];
            d2 = dArray3[n2];
            bl = true;
            n3 = n2 + 1;
            break;
        }
        if (!bl) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        for (n2 = n3; n2 < n4; ++n2) {
            if (Double.isNaN(dArray3[n2])) continue;
            d = Math.min(d, dArray3[n2]);
            d2 = Math.max(d2, dArray3[n2]);
        }
        return new SoTRange.Double(d, d2);
    }

    public SoTRange findSoTRange(SGTGrid sGTGrid, GridAttribute gridAttribute, int n) {
        int n2;
        int n3;
        double[] dArray;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        if (gridAttribute.isRaster() && (sGTGrid.isXTime() && n == 1 && !sGTGrid.hasXEdges() || sGTGrid.isYTime() && n == 2 && !sGTGrid.hasYEdges())) {
            GeoDate[] geoDateArray = sGTGrid.getTimeArray();
            int n5 = geoDateArray.length;
            GeoDate[] geoDateArray2 = new GeoDate[n5 + 1];
            geoDateArray2[0] = geoDateArray[0].subtract(geoDateArray[1].subtract(geoDateArray[0]).divide(2.0));
            for (int i = 1; i < n5; ++i) {
                geoDateArray2[i] = geoDateArray[i - 1].add(geoDateArray[i]).divide(2.0);
            }
            geoDateArray2[n5] = geoDateArray[n5 - 1].add(geoDateArray[n5 - 1].subtract(geoDateArray[n5 - 2]).divide(2.0));
            int n6 = geoDateArray2.length;
            return new SoTRange.Time(geoDateArray2[0].getTime(), geoDateArray2[n6 - 1].getTime());
        }
        switch (n) {
            case 1: {
                int n7;
                double[] dArray2;
                if (gridAttribute.isRaster()) {
                    if (sGTGrid.hasXEdges()) {
                        return sGTGrid.getXEdgesRange();
                    }
                    dArray2 = sGTGrid.getXArray();
                    n7 = dArray2.length;
                    dArray = new double[n7 + 1];
                    dArray[0] = dArray2[0] - (dArray2[1] - dArray2[0]) * 0.5;
                    for (n3 = 1; n3 < n7; ++n3) {
                        dArray[n3] = (dArray2[n3 - 1] + dArray2[n3]) * 0.5;
                    }
                    dArray[n7] = dArray2[n7 - 1] + (dArray2[n7 - 1] - dArray2[n7 - 2]) * 0.5;
                    n2 = dArray.length;
                    break;
                }
                return sGTGrid.getXRange();
            }
            case 2: {
                int n7;
                double[] dArray2;
                if (gridAttribute.isRaster()) {
                    if (sGTGrid.hasYEdges()) {
                        return sGTGrid.getYEdgesRange();
                    }
                    dArray2 = sGTGrid.getYArray();
                    n7 = dArray2.length;
                    dArray = new double[n7 + 1];
                    dArray[0] = dArray2[0] - (dArray2[1] - dArray2[0]) * 0.5;
                    for (n3 = 1; n3 < n7; ++n3) {
                        dArray[n3] = (dArray2[n3 - 1] + dArray2[n3]) * 0.5;
                    }
                    dArray[n7] = dArray2[n7 - 1] + (dArray2[n7 - 1] - dArray2[n7 - 2]) * 0.5;
                    n2 = dArray.length;
                    break;
                }
                return sGTGrid.getYRange();
            }
            default: {
                dArray = sGTGrid.getZArray();
                n2 = dArray.length;
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (Double.isNaN(dArray[n3])) continue;
            d = dArray[n3];
            d2 = dArray[n3];
            bl = true;
            n4 = n3 + 1;
            break;
        }
        if (!bl) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        for (n3 = n4; n3 < n2; ++n3) {
            if (Double.isNaN(dArray[n3])) continue;
            d = Math.min(d, dArray[n3]);
            d2 = Math.max(d2, dArray[n3]);
        }
        return new SoTRange.Double(d, d2);
    }

    public Range2D findRange(SGTGrid sGTGrid, GridAttribute gridAttribute, int n) {
        int n2;
        int n3;
        double[] dArray;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        switch (n) {
            case 1: {
                int n5;
                double[] dArray2;
                if (gridAttribute.isRaster()) {
                    if (sGTGrid.hasXEdges()) {
                        dArray = sGTGrid.getXEdges();
                        n3 = dArray.length;
                        break;
                    }
                    dArray2 = sGTGrid.getXArray();
                    n5 = dArray2.length;
                    dArray = new double[n5 + 1];
                    dArray[0] = dArray2[0] - (dArray2[1] - dArray2[0]) * 0.5;
                    for (n2 = 1; n2 < n5; ++n2) {
                        dArray[n2] = (dArray2[n2 - 1] + dArray2[n2]) * 0.5;
                    }
                    dArray[n5] = dArray2[n5 - 1] + (dArray2[n5 - 1] - dArray2[n5 - 2]) * 0.5;
                    n3 = dArray.length;
                    break;
                }
                dArray = sGTGrid.getXArray();
                n3 = dArray.length;
                break;
            }
            case 2: {
                int n5;
                double[] dArray2;
                if (gridAttribute.isRaster()) {
                    if (sGTGrid.hasYEdges()) {
                        dArray = sGTGrid.getYEdges();
                        n3 = dArray.length;
                        break;
                    }
                    dArray2 = sGTGrid.getYArray();
                    n5 = dArray2.length;
                    dArray = new double[n5 + 1];
                    dArray[0] = dArray2[0] - (dArray2[1] - dArray2[0]) * 0.5;
                    for (n2 = 1; n2 < n5; ++n2) {
                        dArray[n2] = (dArray2[n2 - 1] + dArray2[n2]) * 0.5;
                    }
                    dArray[n5] = dArray2[n5 - 1] + (dArray2[n5 - 1] - dArray2[n5 - 2]) * 0.5;
                    n3 = dArray.length;
                    break;
                }
                dArray = sGTGrid.getYArray();
                n3 = dArray.length;
                break;
            }
            default: {
                dArray = sGTGrid.getZArray();
                n3 = dArray.length;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (Double.isNaN(dArray[n2])) continue;
            d = dArray[n2];
            d2 = dArray[n2];
            bl = true;
            n4 = n2 + 1;
            break;
        }
        if (!bl) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        for (n2 = n4; n2 < n3; ++n2) {
            if (Double.isNaN(dArray[n2])) continue;
            d = Math.min(d, dArray[n2]);
            d2 = Math.max(d2, dArray[n2]);
        }
        return new Range2D(d, d2);
    }

    public TimeRange findTimeRange(SGTLine sGTLine) {
        long[] lArray = sGTLine.getGeoDateArray().getTime();
        int n = lArray.length;
        return new TimeRange(lArray[0], lArray[n - 1]);
    }

    public TimeRange findTimeRange(SGTGrid sGTGrid, GridAttribute gridAttribute) {
        long[] lArray;
        if (gridAttribute.isRaster() && (sGTGrid.isXTime() || sGTGrid.isYTime())) {
            if (sGTGrid.hasXEdges() || sGTGrid.hasYEdges()) {
                lArray = sGTGrid.getGeoDateArrayEdges().getTime();
            } else {
                long[] lArray2 = sGTGrid.getGeoDateArray().getTime();
                int n = lArray2.length;
                lArray = new long[n + 1];
                lArray[0] = lArray2[0] - (lArray2[1] - lArray2[0]) / 2L;
                for (int i = 1; i < n; ++i) {
                    lArray[i] = (lArray2[i - 1] + lArray2[i]) / 2L;
                }
                lArray[n] = lArray2[n - 1] + (lArray2[n - 1] - lArray2[n - 2]) / 2L;
            }
        } else {
            lArray = sGTGrid.getGeoDateArray().getTime();
        }
        int n = lArray.length;
        return new TimeRange(lArray[0], lArray[n - 1]);
    }

    public void setClipping(boolean bl) {
        this.clipping_ = bl;
    }

    public boolean isClipping() {
        return this.clipping_;
    }

    public abstract void resetZoom();

    public abstract void setRange(Domain var1) throws PropertyVetoException;

    public Domain getRange() {
        Domain domain = new Domain();
        Range2D range2D = new Range2D();
        Range2D range2D2 = new Range2D();
        Layer layer = this.getFirstLayer();
        Graph graph = layer.getGraph();
        if (graph instanceof CartesianGraph) {
            CartesianGraph cartesianGraph = (CartesianGraph)graph;
            AxisTransform axisTransform = cartesianGraph.getXTransform();
            AxisTransform axisTransform2 = cartesianGraph.getYTransform();
            if (axisTransform.isTime()) {
                domain.setXRange(axisTransform.getTimeRangeU());
            } else {
                domain.setXRange(axisTransform.getRangeU());
            }
            if (axisTransform2.isTime()) {
                domain.setYRange(axisTransform2.getTimeRangeU());
            } else {
                domain.setYRange(axisTransform2.getRangeU());
            }
        }
        return domain;
    }

    public Domain getZoomBoundsU() {
        Domain domain = new Domain();
        Range2D range2D = new Range2D();
        Range2D range2D2 = new Range2D();
        Rectangle rectangle = this.getZoomBounds();
        Layer layer = this.getFirstLayer();
        Graph graph = layer.getGraph();
        if (graph instanceof CartesianGraph) {
            long l;
            long l2;
            double d;
            CartesianGraph cartesianGraph = (CartesianGraph)graph;
            AxisTransform axisTransform = cartesianGraph.getXTransform();
            AxisTransform axisTransform2 = cartesianGraph.getYTransform();
            if (axisTransform.isSpace()) {
                range2D.start = cartesianGraph.getXPtoU(layer.getXDtoP(rectangle.x));
                range2D.end = cartesianGraph.getXPtoU(layer.getXDtoP(rectangle.x + rectangle.width));
                if (range2D.start > range2D.end) {
                    d = range2D.start;
                    range2D.start = range2D.end;
                    range2D.end = d;
                }
                domain.setXRange(range2D);
            } else {
                l2 = cartesianGraph.getXPtoLongTime(layer.getXDtoP(rectangle.x));
                if (l2 > (l = cartesianGraph.getXPtoLongTime(layer.getXDtoP(rectangle.x + rectangle.width)))) {
                    long l3 = l2;
                    l2 = l;
                    l = l3;
                }
                domain.setXRange(new TimeRange(new GeoDate(l2), new GeoDate(l)));
            }
            if (axisTransform2.isSpace()) {
                range2D2.start = cartesianGraph.getYPtoU(layer.getYDtoP(rectangle.y));
                range2D2.end = cartesianGraph.getYPtoU(layer.getYDtoP(rectangle.y + rectangle.height));
                if (range2D2.start > range2D2.end) {
                    d = range2D2.start;
                    range2D2.start = range2D2.end;
                    range2D2.end = d;
                }
                domain.setYRange(range2D2);
            } else {
                l2 = cartesianGraph.getYPtoLongTime(layer.getYDtoP(rectangle.y));
                if (l2 > (l = cartesianGraph.getYPtoLongTime(layer.getYDtoP(rectangle.y + rectangle.height)))) {
                    long l4 = l2;
                    l2 = l;
                    l = l4;
                }
                domain.setYRange(new TimeRange(new GeoDate(l2), new GeoDate(l)));
            }
        }
        return domain;
    }

    protected String getLatString(double d) {
        if (d == 0.0) {
            return "Eq";
        }
        DecimalFormat decimalFormat = new DecimalFormat("##.##N;##.##S");
        return decimalFormat.format(d);
    }

    protected String getLonString(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("###.##W;###.##");
        double d2 = (d + 360.0) % 360.0;
        decimalFormat.setNegativeSuffix("E");
        if (d2 > 180.0) {
            d2 = 360.0 - d2;
        }
        return decimalFormat.format(d2);
    }

    public Collection getData() {
        Collection collection = new Collection(this.ident_ + " Data Collection", this.data_.size());
        Enumeration enumeration = this.data_.elements();
        while (enumeration.hasMoreElements()) {
            collection.addElement(enumeration.nextElement());
        }
        return collection;
    }

    void Layout_MouseRelease(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        Rectangle rectangle = this.getZoomBounds();
        if (rectangle.width <= 1 || rectangle.height <= 1) {
            return;
        }
        Domain domain = this.getZoomBoundsU();
        this.setClipping(true);
        if (this.getFirstLayer().getGraph() instanceof CartesianGraph) {
            try {
                this.setRange(domain);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println("Zoom denied! " + propertyVetoException);
            }
        }
    }

    void Layout_MousePress(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            this.resetZoom();
            this.setClipping(false);
        }
    }

    void Layout_MouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            return;
        }
        Object object = this.getSelectedObject();
        if (object instanceof LineCartesianRenderer) {
            LineCartesianRenderer lineCartesianRenderer = (LineCartesianRenderer)object;
            LineAttribute lineAttribute = lineCartesianRenderer.getLineAttribute();
            if (lineAttribute.getStyle() == 0) {
                lineAttribute.setStyle(3);
            } else if (lineAttribute.getStyle() == 3) {
                lineAttribute.setStyle(0);
            }
        }
        if ((mouseEvent.getModifiers() & 4) != 0 && this.editClasses_) {
            this.showProperties(object);
        }
    }

    void KeyPane_MousePress(MouseEvent mouseEvent) {
    }

    void KeyPane_MouseClicked(MouseEvent mouseEvent) {
        if (this.keyPane_ == null) {
            return;
        }
        Object object = this.keyPane_.getSelectedObject();
        if (object instanceof LineCartesianRenderer) {
            LineCartesianRenderer lineCartesianRenderer = (LineCartesianRenderer)object;
            LineAttribute lineAttribute = lineCartesianRenderer.getLineAttribute();
            if (lineAttribute.getStyle() == 0) {
                lineAttribute.setStyle(3);
            } else if (lineAttribute.getStyle() == 3) {
                lineAttribute.setStyle(0);
            }
        }
        if (this.editClasses_) {
            this.showProperties(object);
        }
    }

    public void setEditClasses(boolean bl) {
        this.editClasses_ = bl;
    }

    public boolean isEditClasses() {
        return this.editClasses_;
    }

    void showProperties(Object object) {
        if (object instanceof SGLabel) {
            if (this.sg_props_ == (SGLabelDialog)null) {
                this.sg_props_ = new SGLabelDialog();
            }
            this.sg_props_.setSGLabel((SGLabel)object, this);
            if (!this.sg_props_.isShowing()) {
                this.sg_props_.show();
            }
        } else if (object instanceof PlainAxis) {
            if (this.pa_props_ == (SpaceAxisDialog)null) {
                this.pa_props_ = new SpaceAxisDialog();
            }
            this.pa_props_.setSpaceAxis((PlainAxis)object, this);
            if (!this.pa_props_.isShowing()) {
                this.pa_props_.show();
            }
        } else if (object instanceof TimeAxis) {
            if (this.ta_props_ == (TimeAxisDialog)null) {
                this.ta_props_ = new TimeAxisDialog();
            }
            this.ta_props_.setTimeAxis((TimeAxis)object, this);
            if (!this.ta_props_.isShowing()) {
                this.ta_props_.show();
            }
        } else if (object instanceof Logo) {
            if (this.lo_props_ == (LogoDialog)null) {
                this.lo_props_ = new LogoDialog();
            }
            this.lo_props_.setLogo((Logo)object, this);
            if (!this.lo_props_.isShowing()) {
                this.lo_props_.show();
            }
        }
    }

    private Frame getFrame() {
        Container container = this;
        while ((container = container.getParent()) != null && !(container instanceof Frame)) {
        }
        if (container == null) {
            container = new Frame();
        }
        return (Frame)container;
    }

    protected void setAllClip(SoTRange soTRange, SoTRange soTRange2) {
        if (soTRange2.isTime()) {
            this.setAllClip(soTRange2.getStart().getLongTime(), soTRange2.getEnd().getLongTime(), ((SoTRange.Double)soTRange).start, ((SoTRange.Double)soTRange).end);
        } else if (soTRange.isTime()) {
            this.setAllClip(soTRange.getStart().getLongTime(), soTRange.getEnd().getLongTime(), ((SoTRange.Double)soTRange2).start, ((SoTRange.Double)soTRange2).end);
        } else {
            this.setAllClip(((SoTRange.Double)soTRange).start, ((SoTRange.Double)soTRange).end, ((SoTRange.Double)soTRange2).start, ((SoTRange.Double)soTRange2).end);
        }
    }

    protected void setAllClip(double d, double d2, double d3, double d4) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            Layer layer = (Layer)componentArray[i];
            ((CartesianGraph)layer.getGraph()).setClip(d, d2, d3, d4);
        }
    }

    protected void setAllClip(GeoDate geoDate, GeoDate geoDate2, double d, double d2) {
        this.setAllClip(geoDate.getTime(), geoDate2.getTime(), d, d2);
    }

    protected void setAllClip(long l, long l2, double d, double d2) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Layer layer = (Layer)componentArray[i];
            ((CartesianGraph)layer.getGraph()).setClip(l, l2, d, d2);
        }
    }

    protected void setAllClipping(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Layer)) continue;
            Layer layer = (Layer)componentArray[i];
            ((CartesianGraph)layer.getGraph()).setClipping(bl);
        }
    }

    public abstract Rectangle2D.Double getKeyBoundsP();

    public abstract void setKeyBoundsP(Rectangle2D.Double var1);

    public Dimension2D getKeyLayerSizeP() {
        if (this.keyPane_ != null) {
            return this.keyPane_.getFirstLayer().getSizeP();
        }
        return null;
    }

    public void setKeyLayerSizeP(Dimension2D dimension2D) {
        if (this.keyPane_ != null) {
            this.keyPane_.getFirstLayer().setSizeP(dimension2D);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!JGraphicLayout.this.isMouseEventsEnabled()) {
                return;
            }
            Object object = mouseEvent.getSource();
            if (object == JGraphicLayout.this.me_) {
                JGraphicLayout.this.Layout_MousePress(mouseEvent);
            } else if (object == JGraphicLayout.this.keyPane_) {
                JGraphicLayout.this.KeyPane_MousePress(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!JGraphicLayout.this.isMouseEventsEnabled()) {
                return;
            }
            Object object = mouseEvent.getSource();
            if (object == JGraphicLayout.this.me_) {
                JGraphicLayout.this.Layout_MouseClicked(mouseEvent);
            } else if (object == JGraphicLayout.this.keyPane_) {
                JGraphicLayout.this.KeyPane_MouseClicked(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!JGraphicLayout.this.isMouseEventsEnabled()) {
                return;
            }
            Object object = mouseEvent.getSource();
            if (object == JGraphicLayout.this.me_) {
                JGraphicLayout.this.Layout_MouseRelease(mouseEvent);
            }
        }
    }
}

