/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class SimpleGrid
implements SGTGrid,
Cartesian,
Cloneable,
Serializable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected GeoDateArray tloc_;
    protected double[] grid_;
    protected double[] xEdges_;
    protected double[] yEdges_;
    protected GeoDateArray tEdges_;
    protected boolean hasXEdges_;
    protected boolean hasYEdges_;
    protected String title_;
    protected SGLabel keyTitle_ = null;
    protected String id_ = null;
    protected boolean xTime_;
    protected boolean yTime_;
    protected SGTMetaData xMetaData_ = null;
    protected SGTMetaData yMetaData_ = null;
    protected SGTMetaData zMetaData_ = null;
    protected SGTGrid associatedData_;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private SoTRange xEdgesRange_ = null;
    private SoTRange yEdgesRange_ = null;
    private Range2D zRange_ = null;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public SimpleGrid() {
        this(null, (double[])null, (double[])null, "");
    }

    public SimpleGrid(double[] dArray, double[] dArray2, double[] dArray3, String string) {
        this.grid_ = dArray;
        this.xloc_ = dArray2;
        this.yloc_ = dArray3;
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(dArray2);
        this.yRange_ = this.computeSoTRange(dArray3);
        this.zRange_ = this.computeRange2D(dArray);
    }

    public SimpleGrid(double[] dArray, GeoDate[] geoDateArray, double[] dArray2, String string) {
        this.grid_ = dArray;
        this.tloc_ = new GeoDateArray(geoDateArray);
        this.yloc_ = dArray2;
        this.title_ = string;
        this.xTime_ = true;
        this.yTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(dArray2);
        this.zRange_ = this.computeRange2D(dArray);
    }

    public SimpleGrid(double[] dArray, double[] dArray2, GeoDate[] geoDateArray, String string) {
        this.grid_ = dArray;
        this.xloc_ = dArray2;
        this.tloc_ = new GeoDateArray(geoDateArray);
        this.title_ = string;
        this.xTime_ = false;
        this.yTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(dArray2);
        this.yRange_ = this.computeSoTRange(this.tloc_);
        this.zRange_ = this.computeRange2D(dArray);
    }

    public SGTData copy() {
        SGTGrid sGTGrid;
        try {
            sGTGrid = (SGTGrid)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            sGTGrid = new SimpleGrid();
        }
        return sGTGrid;
    }

    public double[] getXArray() {
        return this.xloc_;
    }

    public int getXSize() {
        return this.xloc_.length;
    }

    public double[] getYArray() {
        return this.yloc_;
    }

    public int getYSize() {
        return this.yloc_.length;
    }

    public double[] getZArray() {
        return this.grid_;
    }

    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    public int getTSize() {
        return this.tloc_.getLength();
    }

    public boolean isXTime() {
        return this.xTime_;
    }

    public boolean isYTime() {
        return this.yTime_;
    }

    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    public String getTitle() {
        return this.title_;
    }

    public void setAssociatedData(SGTGrid sGTGrid) {
        this.associatedData_ = sGTGrid;
        this.changes_.firePropertyChange("associatedDataModified", null, sGTGrid);
    }

    public SGTGrid getAssociatedData() {
        return this.associatedData_;
    }

    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    public boolean hasXEdges() {
        return this.hasXEdges_;
    }

    public double[] getXEdges() {
        return this.xEdges_;
    }

    public void setXEdges(double[] dArray) {
        this.xEdges_ = dArray;
        this.hasXEdges_ = true;
        this.xEdgesRange_ = this.computeSoTRange(dArray);
    }

    public boolean hasYEdges() {
        return this.hasYEdges_;
    }

    public double[] getYEdges() {
        return this.yEdges_;
    }

    public void setYEdges(double[] dArray) {
        this.yEdges_ = dArray;
        this.hasYEdges_ = true;
        this.yEdgesRange_ = this.computeSoTRange(dArray);
    }

    public GeoDate[] getTimeEdges() {
        return this.tEdges_.getGeoDate();
    }

    public GeoDateArray getGeoDateArrayEdges() {
        return this.tEdges_;
    }

    public void setTimeEdges(GeoDate[] geoDateArray) {
        this.setTimeEdges(new GeoDateArray(geoDateArray));
    }

    public void setTimeEdges(GeoDateArray geoDateArray) {
        this.tEdges_ = geoDateArray;
        if (this.xTime_) {
            this.hasXEdges_ = true;
            this.xEdgesRange_ = this.computeSoTRange(geoDateArray);
        } else if (this.yTime_) {
            this.hasYEdges_ = true;
            this.yEdgesRange_ = this.computeSoTRange(geoDateArray);
        }
    }

    public void setXMetaData(SGTMetaData sGTMetaData) {
        this.xMetaData_ = sGTMetaData;
    }

    public void setYMetaData(SGTMetaData sGTMetaData) {
        this.yMetaData_ = sGTMetaData;
    }

    public void setZMetaData(SGTMetaData sGTMetaData) {
        this.zMetaData_ = sGTMetaData;
    }

    public void setTitle(String string) {
        this.title_ = string;
    }

    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    public void setKeyTitle(SGLabel sGLabel) {
        this.keyTitle_ = sGLabel;
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String string) {
        this.id_ = string;
    }

    public void setXArray(double[] dArray) {
        this.xloc_ = dArray;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setYArray(double[] dArray) {
        this.yloc_ = dArray;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setZArray(double[] dArray) {
        this.grid_ = dArray;
        this.zRange_ = this.computeRange2D(dArray);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(dArray.length));
    }

    public void setTimeArray(GeoDate[] geoDateArray) {
        this.setTimeArray(new GeoDateArray(geoDateArray));
    }

    public void setTimeArray(GeoDateArray geoDateArray) {
        this.tloc_ = geoDateArray;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(geoDateArray);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(geoDateArray);
        }
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(geoDateArray.getLength()));
    }

    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    public Range2D getZRange() {
        return this.zRange_;
    }

    public SoTRange getXEdgesRange() {
        return this.xEdgesRange_;
    }

    public SoTRange getYEdgesRange() {
        return this.yEdgesRange_;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    private SoTRange computeSoTRange(double[] dArray) {
        Range2D range2D = this.computeRange2D(dArray);
        return new SoTRange.Double(range2D.start, range2D.end);
    }

    private SoTRange computeSoTRange(GeoDateArray geoDateArray) {
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        long[] lArray = geoDateArray.getTime();
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == Long.MAX_VALUE) continue;
            l = Math.min(l, lArray[i]);
            l2 = Math.max(l2, lArray[i]);
            ++n;
        }
        if (n == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(l, l2);
    }

    private Range2D computeRange2D(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d = Math.min(d, dArray[i]);
            d2 = Math.max(d2, dArray[i]);
            ++n;
        }
        if (n == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(d, d2);
    }
}

