/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LogAxis;
import gov.noaa.pmel.sgt.LogTransform;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JLogLogDemo
extends JApplet {
    JButton tree_;
    JButton space_;
    JPane mainPane_;

    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(553, 438);
        this.add((Component)this.makeGraph(), "Center");
    }

    public static void main(String[] stringArray) {
        JLogLogDemo jLogLogDemo = new JLogLogDemo();
        JFrame jFrame = new JFrame("Log-Log Demo");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jLogLogDemo.tree_ = new JButton("Tree View");
        MyAction myAction = jLogLogDemo.new MyAction();
        jLogLogDemo.tree_.addActionListener(myAction);
        jPanel.add(jLogLogDemo.tree_);
        jLogLogDemo.space_ = new JButton("Add Mark");
        jLogLogDemo.space_.addActionListener(myAction);
        jPanel.add(jLogLogDemo.space_);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.setSize(553, 438);
        JPane jPane = jLogLogDemo.makeGraph();
        jPane.setBatch(true);
        jFrame.getContentPane().add((Component)jPane, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.pack();
        jFrame.setVisible(true);
        jPane.setBatch(false);
    }

    JPane makeGraph() {
        this.mainPane_ = new JPane("Point Plot Demo", new Dimension(553, 438));
        this.mainPane_.setLayout(new StackedLayout());
        this.mainPane_.setBackground(Color.white);
        Range2D range2D = new Range2D(50.0, 150000.0, 1.25);
        TestData testData = new TestData(11, range2D, 2, 10000.0f, 1.0f, 10.0f);
        SGTData sGTData = testData.getSGTData();
        SoTRange soTRange = sGTData.getYRange();
        double d = 4.0;
        double d2 = 0.6;
        double d3 = 3.5;
        double d4 = 3.0;
        double d5 = 0.6;
        double d6 = 2.75;
        Layer layer = new Layer("Layer 1", new Dimension2D(d, d4));
        this.mainPane_.add(layer);
        CartesianGraph cartesianGraph = new CartesianGraph("Log-Log Graph");
        layer.setGraph(cartesianGraph);
        LogTransform logTransform = new LogTransform(d2, d3, range2D.start, range2D.end);
        LogTransform logTransform2 = new LogTransform(new Range2D(d5, d6), soTRange);
        cartesianGraph.setXTransform(logTransform);
        cartesianGraph.setYTransform(logTransform2);
        String string = "X Label";
        LogAxis logAxis = new LogAxis("Botton Axis");
        logAxis.setRangeU(range2D);
        logAxis.setLocationU(new SoTPoint(new SoTValue.Double(range2D.start), soTRange.getStart()));
        Font font = new Font("Helvetica", 2, 14);
        logAxis.setLabelFont(font);
        SGLabel sGLabel = new SGLabel("xaxis title", string, new Point2D.Double(0.0, 0.0));
        Font font2 = new Font("Helvetica", 0, 14);
        sGLabel.setFont(font2);
        sGLabel.setHeightP(0.2);
        logAxis.setTitle(sGLabel);
        cartesianGraph.addXAxis(logAxis);
        String string2 = "Y Label";
        LogAxis logAxis2 = new LogAxis("Left Axis");
        logAxis2.setRangeU(soTRange);
        logAxis2.setLocationU(new SoTPoint(new SoTValue.Double(range2D.start), soTRange.getStart()));
        logAxis2.setLabelFont(font);
        SGLabel sGLabel2 = new SGLabel("yaxis title", string2, new Point2D.Double(0.0, 0.0));
        Font font3 = new Font("Helvetica", 0, 14);
        sGLabel2.setFont(font3);
        sGLabel2.setHeightP(0.2);
        logAxis2.setTitle(sGLabel2);
        cartesianGraph.addYAxis(logAxis2);
        LineAttribute lineAttribute = new LineAttribute(0, Color.red);
        cartesianGraph.setData(sGTData, lineAttribute);
        return this.mainPane_;
    }

    void tree_actionPerformed(ActionEvent actionEvent) {
        JClassTree jClassTree = new JClassTree();
        jClassTree.setModal(false);
        jClassTree.setJPane(this.mainPane_);
        jClassTree.show();
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JLogLogDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (object == JLogLogDemo.this.tree_) {
                JLogLogDemo.this.tree_actionPerformed(actionEvent);
            }
        }
    }
}

