/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimePoint;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;

public abstract class SpaceAxis
extends Axis {
    protected Range2D uRange_;
    protected Point2D.Double uLocation_;
    protected TimePoint tLocation_;
    static final double TIC_GAP = 0.05;
    static final double TIC_RATIO = 1.3;
    static final double LABEL_RATIO = 1.3;

    protected void updateRegisteredTransforms() {
        if (!this.registeredTransforms_.isEmpty()) {
            Enumeration enumeration = this.registeredTransforms_.elements();
            while (enumeration.hasMoreElements()) {
                AxisTransform axisTransform = (AxisTransform)enumeration.nextElement();
                axisTransform.setRangeP(this.pRange_);
                axisTransform.setRangeU(this.uRange_);
            }
        }
    }

    protected void updateRegisteredAxes() {
        if (!this.registeredAxes_.isEmpty()) {
            Enumeration enumeration = this.registeredAxes_.elements();
            while (enumeration.hasMoreElements()) {
                SpaceAxis spaceAxis = (SpaceAxis)enumeration.nextElement();
                spaceAxis.setRangeU(this.uRange_);
                spaceAxis.setRangeP(this.pRange_);
            }
        }
    }

    protected void drawSmallXTics(Graphics graphics, double d, double d2, double d3, double d4) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d4 + this.smallTicHeight_ : d4;
        double d6 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d4 - this.smallTicHeight_ : d4;
        int n = this.graph_.getLayer().getYPtoD(d5);
        int n2 = this.graph_.getLayer().getYPtoD(d6);
        double d7 = d3 / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double d8 = d + d7 * (double)i;
            if (!((d2 - d8) / d3 >= 0.0)) continue;
            int n3 = this.graph_.getXUtoD(d8);
            graphics.drawLine(n3, n, n3, n2);
        }
    }

    protected void drawSmallYTics(Graphics graphics, double d, double d2, double d3, double d4) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double d5 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? d + this.smallTicHeight_ : d;
        double d6 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? d - this.smallTicHeight_ : d;
        int n = this.graph_.getLayer().getXPtoD(d5);
        int n2 = this.graph_.getLayer().getXPtoD(d6);
        double d7 = d4 / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double d8 = d2 + d7 * (double)i;
            if (!((d3 - d8) / d4 >= 0.0)) continue;
            int n3 = this.graph_.getYUtoD(d8);
            graphics.drawLine(n, n3, n2, n3);
        }
    }

    public SpaceAxis() {
        this("");
    }

    public SpaceAxis(String string) {
        super(string);
        this.space_ = true;
        this.numSmallTics_ = 0;
    }

    public void setSignificantDigits(int n) {
        if (this.sigDigits_ != n) {
            this.sigDigits_ = n;
            this.modified("SpaceAxis: setSignificantDigits()");
        }
    }

    public int getSignificantDigits() {
        return this.sigDigits_;
    }

    public void setLabelInterval(int n) {
        if (this.labelInterval_ != n) {
            this.labelInterval_ = n;
            this.modified("SpaceAxis: setLabelInterval()");
        }
    }

    public int getLabelInterval() {
        return this.labelInterval_;
    }

    public void setLabelFormat(String string) {
        if (this.labelFormat_ == null || !this.labelFormat_.equals(string)) {
            this.labelFormat_ = string == null ? "" : string;
            this.modified("SpaceAxis: setLabelFormat()");
        }
    }

    public String getLabelFormat() {
        return this.labelFormat_;
    }

    public void setRangeU(Range2D range2D) {
        if (this.uRange_ == null || !this.uRange_.equals(range2D)) {
            this.uRange_ = range2D;
            this.updateRegisteredAxes();
            this.updateRegisteredTransforms();
            this.modified("SpaceAxis: setRangeU()");
        }
    }

    public void setRangeU(SoTRange soTRange) {
        this.setRangeU(new Range2D(((SoTRange.Double)soTRange).start, ((SoTRange.Double)soTRange).end, ((SoTRange.Double)soTRange).delta));
    }

    public Range2D getRangeU() {
        return this.uRange_;
    }

    public SoTRange getSoTRangeU() {
        return new SoTRange.Double(this.uRange_);
    }

    public void setDeltaU(double d) {
        if (this.uRange_.delta != d) {
            this.uRange_.delta = d;
            this.modified("SpaceAxis: setDeltaU()");
        }
    }

    public double getDeltaU() {
        return this.uRange_.delta;
    }

    public void setLocationU(TimePoint timePoint) {
        if (this.tLocation_ == null || !this.tLocation_.equals(timePoint)) {
            this.tLocation_ = timePoint;
            this.uLocation_ = null;
            this.modified("SpaceAxis: setLocationU(TimePoint)");
        }
    }

    public void setLocationU(Point2D.Double double_) {
        if (this.uLocation_ == null || !this.uLocation_.equals(double_)) {
            this.uLocation_ = double_;
            this.tLocation_ = null;
            this.modified("SpaceAxis: setLocationU(Point2D)");
        }
    }

    public void setLocationU(SoTPoint soTPoint) {
        if (soTPoint.isXTime() || soTPoint.isYTime()) {
            double d;
            long l;
            if (soTPoint.isXTime()) {
                l = soTPoint.getX().getLongTime();
                d = ((SoTValue.Double)soTPoint.getY()).getValue();
            } else {
                l = soTPoint.getY().getLongTime();
                d = ((SoTValue.Double)soTPoint.getX()).getValue();
            }
            this.setLocationU(new TimePoint(d, new GeoDate(l)));
        } else {
            double d = ((SoTValue.Double)soTPoint.getX()).getValue();
            double d2 = ((SoTValue.Double)soTPoint.getY()).getValue();
            this.setLocationU(new Point2D.Double(d, d2));
        }
    }

    public Point2D.Double getLocationU() {
        return this.uLocation_;
    }

    public TimePoint getTimeLocationU() {
        return this.tLocation_;
    }

    public SoTPoint getSoTLocationU() {
        if (this.tLocation_ == null) {
            return new SoTPoint(this.uLocation_.x, this.uLocation_.y);
        }
        if (this.orientation_ == 0) {
            return new SoTPoint(this.tLocation_.t, this.tLocation_.x);
        }
        return new SoTPoint(this.tLocation_.x, this.tLocation_.t);
    }

    abstract void draw(Graphics var1);

    public abstract Rectangle getBounds();

    public void modified(String string) {
        if (this.graph_ != null) {
            this.graph_.modified(string);
        }
    }
}

