/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.util.Dimension2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JFrame;

public class PlotMark {
    protected int mark_;
    protected int tableSize_ = 51;
    protected int firstPoint_;
    protected int lastPoint_;
    protected double markHeight_;
    protected int fillMark_ = 44;
    protected boolean fill_ = false;
    protected boolean circle_ = false;
    protected static final int[][] markTable = new int[][]{{5, 9}, {11, 15}, {14, 15}, {11, 12}, {26, 31}, {32, 37}, {38, 43}, {44, 49}, {1, 5}, {64, 67}, {5, 15}, {50, 54}, {1, 9}, {55, 63}, {15, 19}, {21, 25}, {50, 53}, {51, 54}, {72, 77}, {84, 98}, {18, 22}, {11, 19}, {64, 66}, {68, 71}, {68, 70}, {78, 83}, {102, 106}, {113, 118}, {119, 124}, {125, 130}, {131, 136}, {105, 110}, {107, 112}, {137, 139}, {99, 106}, {103, 108}, {140, 144}, {140, 147}, {156, 163}, {148, 155}, {170, 183}, {184, 189}, {188, 193}, {164, 169}, {1, 5}, {64, 67}, {55, 63}, {15, 19}, {68, 71}, {164, 169}, {164, 169}};
    protected static final int[] table = new int[]{9, 41, 45, 13, 9, 45, 0, 13, 41, 0, 25, 29, 0, 11, 43, 29, 11, 25, 43, 11, 25, 29, 11, 43, 29, 18, 27, 34, 0, 27, 24, 20, 27, 36, 0, 27, 30, 20, 27, 18, 0, 3, 27, 36, 27, 34, 0, 27, 51, 41, 13, 45, 9, 41, 4, 2, 16, 32, 50, 52, 38, 22, 4, 9, 29, 41, 9, 13, 25, 45, 13, 13, 27, 31, 0, 27, 45, 9, 27, 29, 0, 27, 41, 13, 20, 18, 9, 0, 18, 34, 0, 20, 36, 0, 45, 36, 34, 41, 19, 35, 0, 21, 17, 33, 37, 21, 19, 35, 33, 17, 21, 37, 20, 29, 25, 0, 17, 33, 21, 37, 35, 19, 17, 33, 21, 37, 19, 35, 33, 17, 21, 19, 43, 0, 37, 33, 21, 37, 25, 12, 44, 0, 42, 10, 0, 17, 37, 26, 30, 0, 12, 44, 0, 8, 40, 13, 45, 0, 43, 11, 0, 9, 41, 4, 41, 30, 9, 52, 4, 12, 20, 21, 13, 12, 0, 9, 45, 0, 33, 41, 42, 34, 33, 14, 44, 10, 0, 9, 41, 0, 42, 12, 46, 0, 0, 0, 0, 0, 0, 0};

    public PlotMark(LineAttribute lineAttribute) {
        this.setLineAttribute(lineAttribute);
    }

    public PlotMark(PointAttribute pointAttribute) {
        this.setPointAttribute(pointAttribute);
    }

    public PlotMark(int n) {
        this.setMark(n);
        this.markHeight_ = 0.08;
    }

    public void setPointAttribute(PointAttribute pointAttribute) {
        int n = pointAttribute.getMark();
        this.setMark(n);
        this.markHeight_ = pointAttribute.getMarkHeightP() / 8.0;
    }

    public void setLineAttribute(LineAttribute lineAttribute) {
        int n = lineAttribute.getMark();
        this.setMark(n);
        this.markHeight_ = lineAttribute.getMarkHeightP() / 8.0;
    }

    public void setMark(int n) {
        if (n <= 0) {
            n = 0;
        }
        this.fill_ = n > this.fillMark_;
        boolean bl = this.circle_ = n >= 50;
        if (this.circle_) {
            boolean bl2 = this.fill_ = n == 51;
        }
        if (n > this.tableSize_) {
            n = this.tableSize_;
        }
        this.firstPoint_ = markTable[n - 1][0] - 1;
        this.lastPoint_ = markTable[n - 1][1];
        this.mark_ = n;
    }

    public int getMark() {
        return this.mark_;
    }

    public void setMarkHeightP(double d) {
        this.markHeight_ = d / 8.0;
    }

    public double getMarkHeightP() {
        return this.markHeight_ * 8.0;
    }

    public void paintMark(Graphics graphics, Layer layer, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        double d = layer.getXSlope() * this.markHeight_;
        double d2 = layer.getYSlope() * this.markHeight_;
        if (this.circle_) {
            int n5 = (int)(d * -2.0) + n;
            int n6 = (int)(d * -2.0) + n2;
            int n7 = (int)(d * 4.0) - 1;
            if (this.fill_) {
                graphics.fillOval(n5, n6, n7, n7);
            } else {
                graphics.drawOval(n5, n6, n7, n7);
            }
            return;
        }
        int[] nArray = new int[this.lastPoint_ - this.firstPoint_];
        int[] nArray2 = new int[this.lastPoint_ - this.firstPoint_];
        boolean bl = false;
        int n8 = 0;
        for (int i = this.firstPoint_; i < this.lastPoint_; ++i) {
            int n9 = table[i];
            if (n9 == 0) {
                bl = false;
            } else {
                int n10 = (n9 >> 3) - 3;
                int n11 = -((n9 & 7) - 3);
                int n12 = (int)(d * (double)n10) + n;
                int n13 = (int)(d2 * (double)n11) + n2;
                if (bl) {
                    if (this.fill_) {
                        nArray[n8] = n12;
                        nArray2[n8] = n13;
                        ++n8;
                    } else {
                        graphics.drawLine(n3, n4, n12, n13);
                    }
                }
                bl = true;
                n3 = n12;
                n4 = n13;
            }
            if (!this.fill_) continue;
            graphics.fillPolygon(nArray, nArray2, n8);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Plot Marks");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.setSize(500, 700);
        JPane jPane = new JPane("Plot Mark Pane", jFrame.getSize());
        Layer layer = new Layer("Plot Mark Layer", new Dimension2D(5.0, 7.0));
        jPane.setBatch(true);
        jPane.setLayout(new StackedLayout());
        jFrame.getContentPane().add((Component)jPane, "Center");
        jPane.add(layer);
        jFrame.setVisible(true);
        jPane.setBatch(false);
        PlotMark plotMark = new PlotMark(1);
        Graphics graphics = jPane.getGraphics();
        graphics.setFont(new Font("Helvetica", 0, 18));
        plotMark.setMarkHeightP(0.32);
        int n = jPane.getSize().width;
        int n2 = jPane.getSize().height;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getAscent() / 2;
        int n4 = 100;
        int n5 = 400;
        int n6 = 0;
        int n7 = 1;
        block0: for (int i = 0; i < 13; ++i) {
            n5 = 45 * i + 100;
            for (int j = 0; j < 4; ++j) {
                n4 = 120 * j + 75;
                String string = n7 + ":";
                n6 = fontMetrics.stringWidth(string) + 20;
                graphics.setColor(Color.blue.brighter());
                graphics.drawString(string, n4 - n6, n5);
                plotMark.setMark(n7);
                graphics.setColor(Color.black);
                plotMark.paintMark(graphics, layer, n4, n5 - n3);
                if (++n7 > 51) continue block0;
            }
        }
    }

    public String toString() {
        return "PlotMark: " + this.mark_;
    }
}

