/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.LabelDrawer;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.swing.MRJUtil;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;

public class LabelDrawer2
implements LabelDrawer,
Cloneable {
    private String label_;
    private Color clr_;
    private Font font_;
    private transient Layer layer_;
    private int orient_;
    private int halign_;
    private int valign_;
    private Point dorigin_;
    private Rectangle dbounds_;
    private Point2D.Double porigin_;
    private Rectangle2D.Double pbounds_;
    private Polygon dpolygon_;
    private double angle_;
    private double sinthta_;
    private double costhta_;
    private double height_;
    private boolean visible_;
    private static boolean fixMetrics_ = MRJUtil.fixFontMetrics();
    private int xoff_ = 0;
    private int yoff_ = 0;
    private boolean alwaysAntiAlias_ = true;
    private Rectangle savedBounds_ = null;
    private Point savedLoc_ = null;

    public LabelDrawer2(String string, double d, Point2D.Double double_, int n, int n2) {
        this.label_ = string;
        this.height_ = d;
        this.porigin_ = double_;
        this.valign_ = n;
        this.halign_ = n2;
        this.dbounds_ = new Rectangle();
        this.dorigin_ = new Point(0, 0);
        this.pbounds_ = new Rectangle2D.Double();
    }

    public LabelDrawer copy() {
        LabelDrawer labelDrawer = null;
        return labelDrawer;
    }

    public void draw(Graphics graphics) throws LayerNotFoundException {
        if (this.label_.length() <= 0 || !this.visible_ || graphics == null) {
            return;
        }
        if (this.layer_ == (Layer)null) {
            throw new LayerNotFoundException();
        }
        this.computeBoundsD(graphics);
        if (this.clr_ == null) {
            graphics.setColor(this.layer_.getPane().getComponent().getForeground());
        } else {
            graphics.setColor(this.clr_);
        }
        if (this.orient_ == 0) {
            int n = this.dbounds_.x + this.xoff_;
            int n2 = this.dbounds_.y + this.yoff_;
            this.drawString(graphics, n, n2);
        } else if (this.orient_ == 1) {
            int n = this.dbounds_.x + this.xoff_;
            int n3 = this.dbounds_.y + this.yoff_;
            this.drawString(graphics, n, n3);
        } else {
            int n = this.layer_.getXPtoD(this.porigin_.x);
            int n4 = this.layer_.getYPtoD(this.porigin_.y);
            this.drawString(graphics, n, n4);
        }
    }

    public void setText(String string) {
        this.label_ = string;
    }

    public String getText() {
        return this.label_;
    }

    public void setColor(Color color) {
        this.clr_ = color;
    }

    public Color getColor() {
        return this.clr_;
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public Font getFont() {
        return this.font_;
    }

    public void setLayer(Layer layer) {
        this.layer_ = layer;
        if (this.savedBounds_ != null) {
            this.setBounds(this.savedBounds_.x, this.savedBounds_.y, this.savedBounds_.width, this.savedBounds_.height);
            this.savedBounds_ = null;
        }
        if (this.savedLoc_ != null) {
            this.setLocation(this.savedLoc_);
            this.savedLoc_ = null;
        }
    }

    public Layer getLayer() {
        return this.layer_;
    }

    public void setOrientation(int n) {
        if (this.orient_ != n) {
            if (n == 0) {
                this.costhta_ = 1.0;
                this.sinthta_ = 0.0;
            } else if (n == 1) {
                this.costhta_ = 0.0;
                this.sinthta_ = 1.0;
            }
            this.orient_ = n;
        }
    }

    public int getOrientation() {
        return this.orient_;
    }

    public void setHAlign(int n) {
        this.halign_ = n;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public void setVAlign(int n) {
        this.valign_ = n;
    }

    public int getVAlign() {
        return this.valign_;
    }

    public void setLocation(Point point) {
        if (this.layer_ == null) {
            this.savedLoc_ = new Point(point);
            return;
        }
        this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        if (this.dbounds_.x != point.x || this.dbounds_.y != point.y) {
            this.setBounds(point.x, point.y, this.dbounds_.width, this.dbounds_.height);
        }
    }

    public Point getLocation() {
        if (this.savedLoc_ != null) {
            return this.savedLoc_;
        }
        return this.dorigin_;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.layer_ == null) {
            this.savedBounds_ = new Rectangle(n, n2, n3, n4);
            return;
        }
        Graphics graphics = this.layer_.getPane().getComponent().getGraphics();
        if (graphics == null) {
            return;
        }
        this.font_ = this.computeFontSize(graphics);
        FontRenderContext fontRenderContext = this.getFontRenderContext((Graphics2D)graphics);
        TextLayout textLayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, fontRenderContext) : new TextLayout(this.label_, this.font_, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n7 = (int)rectangle2D.getHeight();
        int n8 = (int)rectangle2D.getWidth();
        int n9 = (int)rectangle2D.getX();
        int n10 = (int)rectangle2D.getY();
        if (fixMetrics_) {
            n10 -= (int)(0.7 * (double)textLayout.getAscent());
        }
        int n11 = (int)textLayout.getAscent();
        if (this.orient_ == 0) {
            int n12 = n3;
            n6 = n;
            n5 = n2 - n10;
            switch (this.valign_) {
                case 0: {
                    n5 -= n11;
                    break;
                }
                case 1: {
                    n5 += n10 + n7 / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    n6 += n12;
                    break;
                }
                case 1: {
                    n6 += n12 / 2;
                    break;
                }
            }
        } else {
            int n13 = n4;
            n5 = n2 + n4;
            n6 = n - n10;
            switch (this.valign_) {
                case 0: {
                    n6 -= n11;
                    break;
                }
                case 1: {
                    n6 -= n11 / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    n5 -= n13;
                    break;
                }
                case 1: {
                    n5 -= n13 / 2;
                    break;
                }
            }
        }
        if (this.dorigin_.x != n6 || this.dorigin_.y != n5) {
            this.dorigin_.x = n6;
            this.dorigin_.y = n5;
            this.porigin_.x = this.layer_.getXDtoP(n6);
            this.porigin_.y = this.layer_.getYDtoP(n5);
        }
    }

    public Rectangle getBounds() {
        if (this.savedBounds_ != null) {
            return this.savedBounds_;
        }
        if (this.layer_ != null) {
            this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        }
        return this.dbounds_;
    }

    public void setLocationP(Point2D.Double double_) {
        this.porigin_ = double_;
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public Rectangle2D.Double getBoundsP() {
        this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        return this.pbounds_;
    }

    public void setAngle(double d) {
        this.angle_ = d;
        double d2 = this.angle_ * Math.PI / 180.0;
        if (Math.abs(d2) < 0.001) {
            this.orient_ = 0;
            this.costhta_ = 1.0;
            this.sinthta_ = 0.0;
        } else if (Math.abs(d2 - 90.0) < 0.001) {
            this.orient_ = 1;
            this.costhta_ = 0.0;
            this.sinthta_ = 1.0;
        } else {
            this.orient_ = 2;
            this.costhta_ = Math.cos(d2);
            this.sinthta_ = Math.sin(d2);
        }
    }

    public double getAngle() {
        return this.angle_;
    }

    public void setHeightP(double d) {
        this.height_ = d;
    }

    public double getHeightP() {
        return this.height_;
    }

    public void setVisible(boolean bl) {
        this.visible_ = bl;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    private void computeBoundsD(Graphics graphics) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        if (graphics == null) {
            return;
        }
        this.font_ = this.computeFontSize(graphics);
        FontRenderContext fontRenderContext = this.getFontRenderContext((Graphics2D)graphics);
        TextLayout textLayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, fontRenderContext) : new TextLayout(this.label_, this.font_, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n = (int)rectangle2D.getHeight();
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getX();
        int n4 = (int)rectangle2D.getY();
        if (fixMetrics_) {
            n4 -= (int)(0.7 * (double)textLayout.getAscent());
        }
        int n5 = (int)textLayout.getAscent();
        int n6 = this.layer_.getXPtoD(this.porigin_.x);
        int n7 = this.layer_.getYPtoD(this.porigin_.y);
        this.dorigin_.x = n6;
        this.dorigin_.y = n7;
        int n8 = n6;
        int n9 = n7;
        switch (this.valign_) {
            case 0: {
                n7 += n5;
                break;
            }
            case 1: {
                n7 -= n4 + n / 2;
                break;
            }
        }
        switch (this.halign_) {
            case 2: {
                n6 -= n2;
                break;
            }
            case 1: {
                n6 -= n2 / 2;
                break;
            }
        }
        if (this.orient_ == 0) {
            this.xoff_ = 0;
            this.yoff_ = -n4;
        } else if (this.orient_ == 1) {
            this.xoff_ = -n4;
            this.yoff_ = n2;
        }
        nArray[0] = n6 + n3;
        nArray[1] = nArray[0];
        nArray[2] = nArray[0] + n2;
        nArray[3] = nArray[2];
        nArray2[0] = n7 + n4;
        nArray2[1] = nArray2[0] + n;
        nArray2[2] = nArray2[1];
        nArray2[3] = nArray2[0];
        for (int i = 0; i < 4; ++i) {
            nArray3[i] = (int)((double)(nArray[i] - n8) * this.costhta_ + (double)(nArray2[i] - n9) * this.sinthta_) + n8;
            nArray4[i] = (int)((double)(nArray2[i] - n9) * this.costhta_ - (double)(nArray[i] - n8) * this.sinthta_) + n9;
        }
        this.dpolygon_ = new Polygon(nArray3, nArray4, 4);
        this.dbounds_ = this.dpolygon_.getBounds();
        this.pbounds_.x = this.layer_.getXDtoP(this.dbounds_.x);
        this.pbounds_.y = this.layer_.getYDtoP(this.dbounds_.y);
        this.pbounds_.width = this.layer_.getXDtoP(this.dbounds_.x + this.dbounds_.width) - this.pbounds_.x;
        this.pbounds_.height = this.pbounds_.y - this.layer_.getYDtoP(this.dbounds_.y + this.dbounds_.height);
    }

    Font computeFontSize(Graphics graphics) {
        FontRenderContext fontRenderContext = this.getFontRenderContext((Graphics2D)graphics);
        if (graphics == null) {
            return this.font_;
        }
        int n = this.layer_.getXPtoD(this.height_) - this.layer_.getXPtoD(0.0);
        int n2 = n - 3;
        Font font = new Font(this.font_.getName(), this.font_.getStyle(), n2);
        TextLayout textLayout = this.label_.length() == 0 ? new TextLayout(" ", font, fontRenderContext) : new TextLayout(this.label_, font, fontRenderContext);
        n = (int)(textLayout.getAscent() + textLayout.getDescent());
        double d = this.layer_.getXDtoP(n) - this.layer_.getXDtoP(0);
        n2 = font.getSize();
        int n3 = (int)((double)n2 * (this.height_ / d));
        for (int i = 1; n2 != n3 && i < 5; ++i) {
            font = new Font(this.font_.getName(), this.font_.getStyle(), n3);
            textLayout = this.label_.length() == 0 ? new TextLayout(" ", font, fontRenderContext) : new TextLayout(this.label_, font, fontRenderContext);
            n = (int)(textLayout.getAscent() + textLayout.getDescent());
            double d2 = this.layer_.getXDtoP(n) - this.layer_.getXDtoP(0);
            double d3 = Math.abs(this.height_ - d);
            double d4 = Math.abs(this.height_ - d2);
            if (Math.abs(n2 - n3) <= 1 && d3 > d4) {
                return font;
            }
            n2 = n3;
            d = d2;
            n3 = (int)((double)n2 * (this.height_ / d));
        }
        return font;
    }

    private void drawString(Graphics graphics, int n, int n2) {
        if (graphics == null) {
            return;
        }
        float f = this.orient_ == 0 ? 0.0f : (this.orient_ == 1 ? -90.0f : -((float)this.angle_));
        RenderingHints renderingHints = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f != 0.0f || this.alwaysAntiAlias_) {
            renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        AttributedString attributedString = new AttributedString(this.label_);
        attributedString.addAttribute(TextAttribute.FONT, this.font_);
        graphics2D.translate(n, n2);
        graphics2D.rotate(Math.PI * (double)f / 180.0);
        graphics2D.drawString(attributedString.getIterator(), 0, 0);
        graphics2D.setTransform(affineTransform);
        if (f != 0.0f || this.alwaysAntiAlias_) {
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public float getStringWidth(Graphics graphics) {
        if (graphics == null) {
            return 0.0f;
        }
        this.font_ = this.computeFontSize(graphics);
        FontRenderContext fontRenderContext = this.getFontRenderContext((Graphics2D)graphics);
        TextLayout textLayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, fontRenderContext) : new TextLayout(this.label_, this.font_, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        return (float)rectangle2D.getWidth();
    }

    public float getStringHeight(Graphics graphics) {
        if (graphics == null) {
            return 0.0f;
        }
        this.font_ = this.computeFontSize(graphics);
        FontRenderContext fontRenderContext = this.getFontRenderContext((Graphics2D)graphics);
        TextLayout textLayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, fontRenderContext) : new TextLayout(this.label_, this.font_, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        return (float)rectangle2D.getHeight();
    }

    FontRenderContext getFontRenderContext(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return null;
        }
        RenderingHints renderingHints = null;
        if (this.angle_ != 0.0 || this.alwaysAntiAlias_) {
            renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.angle_ != 0.0 || this.alwaysAntiAlias_) {
            graphics2D.setRenderingHints(renderingHints);
        }
        return fontRenderContext;
    }
}

