/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLevelsAccess;
import gov.noaa.pmel.sgt.Transform;
import gov.noaa.pmel.sgt.TransformColor;
import gov.noaa.pmel.util.Range2D;
import java.awt.Color;
import java.beans.PropertyChangeListener;

public class CLTransformColorMap
extends ColorMap
implements Cloneable,
PropertyChangeListener,
TransformColor,
ContourLevelsAccess {
    private Transform rTrans_ = null;
    private Transform gTrans_ = null;
    private Transform bTrans_ = null;
    private ContourLevels cl_ = null;

    public CLTransformColorMap(Transform transform, Transform transform2, Transform transform3) {
        this.rTrans_ = transform;
        this.rTrans_.setRangeP(0.0, 1.0);
        this.gTrans_ = transform2;
        this.gTrans_.setRangeP(0.0, 1.0);
        this.bTrans_ = transform3;
        this.bTrans_.setRangeP(0.0, 1.0);
    }

    public ColorMap copy() {
        ColorMap colorMap;
        try {
            colorMap = (ColorMap)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            colorMap = null;
        }
        return colorMap;
    }

    public Color getColor(double d) {
        double d2 = d;
        d2 = (double)this.cl_.getIndex(d2) / (double)this.cl_.getMaximumIndex();
        float f = (float)this.rTrans_.getTransP(d2);
        float f2 = (float)this.gTrans_.getTransP(d2);
        float f3 = (float)this.bTrans_.getTransP(d2);
        return new Color(f, f2, f3);
    }

    public Range2D getRange() {
        return this.cl_.getRange();
    }

    public void setColorTransforms(Transform transform, Transform transform2, Transform transform3) {
        if (!(this.rTrans_.equals(transform) && this.gTrans_.equals(transform2) && this.bTrans_.equals(transform3))) {
            if (this.rTrans_ != null) {
                this.rTrans_.removePropertyChangeListener(this);
            }
            if (this.gTrans_ != null) {
                this.gTrans_.removePropertyChangeListener(this);
            }
            if (this.bTrans_ != null) {
                this.bTrans_.removePropertyChangeListener(this);
            }
            Transform transform4 = this.rTrans_;
            this.rTrans_ = transform;
            this.rTrans_.setRangeP(0.0, 1.0);
            this.firePropertyChange("redColorTransform", transform4, this.rTrans_);
            transform4 = this.gTrans_;
            this.gTrans_ = transform2;
            this.gTrans_.setRangeP(0.0, 1.0);
            this.firePropertyChange("greenColorTransform", transform4, this.gTrans_);
            transform4 = this.bTrans_;
            this.bTrans_ = transform3;
            this.bTrans_.setRangeP(0.0, 1.0);
            this.firePropertyChange("blueColorTransform", transform4, this.bTrans_);
            this.rTrans_.addPropertyChangeListener(this);
            this.gTrans_.addPropertyChangeListener(this);
            this.bTrans_.addPropertyChangeListener(this);
        }
    }

    public void setRedTransform(Transform transform) {
        this.rTrans_ = transform;
    }

    public Transform getRedTransform() {
        return this.rTrans_;
    }

    public void setGreenTransform(Transform transform) {
        this.gTrans_ = transform;
    }

    public Transform getGreenTransform() {
        return this.gTrans_;
    }

    public void setBlueTransform(Transform transform) {
        this.bTrans_ = transform;
    }

    public Transform getBlueTransform() {
        return this.bTrans_;
    }

    public void setContourLevels(ContourLevels contourLevels) {
        if (!this.cl_.equals(contourLevels)) {
            ContourLevels contourLevels2 = this.cl_;
            this.cl_ = contourLevels;
            this.firePropertyChange("contourLevels", contourLevels2, this.cl_);
        }
    }

    public ContourLevels getContourLevels() {
        return this.cl_;
    }

    public boolean equals(ColorMap colorMap) {
        if (colorMap == null || !(colorMap instanceof CLTransformColorMap)) {
            return false;
        }
        if (!this.cl_.equals(((CLTransformColorMap)colorMap).cl_)) {
            return false;
        }
        return this.rTrans_.equals(((CLTransformColorMap)colorMap).rTrans_) && this.gTrans_.equals(((CLTransformColorMap)colorMap).gTrans_) && this.bTrans_.equals(((CLTransformColorMap)colorMap).bTrans_);
    }
}

